<?php
 	/*
     	Name: php4session.session.php3
     	Type: PHP4 Session handler for TWIG
     	Desc: Stores sessions as php4-sessions
     	Originally by: Xavier Roche/Serianet, Oct/2000
     	TODO: Ensure that old sessions are removed (normally done by PHP4)

  	KNOWN PROBLEMS: There seems to be strange session problems (session disconnection) when 
     	using session_set_cookie_params, or other time/path related session functions
     	These problems might be related to some PHP4 old versions (to check)
     	If these problems occurs, define $use_session_settings to false
 	*/

 	/* Use session timeout/path */
 	$use_session_settings = true;	
    
 	if( !session_name() )
		{
		/* Start the session */
		if( $use_session_settings )
			{
		    	session_set_cookie_params( $config["session_expiry"], $config["basedir"], $config["fromdomain"] );
			}

		session_start();
		}

 	if( !isset( $session_context ) ) { $session_context = array(); }
 	if( !isset( $session_session ) ) { $session_session = array(); }

 	/* Register context/session variables */
 	session_register( "session_context" );
 	session_register( "session_session" );

 	/* default sessionid and session cache */
 	$sessionid = 1;
 	$sessioncache = array();

 	Function TWIGGetContext() 
		{
		GLOBAL $twigci, $dbconfig, $config,$session_context,$session_session;
	
		if( !$twigci ) { return array( "feature"=>$config["default_feature"], "action"=>"main" ); }

		$cids = $twigci;

    		$context = $session_context[$cids];
		
	    	if( isset( $context ) )
			{
			//  -xxc- todo : remove old sessions? -xxc-
			return $context;
			}
		else
			{
			TWIGPrintError( "Unable to find context data, please click <a href=\"" . $config["baseurl"] . "\">here</a> to restart twig and try again." );
			exit;
			}
	 	}

	Function TWIGContext( $type = "get", $feature = "", $action = "", $other = "" )
		{
		global $context, $login, $sessionts, $sessionid, $sessioncache, $dbconfig,$session_context,$session_session;

		$tcontext = $context;

		if( $feature ) { $tcontext["feature"] = $feature; }
		if( $action ) { $tcontext["action"] = $action; }

		if( $other )
			{
			$j = count( $other );

			for( $i = 0; $i < $j; $i++ )
				{
				$tcontext[$other[$i]["item"]] = $other[$i]["value"];
				}
			}

		if( serialize($tcontext) == serialize($sessioncache["context"]) )
			{
			$sid = $sessioncache["contextid"];
			}
		else
			{
			$sid = $sessionid;
			$sessionid++;

      			$session_context[$sid]=$tcontext;
      
			$sessioncache["context"] = $tcontext;
			$sessioncache["contextid"] = $sid;
			}

		if( $type == "get" ) { $str .= "&twigci=" .$sid; }
		else { $str .= "<input type=hidden name=twigci value=\"" . $sid . "\">\n"; }

		return $str;
 		}

	Function TWIGSession( $type = "get", $other = "" ) 
		{
		global $session, $login, $sessionts, $sessionid, $sessioncache, $dbconfig,$session_context,$session_session;

		if( $login["username"] )
			{
			$tsession = $session;

			if( $other )
				{
				$j = count( $other );

				for( $i = 0; $i < $j; $i++ )
					{
					$tsession[$other[$i]["item"]] = $other[$i]["value"];
					}
				}
			
			if( serialize($tsession) == serialize($sessioncache["session"]) )
				{
				$sid = $sessioncache["sessionid"];
				}
			else
				{
				$sid = $sessionid;
				$sessionid++;
       
				$session_session[$sid]=$tsession;
				$sessioncache["session"] = $tsession;
				$sessioncache["sessionid"] = $sid;
				}
	
		 	if( $type == "get" ) { $str .= "&twigsi=" . $sid ; }
			else { $str .= "<input type=hidden name=twigsi value=\"" . $sid . "\">\n"; }
			}

		return $str;
		}

	Function TWIGGetSession() 
		{
		GLOBAL $twigsi, $dbconfig, $config,$session_context,$session_session;

		if( !$twigsi ) { return array( "feature"=>"main", "action"=>"main" ); }
	
		$sids = $twigsi;

		$session = $session_session[$sids];

    		if( isset( $session ) )
			{
	      		// --xxc-- todo : delete old sessions --xxc-- 

			return $session;
			}
		else
			{
			TWIGPrintError( "Unable to find session data, please click <a href=\"" . $config["baseurl"] . "\">here</a> to restart twig and try again." );

			exit;
			}
		}

	Function TWIGCleanSession()
		{
		GLOBAL $twigsi, $dbconfig, $config,$session_context,$session_session;

		if( !$twigsi ) { return; }

		$sids = $twigsi;
    		$session_session[$sids]="";
		}

	Function TWIGCleanContext()
		{
		GLOBAL $twigci, $dbconfig, $config,$session_context,$session_session;

		if( !$twigci ) { return; }

		$cids = $twigci;
        
    		$session_context[$cids]="";
		}
?>
