<?php

Function SQLTXTDBDelete( $dbpath, $keys )
	{
	$dbname = trim($keys["FROM"]);

	include( $dbpath . $dbname . ".def.php3" );

	$dbfile = dbase_open( $dbpath . $dbname . ".dbf", 2 );

	if( $dbfile ) 
		{
		$numrec = dbase_numrecords( $dbfile ) + 1;

		$conditions = SQLTXTParseEQ( $keys["WHERE"] );

		for( $i = 1; $i < $numrec; $i++ )
			{
			$dbret = dbase_get_record( $dbfile, $i );

			$delit = SQLTXTCheckConditions( $dbname, $dbret, $conditions, $fieldnames );

			if( $delit ) { $ret = dbase_delete_record( $dbfile, $i ); }
			}

		dbase_close( $dbfile );

		return $ret;
		}
	
	return FALSE;
	}

Function SQLTXTDBInsert( $dbpath, $keys )
	{
	Global $sqltxt_insertid;
	$stemp = split( " ", trim($keys["INTO"]), 2 );

	$dbname = trim( $stemp[0] );

	include( $dbpath . $dbname . ".def.php3" );

	$dbfile = dbase_open( $dbpath . $dbname . ".dbf", 2 );

	$vals = SQLTXTParseValues( $keys["VALUES"] );
	$fields = SQLTXTParseFields( $stemp[1], $fieldnames[$dbname][1] );
	$numfields = count( $fields );

	if( $dbfile ) 
		{
		include( $dbpath . $dbname . ".def.php3" );

		for( $i = 0; $i < $fieldnames[$dbname][0]; $i++ )
			{
			$val[$i] = "";
			
			$fname = $fieldnames[$dbname][1][$i];
			if( $fieldnames[$dbname][4][$fname] == "recnumber" )
				{
				$val[$i] = $sqltxt_insertid = dbase_numrecords( $dbfile ) + 1;
				}
			elseif( $fieldnames[$dbname][4][$fname] == "timestamp" )
				{
				$val[$i] = date( "YmdHis" );
				}
			}

		for( $i = 0; $i < $numfields; $i++ )
			{
			$cf = $fieldnames[$dbname][2][trim(substr($fields[$i],0, 10))] - 1;
			$val[$cf] = $vals[$i];
			}

		$ret = dbase_add_record( $dbfile, $val );

		dbase_close( $dbfile );

		return $ret;
		}
	
	return FALSE;
	}

Function SQLTXTDBUpdate( $dbpath, $keys )
	{
	$dbname = trim($keys["UPDATE"]);

	include( $dbpath . $dbname . ".def.php3" );

	$dbfile = dbase_open( $dbpath . $dbname . ".dbf", 2 );

	$upfields = SQLTXTParseUpdate( $keys["SET"] );
	$numfields = count( $upfields[0] );

	if( $dbfile ) 
		{
		$numrec = dbase_numrecords( $dbfile ) + 1;

		$conditions = SQLTXTParseEQ( $keys["WHERE"] );

		for( $i = 1; $i < $numrec; $i++ )
			{
			$dbret = dbase_get_record( $dbfile, $i );

			$delit = SQLTXTCheckConditions( $dbname, $dbret, $conditions, $fieldnames );

			if( $delit && !$dbret["deleted"] ) 
				{ 
				for( $k = 0; $k < $fieldnames[$dbname][0]; $k++ )
					{
					$val[$k] = $dbret[$k];
				
					$fname = $fieldnames[$dbname][1][$k];
					if( $fieldnames[$dbname][4][$fname] == "timestamp" )
						{
						$val[$k] = date( "YmdHis" );
						}
					}

				for( $k = 0; $k < $numfields; $k++ )
					{
					$cf = $fieldnames[$dbname][2][trim(substr($upfields[0][$k], 0, 10))] - 1;
					$val[$cf] = $upfields[1][$k];
					}

				dbase_replace_record( $dbfile, $val, $i );
				}
			}

		dbase_close( $dbfile );

		return $ret;
		}
	
	return FALSE;
	}

Function DBSwapResults( $fields, &$results, $first, $second )
	{
	$j = count( $fields );

	for( $i = 0; $i < $j; $i++ )
		{
		$temp[$fields[$i]] = $results[$first][$fields[$i]];
		$results[$first][$fields[$i]] = $results[$second][$fields[$i]];
		$results[$second][$fields[$i]] = $temp[$fields[$i]];
		}
	}

Function SQLTXTDBSelect( $dbpath, $keys )
	{
	GLOBAL $DBSortCriteria;

	$dbname = trim($keys["FROM"]);

	include( $dbpath . $dbname . ".def.php3" );

	$retfields = SQLTXTParseFields( $keys["SELECT"], $fieldnames[$dbname][1] );
	$numretfields = count( $retfields );

	$ret[0]["numfields"] = $numretfields;
	$ret[0]["fieldnames"] = $retfields;

	$j = count( $ret[0]["fieldnames"] );

	for( $i = 0; $i < $j; $i++ )
		{
		if( $fieldnames[$dbname][3][$ret[0]["fieldnames"][$i]] )
			{
			$ret[0]["fieldnames"][$i] = $fieldnames[$dbname][3][$ret[0]["fieldnames"][$i]];
			}
		}

	$dbfile = dbase_open( $dbpath . $dbname . ".dbf", 2 );

	if( $dbfile ) 
		{
		$conditions = SQLTXTParseEQ( $keys["WHERE"] );

		$numrec = dbase_numrecords( $dbfile );

		$m = 1;	
		for( $i = 1; $i <= $numrec; $i++ )
			{
			$dbret = dbase_get_record( $dbfile, $i );
	
			if( !$dbret["deleted"] && SQLTXTCheckConditions( $dbname, $dbret, $conditions, $fieldnames ) ) 
				{
				for( $k = 0; $k < $numretfields; $k++ )
					{
					if( $fieldnames[$dbname][3][$retfields[$k]] )
						{
						$ret[$m][$fieldnames[$dbname][3][$retfields[$k]]] = $dbret[$fieldnames[$dbname][2][$retfields[$k]] - 1];
						}
					else
						{
						$ret[$m][$retfields[$k]] = $dbret[$fieldnames[$dbname][2][$retfields[$k]] - 1];
						}
					}
				$m++;
				}
			}

		dbase_close( $dbfile );

		$ret[0]["numrecs"] = $m - 1;

		if( $keys["ORDER"] )
			{
			$sorter = substr( trim($keys["ORDER"]), 3, strlen( $keys["ORDER"] ) - 3 );
			$DBSortCriteria = SQLTXTParseValues( $sorter );

			for( $i = sizeof( $ret ); $i >= 1; $i-- )
			 	{
			        for( $j = 2; $j < $i; $j++ )
			            	{
					if( $keys["DESC"] )
						{
				                if( $ret[$j-1][$DBSortCriteria[0]] < $ret[$j][$DBSortCriteria[0]] )
				                	{
							DBSwapResults( $retfields, $ret, $j-1, $j );
				                	}
						}
					else
						{
				                if( $ret[$j-1][$DBSortCriteria[0]] > $ret[$j][$DBSortCriteria[0]] )
				                	{
							DBSwapResults( $retfields, $ret, $j-1, $j );
				                	}
						}
			            	}
			        }
			}

		return $ret;
		}
	
	return FALSE;
	}

?>
