<?php	// TWIG		Search Feature Module for Meetings ?>
<?php 
 TWIGLoadLanguageFile( "features/meetings/strings/", "", $config["language"] );

 if( !$global )
 	{
	echo "<form action=" . $config["baseurl"] . " method=post>\n";
	echo TWIGSession( "put" );
	echo TWIGContext( "put" );

	$entry = 0;

	$tableheaders = array( $TWIGphrase["Item"], "&nbsp", $TWIGphrase["Criteria"] );

 	if( !isset( $search_groups ) )
 		{
		$search_groups = GetPref( "dgroup", $dbconfig["meetings_prefs_table"], $config["defaults"]["meetings"]["dgroup"] );
		}
 	$temp = "<select name=search_groups>\n";
 	$temp .= TWIGGroupsSelect( $login["username"], $search_groups, 1 );
 	$temp .= "</select>\n";
	$tablecontents[$entry] = array( array( "contents"=>"<b>" . $TWIGphrase["Group"] . ":</b>", "align"=>"right" ), "&nbsp", $temp ); $entry++;

	$temp = "<input type=text name=search_name value=" . stripslashes( $search_name ) . ">\n";
	$tablecontents[$entry] = array( array( "contents"=>"<b>" . $TWIGphrase["Name"] . ":</b>", "align"=>"right" ), "&nbsp", $temp ); $entry++;

	$temp = "<input type=text name=search_description value=" . stripslashes( $search_description ) . ">\n";
	$tablecontents[$entry] = array( array( "contents"=>"<b>" . $TWIGphrase["Description"] . ":</b>", "align"=>"right" ), "&nbsp", $temp ); $entry++;

	$temp = "<input type=text name=search_minutes value=" . stripslashes( $search_minutes ) . ">\n";
	$tablecontents[$entry] = array( array( "contents"=>"<b>" . $TWIGphrase["Minutes"] . ":</b>", "align"=>"right" ), "&nbsp", $temp ); $entry++;

	$temp = "<input type=text name=search_conclusion value=" . stripslashes( $search_conclusion ) . ">\n";
	$tablecontents[$entry] = array( array( "contents"=>"<b>" . $TWIGphrase["Conclusion"] . ":</b>", "align"=>"right" ), "&nbsp", $temp ); $entry++;

	$temp = "<input type=text name=search_actionitems value=" . stripslashes( $search_actionitems ) . ">\n";
	$tablecontents[$entry] = array( array( "contents"=>"<b>" . $TWIGphrase["Action Items"] . ":</b>", "align"=>"right" ), "&nbsp", $temp ); $entry++;

 	list( $search_afterHour, $search_afterMinute, $extra_afterDays ) = TWIGTimeCleanup( $search_afterHour, $search_afterMinute, $search_afterAMPM );
 	list( $search_afterYear, $search_afterMonth, $search_afterDay )  = TWIGDateCleanup( $search_afterYear, $search_afterMonth, $search_afterDay, $extra_afterDays );
 	$temp = TWIGTimeSelector( "search_after", $search_afterHour, $search_afterMinute );
 	$temp .= TWIGDateSelector( "search_after", $search_afterYear, $search_afterMonth, $search_afterDay );
 	$tablecontents[$entry] = array( array( "contents"=>"<b>" . $TWIGphrase["After date"] . ":</b>", "align"=>"right" ), "&nbsp", $temp ); $entry++;

 	list( $search_beforeHour, $search_beforeMinute, $extra_beforeDays ) = TWIGTimeCleanup( $search_beforeHour, $search_beforeMinute, $search_beforeAMPM );
 	list( $search_beforeYear, $search_beforeMonth, $search_beforeDay )  = TWIGDateCleanup( $search_beforeYear, $search_beforeMonth, $search_beforeDay, $extra_beforeDays);
 	$temp = TWIGTimeSelector( "search_before", $search_beforeHour, $search_beforeMinute );
 	$temp .= TWIGDateSelector( "search_before", $search_beforeYear, $search_beforeMonth, $search_beforeDay );
 	$tablecontents[$entry] = array( array( "contents"=>"<b>" . $TWIGphrase["Before date"] . ":</b>", "align"=>"right" ), "&nbsp", $temp ); $entry++;

	echo "<table><tr><td>\n";
	echo TWIGGenerateTable( $tableheaders, $tablecontents );
	echo "</td></tr>";
	echo "<tr><td align=center><input type=submit name=search value=\"" . $TWIGphrase["Search"] . "\">";

	echo "</td></tr></table>\n";
	echo "</form>\n";
	}

 unset( $tableheaders );
 unset( $tablecontents );

 if( $search ) 
	{
	// Yeah, do the search

	// Build a WHERE clause
	$searchquery = "";
	if( $global )
		{
		if( $search_text )
			{
			// The first four characters are going away anyhow.
			// Might as well have a little fun ;-)
			$searchquery .= "Bla ( item LIKE '%$search_text%' ";
			$searchquery .= "OR description LIKE '%$search_text%' ";
			$searchquery .= "OR minutes LIKE '%$search_text%' ";
			$searchquery .= "OR conclusion LIKE '%$search_text%' ";
			$searchquery .= "OR actionitems LIKE '%$search_text%' )";
			}
		}
	else
		{
		if( $search_name )
			{
			$searchquery .= "AND item LIKE '%$search_name%' ";
			}
		if( $search_description )
			{
			$searchquery .= "AND description LIKE '%$search_description%' ";
			}
		if( $search_minutes )
			{
			$searchquery .= "AND minutes LIKE '%$search_minutes%' ";
			}
		if( $search_conclusion )
			{
			$searchquery .= "AND conclusion LIKE '%$search_conclusion%' ";
			}
		if( $search_actionitems )
			{
			$searchquery .= "AND actionitems LIKE '%$search_actionitems%' ";
			}
		}
	if( true )
		{
		// Is there a decent condition I can check for?
		// These values are 99.44% to exist...
		$search_afterTime = convertUTimeToSQLTime( mktime( $search_afterHour, $search_afterMinute, $search_afterSecond, $search_afterMonth, $search_afterDay, $search_afterYear ) );
		$search_beforeTime = convertUTimeToSQLTime( mktime( $search_beforeHour, $search_beforeMinute, $search_beforeSecond, $search_beforeMonth, $search_beforeDay, $search_beforeYear ) );
		$searchquery .= "AND ( ( itemstart > '" . $search_afterTime . "' AND itemstart < '" . $search_beforeTime . "' ) OR ( itemstart < '" . $search_afterTime . "' AND itemstop > '" . $search_beforeTime . "' ) OR ( itemstop > '" . $search_afterTime . "' AND itemstop < '" . $search_beforeTime . "' ) )";
		}
	if( isset( $search_groups ) )
		{
		$searchquery .= "AND (" . TWIGGroupsCreateSQLGroupQuery( $login["username"], array( $search_groups ) ) . ") ";
		}
	if( $searchquery )
		{
		// If there is no $searchquery (ie we failed all the above) then why bother searching?
        	
		// Strip the first four characters because we know they are 'AND '
		$searchquery = substr( $searchquery, 4 );
		$query = "SELECT * FROM " . $dbconfig["meetings_table"] . " WHERE (" . $searchquery . ") ORDER BY itemstart";
		$resultleft = dbQuery( $query );
		TWIGDebug( $query );

		$tableheaders = array(
			$TWIGphrase["Event Name"],
			$TWIGphrase["Description"],
			$TWIGphrase["Starts"],
			$TWIGphrase["Finishes"]
			);

		// get the number of rows of the result
		$total = dbNumRows( $resultleft );
		// set the startmsg if it has not been set
		if( !isset( $startmsg ) ) { $startmsg = 1; }
		// grab the preferred number of items per page
		$pagesize = GetPref( "pagesize", $dbconfig["meetings_prefs_table"], $config["defaults"]["meetings"]["pagesize"] );
		// figure out where in the result set we should begin grabbing items
		if( ( $pagesize == 0 ) || ( $startmsg + $pagesize > $total ) ) { $highitem = $total; } else { $highitem = $startmsg + $pagesize - 1; }
		// loop through the desired portion of the result set
		for( $i = $startmsg - 1, $j = 0; $i < $highitem; $i++, $j++ )
			{
			$data = dbResultArray( $resultleft, $i );

			if( $sql )
				{
				$rsvp = $data["rsvp"];
				}
			else
				{
				$rsvp = $dataright[$data["id"]];
				}

			$tablecontents[$j] = array(
				TWIGLink( TWIGImage( $img["project"], $TWIGphrase["Full Details"] ), "meetings", "view", "ItemID=$data[id]" ) . $data[item],
				$data["description"],
				TWIGdate( TWIGGetTimeFormat(), convertSQLTimeToUTime( $data[itemstart]) ) . " " . $TWIGphrase["on"] . "<BR>" . TWIGdate( $config[longdateformat], convertSQLTimeToUTime( $data[itemstart] ) ),
				TWIGdate( TWIGGetTimeFormat(), convertSQLTimeToUTime( $data[itemstop] ) ) . " " . $TWIGphrase["on"] . "<BR>" . TWIGdate( $config[longdateformat], convertSQLTimeToUTime( $data[itemstop] ) )
				);
			} 
//		// If there is no $searchquery (ie we failed all the above) then why bother searching?
//        	
//		// Strip the first four characters because we know they are 'AND '
//		$searchquery = substr( $searchquery, 4 );
//		$result = dbQuery( $query );
//		TWIGDebug( $query );
//
//		$sortorder = array( "item"=>"item", "group"=>"groupid" );
//		$sortordernum = array( "item"=>0, "groupid"=>1 );
//		if( !$session["nsortby"] ) { $session["nsortby"] = $sortorder[GetPref( "sortby", $dbconfig["meetings_prefs_table"], $config["defaults"]["meetings"]["sortby"] )]; }
//		if( !$session["nsortby"] ) { $session["nsortby"] = "item"; }
//		$sortway = array( "", " DESC" );
//		if( !$session["nsortbyway"] ) { $session["nsortbyway"] = $sortway[GetPref( "sortorder", $dbconfig["meetings_prefs_table"], $config["defaults"]["meetings"]["sortorder"] )]; }
//
//		$hilights = array( array( "", "" ), array( "", "" ) );
//		$hilights[$sortordernum[$session["nsortby"]]] = array( "[", "]" );
//
//		if( $session["nsortbyway"] ) { $tmpsortbyway = ""; } else { $tmpsortbyway = " DESC"; }
//
//		$soitem = array( array( "item"=>"nsortby", "value"=>"item" ), array( "item"=>"nsortbyway", "value"=>$tmpsortbyway ) );
//		$sogroup = array( array( "item"=>"nsortby", "value"=>"groupid" ), array( "item"=>"nsortbyway", "value"=>$tmpsortbyway ) );
//
//		$tableheaders = array( 	twigLink( "<font color=\"" . $config["cellheadtext"] . "\">" . $hilights[0][0] . $TWIGphrase["item"] . $hilights[0][1] . "</font>", "meetings", "", "", "", $soitem ),
//					"&nbsp;",
//					twigLink( "<font color=\"" . $config["cellheadtext"] . "\">" . $hilights[1][0] . $TWIGphrase["group"] . $hilights[1][1] . "</font>", "meetings", "", "", "", $sogroup ),
//					);
//
//		$query = "SELECT * FROM " . $dbconfig["meetings_table"] . " WHERE (" . $searchquery . ") ORDER BY " . $session["nsortby"] . $session["nsortbyway"];
//		$result = dbQuery( $query );
//		TWIGDebug( $query );
//
//		if( !$startmsg ) { $startmsg = 1; }
//		$pagesize = GetPref( "pagesize", $dbconfig["meetings_prefs_table"], $config["defaults"]["meetings"]["pagesize"] );
//
//		if( $submitbutton["selectall"] ) { $marked = " CHECKED"; } else { $marked = ""; }
//
//		$total = dbNumRows( $result );
//		if( ( $pagesize == 0 ) || ( $startmsg + $pagesize > $total ) ) { $highitem = $total; } else { $highitem = $startmsg + $pagesize - 1; }
//
//		for( $i = $startmsg - 1; $i < $highitem; $i++ ) 
//			{
//			$data = dbResultArray( $result, $i );
//
//
//			$tablecontents[$i] = array(	twigLink( "<img src=\"" . $img["project"] . "\" border=0 alt=\"" . $TWIGphrase["View Note"] . "\">" . $data["item"], "meetings", "view", "ItemID=" . $data["id"] ), 
//							"&nbsp;",
//							twigLink( TWIGGroupsGetName( $data["groupid"] ), "meetings", "", "session[" . $featureprefix . "Group]=" . $data["groupid"] ),
//							);
//			}
?>
<table width=100% border=0 cellspacing=0 cellpadding=0>
 <tr>
  <td valign=top bgcolor="<?php echo $config["cellheadcolor"]?>">
   <font face="<?php echo $config["cellfont"]?>" size=<?php echo $config["textfontsize"];?>><b>
    <?php echo TWIGLink( "<font color=\"" . $config["cellheadtext"] . "\">" . $TWIGphrase["Meetings"] . "</font>", "meetings" ); ?>
   </b></font>
  </td>
 </tr>
 <tr>
  <td bgcolor=<?php echo $config["cellcolor"]?>>
   &nbsp;
  </td>
 </tr>
 <tr>
  <td valign=top bgcolor=<?php echo $config["cellcolor"]?>>
   <?php
   if( $tablecontents )
	{
	echo TWIGGenerateTable( $tableheaders, $tablecontents, "", "95%", "center" );
	}
   else
	{
	echo "<font face=" . $config["cellfont"] . " size=" . $config["textfontsize"] . ">";
	echo "<b><i>" . $TWIGphrase["No matches"] . "</i></b></font>\n";
	}
   ?>
  </td>
 </tr>
 <tr>
  <td bgcolor=<?php echo $config["cellcolor"]?>>
   &nbsp;
  </td>
 </tr>
</table>
<?php
		}
	}

?>
