/*
** TleenX2 (Tlen.pl Client)
** Copyright (c) 2002-2003 Hubert Sokoowski <who_ami@tlen.pl>
**                         Pawe Biliski <rael@fr.pl>
**
** This code is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License.
**
*/


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "main.h"
#include <gdk/gdkkeysyms.h>
#include <stdlib.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "windows.h"
#include "utils.h"
#include "conffile.h"
#include "chat.h"
#include "messages.h"
#include "archive.h"
#include "search.h"
#include "lista.h"
#include "menu.h"
#include "jabby.h"
#include "jabber.h"
#include "users.h"
#include "groups.h"

gboolean
on_treeview_button_release_event      (GtkWidget       *widget,
                                       GdkEventButton  *event,
                                       gpointer         user_data)
{
  GtkTreeView *treeview=(GTK_TREE_VIEW(widget));
  GtkTreeSelection *selection;
  GtkTreeModel *model;
  GtkTreeIter iter;
  guint status;
  gchar *s;
  GtkWidget *menu;
  GtkWidget *menu_items;
  struct user *user;
  gchar *jid;
  gchar *s2;

  selection=gtk_tree_view_get_selection(treeview);
  if (event->type==GDK_BUTTON_RELEASE &&
      event->button==3)
  {

    if (gtk_tree_selection_get_selected (selection, &model, &iter))
    {
      gtk_tree_model_get (model, &iter,
                          0, &status,
                          -1);
      if((status==0) || (status==1))
        return TRUE;
      gtk_tree_model_get (model, &iter,
                          2, &jid,
                          -1);
      user=get_user(jid);
      g_free(jid);
	  if( (!user) || (user->type == USER_VIRTUAL) )
        return TRUE;

	  menu = gtk_menu_new ();
	  
      menu_items = gtk_menu_item_new_with_label (user->jid);
      gtk_menu_append (GTK_MENU (menu), menu_items);
      gtk_widget_show (menu_items);
      gtk_widget_set_sensitive (menu_items, FALSE);
      s2 = user_description(user);
      if(s2)
      {
        menu_items = gtk_menu_item_new_with_label (s2);
        gtk_menu_append (GTK_MENU (menu), menu_items);
        gtk_widget_show (menu_items);
        gtk_widget_set_sensitive (menu_items, FALSE);
      }

      menu_items = gtk_menu_item_new ();
      gtk_widget_show (menu_items);
      gtk_container_add (GTK_CONTAINER (menu), menu_items);
      gtk_widget_set_sensitive (menu_items, FALSE);

      if(s2)
      {
        menu_items = gtk_menu_item_new_with_label ("Skopiuj opis do schowka");
        gtk_menu_append (GTK_MENU (menu), menu_items);
        g_signal_connect_swapped (G_OBJECT (menu_items), "activate",
                                  G_CALLBACK (on_menu_user_clipboard),
                                  (gpointer) user);
        gtk_widget_show (menu_items);
        g_free(s2);
      }
      if(user)
      if(!strcmp(user->subscription,"both") ||
         !strcmp(user->subscription,"to"))
      {
        menu_items = gtk_menu_item_new_with_label ("Rozmowa");
        gtk_menu_append (GTK_MENU (menu), menu_items);
        g_signal_connect_swapped (G_OBJECT (menu_items), "activate",
                                  G_CALLBACK (on_menu_user_chat),
                                  (gpointer) user);
        gtk_widget_show (menu_items);
      }

      s=utf("Wiadomo");
      menu_items = gtk_menu_item_new_with_label (s);
      g_free(s);
      gtk_menu_append (GTK_MENU (menu), menu_items);
      g_signal_connect_swapped (G_OBJECT (menu_items), "activate",
                                G_CALLBACK (on_menu_user_mesg),
                                (gpointer) user->jid);
      gtk_widget_show (menu_items);

      menu_items = gtk_menu_item_new_with_label ("Edycja danych osoby");
      gtk_menu_append (GTK_MENU (menu), menu_items);
      g_signal_connect_swapped (G_OBJECT (menu_items), "activate",
                                G_CALLBACK (on_menu_user_edit),
                                (gpointer) user);
      gtk_widget_show (menu_items);

      if(user->type == USER_TLEN ||
         (user->type == USER_GG && jabber_logged_to_gg()))
      {
        s=utf("Katalog publiczny");
        menu_items = gtk_menu_item_new_with_label (s);
        g_free(s);
        gtk_menu_append (GTK_MENU (menu), menu_items);
        g_signal_connect_swapped (G_OBJECT (menu_items), "activate",
                                  G_CALLBACK (on_menu_user_check),
                                  (gpointer) user);
        gtk_widget_show (menu_items);
      }

      menu_items = gtk_menu_item_new ();
      gtk_widget_show (menu_items);
      gtk_container_add (GTK_CONTAINER (menu), menu_items);
      gtk_widget_set_sensitive (menu_items, FALSE);

      s=utf("Usu");
      menu_items = gtk_menu_item_new_with_label (s);
      g_free(s);
      gtk_menu_append (GTK_MENU (menu), menu_items);
      g_signal_connect_swapped (G_OBJECT (menu_items), "activate",
                                G_CALLBACK (on_menu_user_delete),
                                (gpointer) user);
      gtk_widget_show (menu_items);

      gtk_menu_popup (GTK_MENU (menu), NULL, NULL, NULL, NULL,
                      1, event->time);
      return TRUE;
    }
  }

  return FALSE;
}

void
on_treeview_select_row(GtkTreeSelection *selection,
                        gpointer user_data)
{

}

void
on_treeview_row_activated             (GtkTreeView     *treeview,
                                        GtkTreePath     *arg1,
                                        GtkTreeViewColumn *arg2,
                                        gpointer         user_data)
{
	GtkTreeSelection *selection = NULL;
	GtkTreeModel *model = NULL;
	GtkTreeIter iter;
	gchar *jid = NULL;
	guint status;
	struct user *u = NULL;
	struct talk *talk = NULL;

	selection = gtk_tree_view_get_selection(treeview);
	if (gtk_tree_selection_get_selected(selection, &model, &iter)) {

		gtk_tree_model_get(model, &iter,
				0, &status,
				-1);

		if(status == 0)
			return;

		// if it's group expand/collapse
		if(status == 1) {
			if(gtk_tree_view_row_expanded(treeview, arg1))
				gtk_tree_view_collapse_row(treeview, arg1);
			else
				gtk_tree_view_expand_row(treeview, arg1, FALSE);	
			return;	
		}

		gtk_tree_model_get(model, &iter,
				2, &jid,
				-1);

		u = get_user(jid);
		if( (strcmp(u->subscription,"both") && strcmp(u->subscription,"to")) ||
				u->type == USER_VIRTUAL)
			return;

		// if chat window is already created - show it
		talk = get_talk(jid);
		if(talk) {
			gtk_window_present(GTK_WINDOW(talk->window));
			return;
		}

		// create new chat window
		my_create_window_chat(jid);
		talk = get_talk(jid);
    	chat_set_title(talk, 0);
	}
}


void on_treeview_row_expanded(GtkTreeView *treeview,
                              GtkTreeIter *arg1,
                              GtkTreePath *arg2,
                              gpointer user_data)
{
	guint status;
	struct group *g = NULL;
	
	gtk_tree_model_get(gtk_tree_view_get_model(GTK_TREE_VIEW(treeview)), arg1,
				0, &status,	
				-1);
	
	if( (status != 1) )
		return;
	
	if( (g = get_group_by_path(arg2)) ) 
		list_expanded_group_set(g->name);
}


void on_treeview_row_collapsed(GtkTreeView *treeview,
                               GtkTreeIter *arg1,
                               GtkTreePath *arg2,
                               gpointer user_data)
{
	guint status;
	struct group *g = NULL;
	
	gtk_tree_model_get(gtk_tree_view_get_model(GTK_TREE_VIEW(treeview)), arg1,
				0, &status,	
				-1);
	
	if( (status != 1) )
		return;

	if( (g = get_group_by_path(arg2)) ) 
		list_expanded_group_unset(g->name);
}


gboolean
on_window1_delete_event                (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
#ifndef DISABLE_DOCKLET
  if(status_docklet) {
    gtk_window_get_position(GTK_WINDOW(window1), &posx, &posy);
    gtk_widget_hide(window1);
  }
  else {
    wyjscie();
  }
#else
  wyjscie();
#endif

  return TRUE;
}


void
on_button_tlenpl_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_button_status_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_button_add_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
    contact_add(NULL, USER_TLEN);
}


void
on_button_search_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
  if(!window_search)
    my_create_window_search();

}


void
on_button_prefs_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
  if(!window_prefs)
    my_create_window_prefs();

}


void
on_button_arch_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
  if(!window_archive)
    my_create_window_archive();

}


void
on_togglebutton_hide_toggled           (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  if(gtk_toggle_button_get_active(togglebutton))
    preferences |= PREF_HIDE_OFFLINE;
  else
    preferences &= ~PREF_HIDE_OFFLINE;
  list_reload_all();
}


void
on_button_profiles_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy(window_login);
  my_create_window_profiles();
  gtk_widget_show(window_profiles);

}


void
on_button_open_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *entry;
  const gchar *name;

  entry = lookup_widget(window_login,"combo_entry");
  name = gtk_entry_get_text(GTK_ENTRY(entry));
  if(!strlen(name))
  {
    info("Kliknij przycisk Profile aby doda jaki profil.");
    return;
  }
  pname = fromutf(name);
  gtk_widget_destroy(window_login);
  window1_open();
}


gboolean
on_window_profiles_delete_event        (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  gtk_widget_destroy(window_profiles);
  create_file();
  my_create_window_login();

  return FALSE;
}


void
on_button_profiles_new_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{

  gtk_widget_destroy(window_profiles);
  my_create_window_profile(NULL);
  gtk_widget_show(window_profile);
}


void
on_button_profiles_delete_clicked      (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *treeview;
  GtkTreeSelection *selection;
  GtkTreeModel *model;
  GtkTreeIter iter;
  gchar *pname, *s;

  treeview = lookup_widget(window_profiles,"treeview");
  selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(treeview));
  if (gtk_tree_selection_get_selected (selection, &model, &iter))
  {
    gtk_tree_model_get (model, &iter,
                        0, &pname,
                        -1);
    s = fromutf(pname);
    del_profile(s);
    g_free(s);
    model = window_profiles_create_model();
    gtk_tree_view_set_model(GTK_TREE_VIEW(treeview), model);
    g_object_unref (G_OBJECT (model));
  }
}


void
on_button_profiles_edit_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *treeview;
  GtkTreeSelection *selection;
  GtkTreeModel *model;
  GtkTreeIter iter;
  gchar *pname, *s;

  treeview = lookup_widget(window_profiles,"treeview");
  selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(treeview));
  if (gtk_tree_selection_get_selected (selection, &model, &iter))
  {
    gtk_tree_model_get (model, &iter,
                        0, &pname,
                        -1);
    s = fromutf(pname);
    my_create_window_profile(s);
    g_free(s);
    gtk_widget_destroy(window_profiles);
    gtk_widget_show(window_profile);
  }

}


void
on_button_profiles_close_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy(window_profiles);
  create_file();
  my_create_window_login();

}


gboolean
on_window_profile_delete_event         (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  gtk_widget_destroy(window_profile);
  my_create_window_profiles();
  gtk_widget_show(window_profiles);

  return TRUE;
}


void
on_button_profile_ok_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *entry;
  const gchar *pname, *login, *password;
  gchar *s;
  const gchar *jserver, *jlogin, *jpassword, *jresource;
//  struct profile *p;

  entry = lookup_widget(window_profile,"entry_name");
  pname = gtk_entry_get_text(GTK_ENTRY(entry));
  if(!strlen(pname))
  {
    info("Musisz poda nazw profilu");
    return;
  }
  entry = lookup_widget(window_profile,"entry_tlen_login");
  login = gtk_entry_get_text(GTK_ENTRY(entry));
  if(!strlen(login))
  {
    info("Musisz poda login Tlenu");
    return;
  }
  entry = lookup_widget(window_profile,"entry_tlen_password");
  password = gtk_entry_get_text(GTK_ENTRY(entry));
  if(!strlen(password))
  {
    info("Musisz poda haso Tlenu");
    return;
  }
  s = fromutf(pname);
  if(!s)
  {
    info("Wprowadzie niepoprawne znaki w polu nazwy");
    return;
  }
  add_profile(s, login, password);
  entry = lookup_widget(window_profile,"entry_jabber_server");
  jserver = gtk_entry_get_text(GTK_ENTRY(entry));
  if(strlen(jserver))
  {
    entry = lookup_widget(window_profile,"entry_jabber_jid");
    jlogin = gtk_entry_get_text(GTK_ENTRY(entry));
    if(strlen(jlogin))
    {
      entry = lookup_widget(window_profile,"entry_jabber_password");
      jpassword = gtk_entry_get_text(GTK_ENTRY(entry));
      if(strlen(jpassword))
      {
        entry = lookup_widget(window_profile,"entry_jabber_resource");
        jresource = gtk_entry_get_text(GTK_ENTRY(entry));
        profile_jabber(s, jserver, jlogin, jpassword, jresource);
      }
    }
  }
  entry = lookup_widget(window_profile,"entry_gg_number");
  login = gtk_entry_get_text(GTK_ENTRY(entry));
  entry = lookup_widget(window_profile,"entry_gg_password");
  password = gtk_entry_get_text(GTK_ENTRY(entry));
  if(strlen(login) && strlen(password))
    profile_gg(s, login, password);
  entry = lookup_widget(window_profile,"entry_sms_id");
  login = gtk_entry_get_text(GTK_ENTRY(entry));
  entry = lookup_widget(window_profile,"entry_sms_password");
  password = gtk_entry_get_text(GTK_ENTRY(entry));
  if(strlen(login) && strlen(password))
    profile_sms(s, login, password);
  g_free(s);
  gtk_widget_destroy(window_profile);
  my_create_window_profiles();
  gtk_widget_show(window_profiles);

}


void
on_combo_entry_type_changed            (GtkEditable     *editable,
                                        gpointer         user_data)
{
  window_contact_add_type_changed(GTK_WIDGET(editable));

}


void
on_button_contact_add_ok_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *entry, *window;
  gchar *name, *id, *group, *type;
  struct user *u;
  gint gtype=-1, status=-1;

  window = GTK_WIDGET(button);
  entry = lookup_widget (window, "entry_id");
  id = (gchar*) gtk_entry_get_text(GTK_ENTRY(entry));
  if(strlen(id) == 0)
  {
    info("Musisz poda identyfikator");
    return;
  }
  entry = lookup_widget (window, "entry_name");
  name = (gchar *) gtk_entry_get_text(GTK_ENTRY(entry));
  entry = lookup_widget (window, "addcontact_entry_group");
  group = (gchar *) gtk_entry_get_text(GTK_ENTRY(entry));

  entry = lookup_widget (window, "combo_entry_type");
  type = (gchar*) gtk_entry_get_text(GTK_ENTRY(entry));
  if(!strcmp(type, "Jabber"))
  {
    if(!jabber_logged())
    {
      info("Brak poczenia z serwerem jabbera.");
      return;
    }
    gtype = USER_JABBER;
    status = JABBY_PRESENCE_UNAVAILABLE+2;
    if(!strchr(id,'@'))
    {
      info("Musisz poda nazw serwera w identyfikatorze.");
      return;
    }
    id = g_strdup(id);
    jabber_contact_add(name, id, group);
  }
  if(!strcmp(type, "GG"))
  {
    if(!jabber_logged())
    {
      info("Brak poczenia z serwerem jabbera.");
      return;
    }
    if(!jabber_registered_to_gg())
    {
      info("Nie masz zarejestrowanego numeru GG.");
      return;
    }
    gtype = USER_GG;
    status = JABBY_PRESENCE_UNAVAILABLE+2;
    if(!atoi(id) || strchr(id, '@'))
    {
      info("Niepoprawny numer.");
      return;
    }
    id = g_strdup_printf("%s@%s", id, profile->ggserver);
    jabber_contact_add(name, id, group);
  }
  if(!strcmp(type, "WPKontakt"))
  {
    if(!jabber_logged())
    {
      info("Brak poczenia z serwerem jabbera.");
      return;
    }
    gtype = USER_WP;
    status = JABBY_PRESENCE_UNAVAILABLE+2;
    if(!strchr(id,'@'))
      id = g_strdup_printf("%s@jabber.wp.pl", id);
    else
      id = g_strdup(id);
    jabber_contact_add(name, id, group);
  }
  name = fromutf(name);
  group = fromutf(group);
  if(!strcmp(type, "Tlen"))
  {
    gtype = USER_TLEN;
    status = TLEN_STATUS_UNAVAILABLE;
    if(strchr(id, '@'))
      id = g_strdup(id);
    else
      id = g_strdup_printf("%s@tlen.pl", id);
    tlen_addcontact(session, name, id, group);
  }
  if((u = get_user(id)))
  {
    add_user(name, id, group, NULL, NULL, NULL,-1, -1);
    if(strcmp(u->subscription,"both") && strcmp(u->subscription,"to")
       && strcmp(u->ask,"subscribe"))
    {
      if(!strcmp(type, "Tlen"))
        tlen_request_subscribe(session, id);
    if(!strcmp(type, "Jabber") || !strcmp(type, "WPKontakt")
       || !strcmp(type, "GG"))
        jabber_subscribe_ask(id);
    }
  }
  else
  {
    add_user(name, id, group, "none", "niedostpny", "subscribe",
             status, gtype);
    if(!strcmp(type, "Tlen"))
      tlen_request_subscribe(session, id);
    if(!strcmp(type, "Jabber") || !strcmp(type, "WPKontakt")
       || !strcmp(type, "GG"))
      jabber_subscribe_ask(id);
  }
  gtk_widget_destroy(window);
  g_free(name);
  g_free(group);
  g_free(id);
  list_reload_all();
}


gboolean
on_window_message_delete_event         (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  if(messages_unread())
    info("Nieprzeczytane wiadomoci s dostpne w archiwum.");
  messages_list_clear();
  gtk_widget_destroy(window_message);
  window_message = NULL;
  return TRUE;
}


void
on_button_message_reply_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
  gchar *id, *message;
  GtkWidget *widget;

  widget = lookup_widget(window_message, "label_id");
  id = (gchar *) gtk_label_get_text(GTK_LABEL(widget));
  widget = lookup_widget(window_message, "textview");
  message = fromutf(textview_get_text(widget));
  message_send(id, message);
  g_free(message);

}


void
on_button_message_prev_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *label;
  gchar *s;
  gint num;

  label = lookup_widget(window_message, "label_counter");
  s = (gchar *) gtk_label_get_text(GTK_LABEL(label));
  num = atoi(s);
  window_message_update(num-1);
}


void
on_button_message_next_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *label;
  gchar *s;
  gint num;

  label = lookup_widget(window_message, "label_counter");
  s = (gchar *) gtk_label_get_text(GTK_LABEL(label));
  num = atoi(s);
  window_message_update(num+1);
}


gboolean
on_window_search_delete_event          (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{

  window_search_close();
  return TRUE;
}


void
on_button_search_search_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *widget;
  gchar *s;

  widget = lookup_widget(window_search, "radiobutton_search_tlen_pl");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)))
    {
      struct tlen_pubdir *pubdir;

      pubdir = tlen_new_pubdir();

      widget = lookup_widget(window_search,"entry_name");
      s = fromutf(gtk_entry_get_text(GTK_ENTRY(widget)));
      if(strlen(s)>0)
      pubdir->firstname = s;

      widget = lookup_widget(window_search,"entry_surname");
      s = fromutf(gtk_entry_get_text(GTK_ENTRY(widget)));
      if(strlen(s)>0)
      pubdir->lastname = s;

      widget = lookup_widget(window_search,"entry_nick");
      s = fromutf(gtk_entry_get_text(GTK_ENTRY(widget)));
      if(strlen(s)>0)
      pubdir->nick = s;

      widget = lookup_widget(window_search,"entry_gender");
      s = fromutf(gtk_entry_get_text(GTK_ENTRY(widget)));
      if(!strcmp(s,"kobieta"))
      pubdir->gender = TLEN_PUBDIR_GENDER_FEMALE;
      else if(!strcmp(s,"mczyzna"))
      pubdir->gender = TLEN_PUBDIR_GENDER_MALE;
      else
      pubdir->gender=TLEN_PUBDIR_GENDER_NONE;
      g_free(s);

      widget = lookup_widget(window_search,"entry_city");
      s = fromutf(gtk_entry_get_text(GTK_ENTRY(widget)));
      if(strlen(s)>0)
      pubdir->city = s;

      widget = lookup_widget(window_search,"entry_email");
      s = fromutf(gtk_entry_get_text(GTK_ENTRY(widget)));
      if(strlen(s)>0)
      pubdir->email = s;

      widget = lookup_widget(window_search,"spinbutton_agefrom");
      pubdir->age_min = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(widget));
      widget = lookup_widget(window_search,"spinbutton_ageto");
      pubdir->age_max = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(widget));
      widget = lookup_widget(window_search,"entry_status");
      s = fromutf(gtk_entry_get_text(GTK_ENTRY(widget)));
      if(!strcmp(s,"dostpny"))
      pubdir->status = TLEN_PUBDIR_STATUS_AVAILABLE;
      else if(!strcmp(s,"porozmawiajmy"))
      pubdir->status = TLEN_PUBDIR_STATUS_CHATTY;
      g_free(s);

      widget = lookup_widget(window_search,"entry_look");
      s = fromutf(gtk_entry_get_text(GTK_ENTRY(widget)));
      if(!strcmp(s,""))
      pubdir->look_for = TLEN_PUBDIR_LOOK_NONE;
      else if(!strcmp(s,"rozmowa"))
      pubdir->look_for = TLEN_PUBDIR_LOOK_TALK;
      else if(!strcmp(s,"przyja"))
      pubdir->look_for = TLEN_PUBDIR_LOOK_FRIEND;
      else if(!strcmp(s,"romans"))
      pubdir->look_for = TLEN_PUBDIR_LOOK_FLIRT;
      else if(!strcmp(s,"mio"))
      pubdir->look_for = TLEN_PUBDIR_LOOK_LOVE;
      g_free(s);

      widget = lookup_widget(window_search,"entry_school");
      s = fromutf(gtk_entry_get_text(GTK_ENTRY(widget)));
      if(strlen(s)>0)
      pubdir->school = s;

      widget = lookup_widget(window_search,"entry_job");
      s = fromutf(gtk_entry_get_text(GTK_ENTRY(widget)));
      if(!strcmp(s,""))
      pubdir->job = TLEN_PUBDIR_JOB_NONE;
      else if(!strcmp(s,"ucze"))
      pubdir->job = TLEN_PUBDIR_JOB_UCZEN;
      else if(!strcmp(s,"student"))
      pubdir->job = TLEN_PUBDIR_JOB_STUDENT;
      else if(!strcmp(s,"rolnik"))
      pubdir->job = TLEN_PUBDIR_JOB_ROLNIK;
      else if(!strcmp(s,"meneder"))
      pubdir->job = TLEN_PUBDIR_JOB_MENEDZER;
      else if(!strcmp(s,"specjalista"))
      pubdir->job = TLEN_PUBDIR_JOB_SPEC_WOL;
      else if(!strcmp(s,"urzdnik"))
      pubdir->job = TLEN_PUBDIR_JOB_UUA;
      else if(!strcmp(s,"emeryt,rencista"))
      pubdir->job = TLEN_PUBDIR_JOB_EMERYT;
      else if(!strcmp(s,"gospodyni"))
      pubdir->job = TLEN_PUBDIR_JOB_GOSPODYNI;
      else if(!strcmp(s,"nauczyciel"))
      pubdir->job = TLEN_PUBDIR_JOB_NAUCZYCIEL;
      else if(!strcmp(s,"lekarz"))
      pubdir->job = TLEN_PUBDIR_JOB_LEKARZ;
      else if(!strcmp(s,"inny"))
      pubdir->job = TLEN_PUBDIR_JOB_INNY;
      else if(!strcmp(s,"bezrobotny"))
      pubdir->job = TLEN_PUBDIR_JOB_BEZROBOTNY;
      g_free(s);

      widget = lookup_widget(window_search,"entry_voice");
      s = fromutf(gtk_entry_get_text(GTK_ENTRY(widget)));
      if(!strcmp(s,"nie"))
      pubdir->voice = TLEN_PUBDIR_VOICE_DISABLED;
      else
      pubdir->voice = TLEN_PUBDIR_VOICE_ENABLED;
      g_free(s);

      widget = lookup_widget(window_search,"entry_plans");
      s = fromutf(gtk_entry_get_text(GTK_ENTRY(widget)));
      if(!strcmp(s,""))
      pubdir->plans = TLEN_PUBDIR_WANT_NONE;
      else if(!strcmp(s,"kino"))
      pubdir->plans = TLEN_PUBDIR_WANT_CINEMA;
      g_free(s);

      widget = lookup_widget(window_search,"entry_id");
      s = fromutf(gtk_entry_get_text(GTK_ENTRY(widget)));
      if(strlen(s)>0)
      pubdir->id = s;

      tlen_search(session,pubdir);
      tlen_free_pubdir(pubdir);
      widget = lookup_widget(window_search,"thobber");
      gtk_widget_show(widget);
    }
  else
    {
      jabby_search_set *search = jabby_search_set_new();

      /* no to szukamy po GG */
      tleenx_print(DEBUG, "no to szukamy po GG\n");

      widget = lookup_widget(window_search,"entry_name");
      s = g_strdup(gtk_entry_get_text(GTK_ENTRY(widget)));
      if(strlen(s) > 0)
        search->first = s;

      widget = lookup_widget(window_search,"entry_surname");
      s = g_strdup(gtk_entry_get_text(GTK_ENTRY(widget)));
      if(strlen(s) > 0)
        search->last = s;

      widget = lookup_widget(window_search,"entry_nick");
      s = g_strdup(gtk_entry_get_text(GTK_ENTRY(widget)));
      if(strlen(s) > 0)
        search->nick = s;

      widget = lookup_widget(window_search,"entry_city");
      s = g_strdup(gtk_entry_get_text(GTK_ENTRY(widget)));
      if(strlen(s) > 0)
        search->city = s;

      widget = lookup_widget(window_search,"entry_gender");
      s = fromutf(gtk_entry_get_text(GTK_ENTRY(widget)));
      if(!strcmp(s,"kobieta"))
        search->sex = 1;
      else if(!strcmp(s,"mczyzna"))
        search->sex = 2;
      else
        search->sex = 0;
      g_free(s);

      widget = lookup_widget(window_search,"spinbutton_agefrom");
      search->age_min = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(widget));

      // check is this a number
      widget = lookup_widget(window_search,"entry_id");
      s = g_strdup(gtk_entry_get_text(GTK_ENTRY(widget)));
      if(strlen(s) > 0)
        search->id = s;

      if (!(jabber_gg_search_start(search)))
        {
          jabby_search_set_free(search);
          return;
        }
      jabby_search_set_free(search);
      widget = lookup_widget(window_search,"thobber");
      gtk_widget_show(widget);
    }
}


void
on_button_search_add_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *widget;
  GtkTreeSelection *selection;
  GtkTreeView *treeview;
  GtkTreeModel *model;
  GtkTreeIter iter;
  gchar *jid;

  treeview = (GtkTreeView*)lookup_widget(window_search,"treeview");
  selection = gtk_tree_view_get_selection(treeview);
  if (! gtk_tree_selection_get_selected (selection, NULL, &iter))
    return;
  model = gtk_tree_view_get_model (treeview);
  gtk_tree_model_get (model, &iter, SEARCH_TC_ID, &jid, -1);
  widget = lookup_widget(window_search, "radiobutton_search_gg");
  if(get_user(jid))
    return;
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)))
    contact_add(jid, USER_GG);
  else
    contact_add(jid, USER_TLEN);
}


void
on_button_search_clear_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
  pubdir_list_clear();
  search_update();//FIXME OK ?

}


void
on_button_search_close_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
  window_search_close();

}


gboolean
on_window_archive_delete_event         (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  window_archive_cancel();

  return TRUE;
}


void
on_radiobutton_archive_date_toggled    (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  if(gtk_toggle_button_get_active(togglebutton))
    treeview_sent_sort_by_name();

}


void
on_radiobutton_archive_receiver_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  if(gtk_toggle_button_get_active(togglebutton))
  {
    mesgsent_sort_by_date();
    treeview_sent_sort_by_date();
  }
}


void
on_button_archive_search_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_radiobutton_archive_date2_toggled   (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  if(gtk_toggle_button_get_active(togglebutton))
    treeview_received_sort_by_name();

}


void
on_radiobutton_archive_sender_toggled  (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  if(gtk_toggle_button_get_active(togglebutton))
  {
    mesgrecv_sort_by_date();
    treeview_received_sort_by_date();
  }
}


void
on_button_archive_search2_clicked      (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_button_archive_open_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkTreeView *treeview;
  GtkTreeSelection *selection;
  GtkTreeModel *model;
  GtkTreeIter iter;
  gchar *filename;

  treeview = (GtkTreeView *) lookup_widget(window_archive, "treeview_archives");
  selection = gtk_tree_view_get_selection(treeview);
  if (gtk_tree_selection_get_selected (selection, &model, &iter))
  {
    gtk_tree_model_get (model, &iter,
                          2, &filename,
                          -1);
    archive_read_chat(filename);
    treeview_chat_refresh();
  }
}


void
on_button_archive_close_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
  window_archive_save();
  window_archive_cancel();
}


gboolean
on_window_chat_delete_event            (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
//  chat_remove(get_talk_by_window(widget));
  gtk_widget_hide(widget);
  chat_list_flush();
  return TRUE;
}


void
on_button_chat_send_clicked            (GtkWidget *window)
{
  chat_send(get_talk_by_window(window));
}


void
on_button_chat_close_clicked           (GtkWidget *window)
{
//  chat_remove(get_talk_by_window(window));
  gtk_widget_hide(window);
  chat_list_flush();
}


void
on_togglebutton_chat_toggled           (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{

}


gboolean
on_window_prefs_delete_event           (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  gtk_widget_destroy(window_prefs);
  window_prefs = NULL;
  if(fileselection)
    gtk_widget_destroy(fileselection);
  fileselection = NULL;

  return TRUE;
}


void
on_button_prefs_colornick_clicked      (GtkWidget       *entry)
{
  colorselection_getcolor(entry);

}


void
on_button_prefs_beeponm_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
  fileselection_getfile(GTK_WIDGET(button));

}


void
on_button_prefs_cancel_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy(window_prefs);
  window_prefs = NULL;
  if(fileselection)
    gtk_widget_destroy(fileselection);
  fileselection = NULL;

}


void
on_button_prefs_apply_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
  window_prefs_apply();

}


void
on_button_prefs_ok_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
  window_prefs_apply();
  gtk_widget_destroy(window_prefs);
  window_prefs = NULL;
  if(fileselection)
    gtk_widget_destroy(fileselection);
  fileselection = NULL;
}


gboolean
on_window_card_delete_event            (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  gtk_widget_destroy(window_card);
  window_card = NULL;

  return TRUE;
}


void
on_button_card_import_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
  window_card_import();

}


void
on_button_card_export_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
  window_card_export();

}


void
on_button_fileselection_ok_clicked     (GtkWidget       *widget)
{
  gchar *s;
  gsize r, w;
  GError *error;
  GtkEntry *entry = GTK_ENTRY(widget);

  s = (gchar *)
          gtk_file_selection_get_filename(GTK_FILE_SELECTION(fileselection));
  if(s[strlen(s)-1] == '/')
    return;
  s = g_filename_to_utf8(s, -1, &r, &w, &error);
  gtk_entry_set_text(GTK_ENTRY(entry), s);
  g_free(s);
  gtk_widget_hide(fileselection);
}


void
on_button_colorselection_ok_clicked    (GtkEntry       *entry)
{
  GtkColorSelection *csel;
  GdkColor gc;
  gchar *str;

  csel=(GtkColorSelection*)lookup_widget(colorselection, "color_selection1");
  gtk_color_selection_get_current_color(csel, &gc);
  str = gtk_color_selection_palette_to_string(&gc, 1);
  gtk_entry_set_text(GTK_ENTRY(entry), str);
  g_free(str);
  gtk_widget_destroy(colorselection);

}



void
on_button_authorize_cancel_clicked     (GtkWidget *window)
{
  GtkWidget *label;
  gchar *jid;

  label = lookup_widget (window,"label_jid");
  gtk_label_get(GTK_LABEL(label), &jid);
  on_window_authorize_delete_event(window,NULL, jid);


}


void
on_button_authorize_ok_clicked         (GtkWidget       *window3)
{
  GtkWidget *label;
  gchar *jid;
  struct user *u;
  gint type;

  cant_stop=FALSE;
  label = lookup_widget (window3,"label_jid");
  gtk_label_get(GTK_LABEL(label), &jid);
  u=get_user(jid);
  type = get_type(jid);
  if(strcmp(u->subscription,"none") &&
     strcmp(u->subscription,"from"))
    switch(type)
    {
      case USER_TLEN:
        tlen_accept_subscribe(session,jid);
        break;
      case USER_JABBER:
      case USER_WP:
      case USER_GG:
      case USER_AGENT:
        jabber_subscribe_accept(jid);
        break;
    }
  if (!strcmp(user_subscription(jid),"from"))
    contact_add(jid, type);
  else
    list_reload_all();
  gtk_widget_destroy(window3);

}


void
on_button_profile_cancel_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy(window_profile);
  my_create_window_profiles();
  gtk_widget_show(window_profiles);

}


gboolean
on_window_chat_enter_notify_event      (GtkWidget       *widget,
                                        GdkEventCrossing *event,
                                        gpointer         user_data)
{
  struct talk *talk = get_talk_by_window(widget);
  
  chat_set_title(talk, 0);
  notify_clear(talk->jid);

  return TRUE;
}


gboolean
on_textview_chat_bottom_key_press_event(GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
//gboolean
//on_textview_chat_bottom_key_press_event(
//                                        GdkEventKey     *event,
//                                        gpointer         user_data)
{
  GtkWidget *togglebutton;
  if(event->keyval == GDK_Return)
  {
    togglebutton=lookup_widget(GTK_WIDGET(user_data),"togglebutton_chat");

    // testowanie CTRL+ENTER oraz ENTER
    if ( (event->state & GDK_CONTROL_MASK) != GDK_CONTROL_MASK ) {
      // bez CTRL
      // ENTER wysyla, CTRL+ENTER nowa linia
      if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(togglebutton)))
      {
        chat_send(get_talk_by_window(GTK_WIDGET(widget)));
        return TRUE;
      }
      return FALSE;
    }
    else {
      // a teraz z CTRL
      // ENTER nowa linia, CTRL+ENTER wysyla
      if(!gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(togglebutton)))
      {
        chat_send(get_talk_by_window(GTK_WIDGET(widget)));
        return TRUE;
      }
      return FALSE;    
    }
  }
  return FALSE;
}


void
on_button_message_send_ok_clicked      (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *window = GTK_WIDGET(button), *entry, *textview, *combo;
  gchar *id, *message, *s;
  gint type;

  entry = lookup_widget(window, "entry_id");
  id = (gchar *)gtk_entry_get_text(GTK_ENTRY(entry));
  if(strlen(id)<=0)
  {
    info("Musisz poda identyfikator odbiorcy");
    return;
  }
  textview = lookup_widget(window, "textview");
  message = (gchar*)textview_get_text(textview);
  if(strlen(message)<=0)
  {
    info("Pusta wiadomo");
    return;
  }
  s = message;
  message = fromutf(s);
  g_free(s);
  if(!message)
  {
    info("Wprowadzie niepoprawne znaki!");
    return;
  }
  combo = lookup_widget(window, "combo_entry");
  s = (gchar *)gtk_entry_get_text(GTK_ENTRY(combo));
//  if(!online)
//  {
//    message_queue(id, message, type);
//  g_free(message);
//    gtk_widget_destroy(window);
//    return;//FIXME
//  }
  switch(get_type(id))
  {
    case USER_TLEN:
      if(!strcmp(s, "Message"))
        type = TLEN_MESSAGE;
      else
        type = TLEN_CHAT;
      tlen_sendmsg(session, id, message, type);
      break;
    case USER_JABBER:
    case USER_WP:
      if(!strcmp(s, "Message"))
        type = JABBY_MESSAGE_NORMAL;
      else
        type = JABBY_MESSAGE_CHAT;
      jabber_message(id, message, type);
      break;
    case USER_AGENT:
    case USER_GG:
      jabber_gg_message(id, message);
      break;
  }
  save_message(id, message, MESSAGE_FROM);
  g_free(message);
  gtk_widget_destroy(window);

}


gboolean
on_window_authorize_delete_event       (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  gchar *jid = (gchar*) user_data;
  cant_stop=FALSE;

  switch(get_type(jid))
  {
    case USER_TLEN:
      tlen_removecontact(session,jid);
      tlen_accept_unsubscribe(session,jid);
      break;
    case USER_JABBER:
    case USER_WP:
    case USER_AGENT:
      jabber_contact_delete(get_user(jid));
      jabber_subscribe_deny(jid);
      break;
    default:
      break;
  }
  if(get_user(jid))
  {
    del_user(jid);
    list_reload_all();
  }
  gtk_widget_destroy(widget);


  return TRUE;
}


gboolean
on_window_unauth_delete_event          (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  window_unauth_delete(widget);

  return TRUE;
}


void
on_button_unauth_ok_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
  window_unauth_delete((GtkWidget*) user_data);

}


gboolean
on_window_desc_delete_event            (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{

  gtk_widget_destroy(window_desc);
  window_desc = NULL;
  return TRUE;
}


void
on_button_desc_cancel_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy(window_desc);
  window_desc = NULL;

}


void
on_button_desc_ok_clicked              (GtkButton       *button1,
                                        gpointer         user_data)
{
  GtkWidget *entry, *button;
  gchar *s;

  entry = lookup_widget(window_desc, "entry_desc");
  button = lookup_widget(window_desc, "radiobutton_online");
  if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(button)))
    status = TLEN_STATUS_AVAILABLE;
  else
  {
    button = lookup_widget(window_desc, "radiobutton_chatty");
    if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(button)))
      status = TLEN_STATUS_CHATTY;
    else
    {
      button = lookup_widget(window_desc, "radiobutton_dnd");
      if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(button)))
        status = TLEN_STATUS_DND;
      else
      {
        button = lookup_widget(window_desc, "radiobutton_away");
        if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(button)))
          status = TLEN_STATUS_AWAY;
        else
        {
          button = lookup_widget(window_desc, "radiobutton_ext_away");
          if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(button)))
            status = TLEN_STATUS_EXT_AWAY;
          else
          {
            button = lookup_widget(window_desc, "radiobutton_invisible");
            if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(button)))
              status = TLEN_STATUS_INVISIBLE;
            else
            {
              button = lookup_widget(window_desc, "radiobutton_offline");
              if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(button)))
              {
                if(cant_stop)
                  return;
                work_offline();
                return;
              }
            }
          }
        }
      }
    }
  }
  s = fromutf(gtk_entry_get_text(GTK_ENTRY(entry)));
  if(!s)
    return;
  if(desc)
    g_free(desc);
  if(strcmp(s, ""))
  {
    desc = s;
    desc_list_add(s);
  }
  else
  {
    g_free(s);
    desc = NULL;
  }
  if(status == TLEN_STATUS_AVAILABLE)
    autoaway = TRUE;
  else
    autoaway = FALSE;
  set_status(status);
  gtk_widget_destroy(window_desc);
  window_desc = NULL;
}




void
on_button_gg_readconf_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
  window_profile_read_gg();

}


gboolean
on_window_gg_delete_event              (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  gtk_widget_destroy(window_gg);
  window_gg = NULL;

  return FALSE;
}




void
on_button_gg_unregister_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
  jabber_unregister_gg();

}


void
on_button_gg_register_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
  window_gg_register();

}


void
on_button_gg_apply_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
  window_gg_apply();

}


void
on_button_gg_talk_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
  window_gg_talk();

}


void
on_button_status_gg_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_button_status_jabber_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{

}




void
on_button_sms_register_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
  window_gg_register_sms();

}


void
on_button_sms_cancel_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy(window_sms);
  window_sms=NULL;

}


void
on_button_sms_ok_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
  window_sms_send();

}


gboolean
on_window_sms_delete_event             (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  gtk_widget_destroy(window_sms);
  window_sms=NULL;

  return FALSE;
}


gboolean
on_window1_destroy_event               (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  wyjscie();

  return TRUE;
}


void
on_button_chat_pic_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
  default_chat_window = GTK_WIDGET(user_data);

  if(!window_pic)
  {
    window_pic = create_window_pic(GTK_WIDGET(user_data));
    gtk_widget_show(window_pic);
  }
  else
    gtk_widget_show(window_pic);

}


void
on_button_archive_delete_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
  return;//FIXME
  window_archive_delete();

}


void
on_button_archive_cancel_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
  window_archive_cancel();

}


void
on_button_chat_clear_clicked           (GtkButton       *button,
                                        gpointer         window)
{
  GtkWidget *textview;

  textview = lookup_widget(GTK_WIDGET(window), "textview_top");
  textview_clear(textview);

}


void
on_emots_button1_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *textview;

  textview = lookup_widget(default_chat_window, "textview_bottom");
  textview_append(textview, (gchar*) user_data, 0, NULL, NULL);
  gtk_widget_hide(window_pic);
}

gboolean
on_window_pic_delete_event                (GtkWidget       *widget,
                                           GdkEvent        *event,
                                           gpointer         user_data)
{
  gtk_widget_hide(window_pic);
  return TRUE;
}


void
on_radiobutton_search_tlen_pl_toggled  (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  if (gtk_toggle_button_get_active(togglebutton))
    {
      GtkWidget *widget;

      tleenx_print(DEBUG, "on_radiobutton_search_gg_toggled\n");
      widget = lookup_widget(window_search, "hbox48");
      gtk_widget_set_sensitive(widget, TRUE);
      widget = lookup_widget(window_search, "hbox49");
      gtk_widget_set_sensitive(widget, TRUE);
      widget = lookup_widget(window_search, "label_ageto");
      gtk_widget_set_sensitive(widget, TRUE);
      widget = lookup_widget(window_search, "label_email");
      gtk_widget_set_sensitive(widget, TRUE);
      widget = lookup_widget(window_search, "entry_email");
      gtk_widget_set_sensitive(widget, TRUE);
      widget = lookup_widget(window_search, "spinbutton_ageto");
      gtk_widget_set_sensitive(widget, TRUE);
      widget = lookup_widget(window_search, "label_agefrom");
      gtk_label_set_text(GTK_LABEL(widget), "Wiek od");
      widget = lookup_widget(window_search, "label_id");
      gtk_label_set_text(GTK_LABEL(widget), "ID tlenu");
    }
}


void
on_radiobutton_search_gg_toggled       (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  if (gtk_toggle_button_get_active(togglebutton))
    {
      GtkWidget *widget;

      tleenx_print(DEBUG, "on_radiobutton_search_tlen_pl_toggled\n");
      widget = lookup_widget(window_search, "hbox48");
      gtk_widget_set_sensitive(widget, FALSE);
      widget = lookup_widget(window_search, "hbox49");
      gtk_widget_set_sensitive(widget, FALSE);
      widget = lookup_widget(window_search, "label_ageto");
      gtk_widget_set_sensitive(widget, FALSE);
      widget = lookup_widget(window_search, "label_email");
      gtk_widget_set_sensitive(widget, FALSE);
      widget = lookup_widget(window_search, "entry_email");
      gtk_widget_set_sensitive(widget, FALSE);
      widget = lookup_widget(window_search, "spinbutton_ageto");
      gtk_widget_set_sensitive(widget, FALSE);
      widget = lookup_widget(window_search, "label_agefrom");
      gtk_label_set_text(GTK_LABEL(widget), "Wiek");
      widget = lookup_widget(window_search, "label_id");
      gtk_label_set_text(GTK_LABEL(widget), "Numer GG");
    }
}

void
on_window_search_show_event            (GtkWidget       *widget,
                                        gpointer         user_data)
{
  if (!(jabber_logged_to_gg()))
    {
      GtkWidget *gg_toggle = lookup_widget(widget, "radiobutton_search_gg");
      gtk_widget_set_sensitive(gg_toggle, FALSE);
    }
}


gboolean
on_window_message_enter_notify_event   (GtkWidget       *widget,
                                        GdkEventCrossing *event,
                                        gpointer         user_data)
{
	gchar *jid = NULL;
	GtkWidget *label = NULL;

	label = lookup_widget(window_message, "label_id");
	jid = (gchar *)gtk_label_get_text(GTK_LABEL(label));
	notify_clear(jid);
	
	return FALSE;
}

