/***************************************************************************
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TTDIRS_H
#define TTDIRS_H

#include <wx/filename.h>
#include <wx/url.h>

class UrlFile {
public:
  UrlFile () {};
  UrlFile (wxURL& url);
  UrlFile (const wxString& url);

  void operator= (const UrlFile& input);

  wxURL* getURL () const;
  wxString getURLstr () const;

  void setFullFileName (const wxString& name) { this->path.SetFullName(name); };
  wxString getFullFileName () const { return this->path.GetFullName(); }
  void setFileName (const wxString& name) { this->path.SetName(name); };
  wxString getFileName () const { return this->path.GetName(); };
  void setFileExt (const wxString& ext) { this->path.SetExt(ext); };
  wxString getFileExt () const { return this->path.GetExt(); };

  wxString getFullPath (bool urltype = false) const;
  void setFullPath (const wxString& path, bool urltype = false);
  void appendDir (const wxString& dir) { this->path.AppendDir(dir); };

  static wxString toUrlType (const wxString& fullpath);
  static wxString fromUrlType (const wxString& fullpath);

  /* working replacements for the same methods in wxFileSystem class
   */
  static wxString FileNameToUrl (const wxFileName& filename);
  static wxFileName UrlToFileName (const wxString& url);

  /* the following function only matter for text files
   * the values is storage-only, it is not used by this class itself
   */
  void setCharset (const wxString& charset) { this->charset=charset; };
  wxString getCharset () const;

  wxString protocol;
  wxString server;

protected:
  wxFileName path;
  wxString charset;

private:
  void Init (wxURL& url);
};

class LessonPath : public UrlFile {
public:
  LessonPath ();
};

class LangDir : public wxFileName {
public:
  LangDir();
};

#endif
