/***************************************************************************
 *   copyright            : (C) 1999 by Daniel Reith                       *
 *   email                : DanR@gmx.de                                    *
 *                                                                         *
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SINGLELESSON_H
#define SINGLELESSON_H

#include "LEntry.H"
#include "LessonController.H"
#include <wx/wx.h>
#include <wx/config.h>

class SingleLesson : public LessonController {
public:
  SingleLesson(wxWindow* parent);
  SingleLesson(wxWindow* parent, unsigned int lesson);
  ~SingleLesson();

private:
  wxWindow* parent;
  unsigned int m_lektion;

  void Init();
  void LektionLaden();
  void LektionLaden(unsigned int index);

  // Speichern des Ergebnisses
  void ErgebnisSpeichern();
  // Lektionsanweisung anzeigen
  bool Lektionsanweisung(int l);

  void onLessonStart(wxCommandEvent& WXUNUSED(e));
  void onLessonAbort(wxCommandEvent& WXUNUSED(e));
  void onLessonFinish(wxCommandEvent& WXUNUSED(e));

  DECLARE_EVENT_TABLE()
};

#endif
