;*
;* PedroM - Operating System for Ti-89/Ti-92+/V200.
;* Copyright (C) 2003 PpHd
;*
;* This program is free software ; you can redistribute it and/or modify it under the
;* terms of the GNU General Public License as published by the Free Software Foundation;
;* either version 2 of the License, or (at your option) any later version. 
;* 
;* This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
;* without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
;* See the GNU General Public License for more details. 
;* 
;* You should have received a copy of the GNU General Public License along with this program;
;* if not, write to the 
;* Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 

;******************************************************************
;***                                                            ***
;***            	Misc Functions (2)			***
;***                                                            ***
;******************************************************************

TabSize		dc.w	TAB_SIZE

;short OSSetSR(short mask);
OSSetSR:
	move.w	4(a7),d0
	trap	#1
	rts

;void OSReset(void);
OSReset:
	trap	#2

; void NeedStack(unsigned short size)	
NeedStack:
	move.w	4(a7),d1
	ext.l	d1
	lea	-$400(a7),a0
	cmp.l	d1,a0
	bge.s	\ok
		dc.w	$A29E
\ok	rts

;short setjmp (void *j_buf); 
setjmp:
	movea.l	4(a7),a0
	movem.l	d2-d7/a2-a7,(a0)
	move.l	(a7),$30(a0)	; Useless
	moveq	#0,d0
	rts
	
;void longjmp (void *j_buf, short ret_val);
longjmp:
	move.l	4(a7),a0
	move.w	8(a7),d0
	bne.s	\not
		moveq	#1,d0
\not:	movem.l	(a0)+,d2-d7/a2-a7
	move.l	(a0),(a7)
	rts
	
;void EX_patch (void *base_addr, void *tag_ptr);
EX_patch:
	move.l	4(a7),a0		; Base Ptr
	move.l	8(a7),a1		; End Ptr
	pea	(a2)
	; Due to some nasty reason, it may be unaligned... Suck
\loop:		moveq	#0,d1
		move.b	-(a1),d1
		moveq	#0,d0
		move.b	-(a1),d0
		lsl.w	#8,d0
		or.w	d0,d1		; Patch addr
		beq.s	\EndOfReloc
		moveq	#0,d2
		move.b	-(a1),d2
		moveq	#0,d0
		move.b	-(a1),d0
		lsl.w	#8,d0
		or.w	d0,d2		; What to write
		move.l	a0,d0
		add.l	d2,d0		; Reloc it
		lea	4(a0,d1.l),a2
		move.b	d0,-(a2)
		lsr.l	#8,d0
		move.b	d0,-(a2)
		lsr.l	#8,d0
		move.b	d0,-(a2)
		lsr.l	#8,d0
		move.b	d0,-(a2)
		bra.s	\loop
\EndOfReloc:
	move.l	(a7)+,a2
	rts

;short CU_stop (void);
; Destroy only d0
CU_stop:
	clr.w	d0
	move.b	CURSOR_STATE,d0			; Read current state of cursor (active/inactive)
	clr.b	CURSOR_STATE			; Stop Cursor : stop auto-int
	tst.b	CURSOR_PHASE			; Check if cursor is currently displayed
	beq.s	\Ok
		bsr.s	CU_BlinkCursor		; Yes, so erase it
\Ok	rts

;short CU_start (void);
; Destroy only d0
CU_start:
	bsr.s	CU_stop
	st.b	CURSOR_STATE
	rts

;void CU_restore (short State);
; Destroy only d0
CU_restore:
	bsr.s	CU_stop
	move.w	4(a7),d0
	move.b	d0,CURSOR_STATE
	rts

; void CU_BlinkCursor(void)
CU_BlinkCursor:
	movem.l	d0-d2/a0,-(a7)
	not.b	CURSOR_PHASE		; change the phase 00->ff or ff->00
	move.w	CURRENT_POINT_X,d0
	move.w	CURRENT_POINT_Y,d1
	cmpi.w	#SCR_WIDTH-8,d0		; Check overflow
	bhi.s	\End
	cmpi.w	#SCR_HEIGHT-8,d1
	bhi.s	\End
	movea.l	CURRENT_SCREEN,a0	; a0 = *VideoRAM
	; calculate the offset and Mask of the cursor
	addq.w	#USED_FONT*2+5,d1	; d1 = Y-coord of bottom of cursor
	mulu	#30,d1			; d1 = line-offset of -"-
	move.w	d0,d2			; d2 = number of byte within line
	lsr.w	#3,d2			
	add.w	d2,d1			; d1 = byte offset within screen
	adda.w	d1,a0			; a0 = absolute byte offset of cursor
	andi.w	#$0007,d0		; d0 = pixel number within byte
	move.w	#%1111110000000000,d1	; d1 = cursor-mask
	lsr.w	d0,d1			; d1.b = cursor mask 2
	move.w	d1,d0			; d0.b = cursor mask 1
	lsr.w	#8,d0
	; invert the cursor
	moveq	#CURSOR_SIZE-1,d2
\Loop:		eor.b	d0,(a0)+
		eor.b	d1,(a0)+
		lea	-32(a0),a0
		dbra	d2,\Loop
\End	movem.l	(a7)+,d0-d2/a0
	rts

CU_Interrupt:
	tst.b	CURSOR_STATE		; Check if the cursor is displayed
	beq.s	\End			; No, end 
		bra.s	CU_BlinkCursor	; Yes, display it.
\End:	rts	

; void cmd_disphome (void); 
cmd_disphome:
	bra	clrscr

;void MD5Done (BN *digest, MD5_CTX *context);
MD5Done:
	move.l	4(a7),a0
	move.l	8(a7),-(a7)
	pea	1(a0)
	bsr	MD5Final
	addq.l	#8,a7
	move.l	4(a7),a0
	moveq	#16,d0
\loop		tst.b	0(a0,d0.w)
		bne.s	\done
		subq.w	#1,d0
		bgt.s	\loop
\done	move.b	d0,(a0)
	rts
	

;unsigned short OSqhead (unsigned short *dummy, void *Queue); 
OSqhead:
	move.l	8(a7),a0
	tst.w	QUEUE.used(a0)
	beq.s	\Nothing
		move.w	QUEUE.head(a0),d1
		subq.w	#2,d1
		move.w	QUEUE.data(a0,d1.w),d0
\Nothing:
	rts

;short OSqinquire (unsigned short *dest, void *Queue);
OSqinquire:
	move.l	8(a7),a0
	move.l	4(a7),a1
	moveq	#0,d0
	tst.w	QUEUE.used(a0)
	beq.s	\done
		move.w	QUEUE.tail(a0),d1
		move.w	QUEUE.data(a0,d1.w),(a1)
		moveq	#1,d0
\done:	rts

;short OSenqueue (unsigned short data, void *Queue);
OSenqueue:
	move.l	4(a7),d2
	move.l	6(a7),a0
	clr.w	d0
	move.w	QUEUE.used(a0),d1
	cmp.w	QUEUE.size(a0),d1
	bge.s	\Cant
		addq.w	#2,QUEUE.used(a0)
		move.w	QUEUE.head(a0),d1
		move.w	d2,QUEUE.data(a0,d1.w)
		addq.w	#2,d1
		cmp.w	QUEUE.size(a0),d1
		blt.s	\Ok
			clr.w	d1
\Ok		move.w	d1,QUEUE.head(a0)
		moveq	#1,d0
\Cant	rts

;short OSdequeue (unsigned short *dest, void *Queue); 
OSdequeue:
	move.l	4(a7),a1
	move.l	8(a7),a0
	moveq	#1,d0			; Return TRUE if Queue is empty
	tst.w	QUEUE.used(a0)
	beq.s	\Cant
		move.w	QUEUE.tail(a0),d1
		move.w	QUEUE.data(a0,d1.w),(a1)
		subq.w	#2,QUEUE.used(a0)
		addq.w	#2,d1
		cmp.w	QUEUE.size(a0),d1
		blt.s	\Ok
			clr.w	d1
\Ok		move.w	d1,QUEUE.tail(a0)
		moveq	#0,d0
\Cant	rts
	
;vsprintf:
;	link.w a6,#-4
;	move.l 8(a6),-4(a6)
;	move.l 16(a6),-(sp)
;	move.l 12(a6),-(sp)
;	pea -4(a6)
;	pea _sputc(pc)
;	bsr vcbprintf
;	lea 16(sp),sp
;	move.l -4(a6),a0
;	clr.b (a0)
;	unlk a6
;	rts

;short atoi (const char *str asm("a0")); 
; A little smaller than tigcc's one.
atoi:
	move.l	d3,-(a7)
	moveq	#0,d0
	moveq	#0,d2
	clr.w	d3			; Sign
	; Skip space.
\SkipSpace	move.b	(a0)+,d2
		cmp.b	#' ',d2
		beq.s	\SkipSpace
	; Check sign
	cmp.b	#'-',d2
	beq.s	\Negate
		cmp.b	#-83,d2
		bne.s	\Next
\Negate			moveq	#-1,d3
			bra.s	\Cont
\Next	cmp.b	#'+',d2
	bne.s	\SignDone
\Cont		move.b	(a0)+,d2		; Read next char
\SignDone
	; While...
\loop		subi.b	#'0',d2
		bcs.s	\Done
		cmpi.b	#9,d2
		bhi.s	\Done

		move.l	d0,d1
		lsl.l	#3,d1		; x8
		add.l	d0,d1		; x8 +1
		add.l	d1,d0		; x8 +1 +1
		add.l	d2,d0

		move.b	(a0)+,d2		; Next char
		bra.s	\loop
\Done:	tst.w	d3
	beq.s	\Return
		neg.l	d0
\Return	move.l	(a7)+,d3
	rts

;void *kbd_queue (void); 
kbd_queue:
	lea	KBD_QUEUE,a0
	rts
	
; Current version of tigcc (-> v0.95) uses bcopy function to copy memory.
bcopy:
	move.l	4(a7),a1	; Src
	move.l	8(a7),a0	; Dest
	move.w	12(a7),d0	; Len
	beq.s	\end
		subq.w	#1,d0
\loop		move.b	(a1)+,(a0)+
		dbf	d0,\loop
\end	rts
bzero:
	move.l	4(a7),a0	; Address to fill with '0'
	move.w	8(a7),d0	; Size (!= 0 -Gcc won't called this function with size = 0 !)
	subq.w	#1,d0
	clr.w	d1
	\loop:	move.b	d1,(a0)+
		dbf	d0,\loop
	rts

;short QModeKey (short code);
QModeKey
	bsr.s	\PushT				; Push the next address
	dc.w	$110B,$0109,$010A,$102D		; It is not the return address,
	dc.w	$1109,$1036,$1108,$2051		; but the address of a table
	dc.w	$2057,$2048,$2052,$2054
	dc.w	$2059,0
\PushT	move.w	4+4(a7),-(a7)			; Push Code
	bsr.s	WordInList			; Check for it.
	addq.l	#6,a7
	rts

;short QSysKey (short code);
QSysKey:
	bsr.s	\PushT
	dc.w	$1035,$1032,$102B,$1033,0
\PushT	move.w	4+4(a7),-(a7)
	bsr.s	WordInList
	addq.l	#6,a7
	rts

;short WordInList (unsigned short Word, unsigned short *List); 
WordInList:
	move.w	4(a7),d1		; What to search
	move.l	6(a7),a0		; In table
WordInList_reg:
	moveq	#0,d0			; Fail
\loop		move.w	(a0)+,d2	; Read next word
		beq.s	\fail		; =0, end of table => Fail
		cmp.w	d1,d2		; Cmp 2 numbers
		bne.s	\loop		; Equal, success. Different, next 
	moveq	#1,d0			; Success
\fail	rts

;ESI StrToTokN (const char *src, unsigned char *dest);
StrToTokN:
	move.l	4(a7),a0		; ANSI src
	jsr	strlen_reg		; d0.l = src len
	move.l	4(a7),a0		; ANSI src
	move.l	8(a7),a1		; Tokn Dest
	lea	$14(a1),a1		; End of Tokn Dest
	lea	1(a0,d0.l),a0		; End of ANSI str
\loop		move.b	-(a0),-(a1)
		dbf	d0,\loop
	clr.b	-(a1)
	move.l	8(a7),a0		; Tokn Dest
	lea	$14-1(a0),a0		; End of Tokn Dest
	rts

;short TokToStrN (unsigned char *dest, SYM_STR src);
TokToStrN:
	move.l	4(a7),a0		; ANSI dest
	move.l	8(a7),a1		; Tokn Src
\loop		tst.b	-(a1)		; From VAT to ANSI
		bne.s	\loop
	addq.l	#1,a1
\loop2:		move.b	(a1)+,(a0)+
		bne.s	\loop2
	moveq	#1,d0
	rts

;void HomePushEStack (void);
HomePushEStack:
;HANDLE HS_newFIFONode (void);
HS_newFIFONode:
;void HS_pushFIFONode (HANDLE Node);
HS_pushFIFONode:
	dc.w	$A010
	
;HANDLE HS_getFIFONode (unsigned short Index);
HS_getFIFONode:
;HANDLE HS_getEntry (unsigned short Index);
HS_getEntry:
;HANDLE HS_getAns (unsigned short Index);
HS_getAns:
;void HS_freeFIFONode (HANDLE Node);
HS_freeFIFONode:
;void HS_freeAll (void); 
HS_freeAll:
;HANDLE HS_deleteFIFONode (HANDLE Node);
HS_deleteFIFONode:
;void HS_chopFIFO (void);
HS_chopFIFO:
;unsigned short HS_countFIFO (void);
HS_countFIFO:
	moveq	#0,d0
	rts
	
;void HomeExecute (const char *Command, unsigned short ComLen);
HomeExecute:
	move.l	4(a7),a0
	move.w	8(a7),d0
HomeExecute_reg:
	movem.l	d3-d7/a2-a6,-(a7)
	move.w	d0,d7
	addq.w	#3,d7			; +1 For 0 +2 For alignement
	andi.w	#$FFFE,d7		; Word alignement
	suba.w	d7,a7			; Create Stack Frame
	move.l	a7,a1			; dest Ptr
	clr.b	(a1)+			; *dest++ =0
	subq.w	#1,d0			; for(i = 0 ; i < ComLen ; i++) *dest++ = *src++
	blt.s	\End
\Loop		move.b	(a0)+,(a1)+
		dbf	d0,\Loop	
	clr.b	(a1)			; Null String
	lea	1(a7),a4		; Input Buffer
	
	lea	-60(a7),a7		; Error Stack Frame
	pea	(a7)			; Push Stack Frame
	jsr	ER_catch		; Catch all errors.
	tst.w	d0
	bne.s	\Error
		bsr	ShellExecuteCommand	; Translate and execute Command
		jsr	ER_success
		bra.s	\Cont
\Error	move.w	d0,(a7)
	bsr	ERD_dialog
\Cont	lea	64(a7),a7
\End	adda.w	d7,a7			; Pop Frame
	movem.l	(a7)+,d3-d7/a2-a6
	rts

; Advance the progress flash bar when booting
; In: a2->Flash Ptr
;AdvanceFlashBar:
;	move.l	a2,d0
;	swap	d0
;	sub.w	#START_ARCHIVE/65536,d0
;	mulu.w	#SCR_WIDTH,d0
;	divu.w	#(END_ARCHIVE-START_ARCHIVE)/65536,d0
;	lsl.w	#8,d0
;	move.l	#(SCR_HEIGHT-10)*65536+(SCR_HEIGHT-18),d1
;	or.w	d0,d1
;	move.l	d1,-(a7)
;	move.w	#A_NORMAL,-(a7)
;	pea	ScrRect
;	pea	6(a7)
;	jsr	ScrRectFill 
;	lea	14(a7),a7
;	rts

rand:
	move.l	#$41C64E6D,d2
	move.l	randseed,d1
	move.l	d2,d0
	mulu	d1,d0
	swap	d2
	mulu	d1,d2
	swap	d1
	mulu	#$4E6D,d1
	add.w	d1,d2
	swap	d2
	clr.w	d2
	add.l	d2,d0
	add.l	#12345,d0
	move.l	d0,randseed
	lsr.l	#8,d0
	and.w	#32767,d0
	rts
srand:	move.l	d0,randseed
	rts
	
;void *calloc (unsigned short NoOfItems asm("d0"), unsigned short SizeOfItems asm("d1"));
calloc:
	mulu.w	d1,d0
	move.l	d0,-(a7)
	jsr	HeapAllocPtr
	move.l	(a7)+,d0
	move.l	a0,d2
	beq.s	\Error
\Loop		clr.b	(a0)+
		subq.l	#1,d0
		bne.s	\Loop
	move.l	d2,a0

	rts
\Error:
	suba.l a0,a0
	rts

;void *realloc (void *Ptr asm("a0"), unsigned long NewSize asm("d1"));
realloc:
	move.l	a0,d0			; Read Ptr
	bne.s	\ReAlloc
		move.l	d1,-(a7)
		jsr	HeapAllocPtr
		addq.l	#4,a7
		rts
\ReAlloc
	addq.l	#2,d1			; Size+2
	move.l	d1,-(a7)		; Push size
	move.w	-2(a0),-(a7)		; Push Handle
	jsr	HeapUnlock		; Unlock Handle
	jsr	HeapRealloc		; Realloc
	tst.w	d0
	bne.s	\Deref
		jsr	HeapFree	; Free Handle
		sub.l	a0,a0		; Return NULL
		bra.s	\Done
\Deref	jsr	HLock			; Lock and deref
	addq.l	#2,a0			; Skip Handle
\Done	addq.l	#6,a7			; Pop frame
	rts

;float atof (const char *s asm("a2"));
atof:
	link.w	a6,#-80
	movem.l	d3-d7/a2-a5,-(sp)
	move.l	top_estack,-(a7)
	pea	-80(a6)
	jsr	ER_catch 
	tst.w	d0
	beq.s	\Start
		move.l	#$7FFFAA00,d0
		moveq	#0,d1
		clr.w	d2
		bra.s	\End
\Start:
	move.l	a2,(sp)
	bsr	push_parse_text
	move.l	top_estack,a0
	move.b	(a0),d5
	cmpi.b	#$7A,d5
	bne.s	\NotNeg
		subq.l	#1,a0
\NotNeg:
	move.l	a0,(sp)
	jsr	estack_number_to_Float
	jsr	ER_success
	move.l	-10(a6),d0
	move.l 	-6(a6),d1
	move.w	-2(a6),d2
	cmpi.b	#$7A,d5
	bne.s	\End
		bset	#31,d0
\End:	move.l	(a7)+,top_estack
	movem.l -116(a6),d3-d7/a2-a5
	unlk a6
	rts

;  void perror(const char *str asm("a2"))
perror:	
	move.w	errno,-(a7)
	jsr	strerror
	pea	(a0)
	pea	(a2)
	bsr.s	\Call
	dc.b	"%s: %s",10,0
\Call:	bsr	errorPrintf
	lea	14(a7),a7
	rts

; const char *getenv(const char *name asm("a2"));
; Environement variable are stored in system folder as strings.
; So it searchs for "system\name", check it is a string file and returns it 
getenv:
	movea.w	#FOLDER_LIST_HANDLE,a0
	lea	SystemFolder_str,a1
	bsr.s	\FindSymEntry
	move.l	a0,d0
	beq.s	\Failed
	move.w	SYM_ENTRY.hVal(a0),a0
	move.l	a2,a1
	bsr.s	\FindSymEntry
	move.l	a0,d0
	beq.s	\Failed
	move.w	SYM_ENTRY.hVal(a0),a0
	trap	#3
	moveq	#0,d0
	move.w	(a0)+,d0
	cmpi.b	#$2D,-1(a0,d0.l)
	beq.s	\Success
\Failed:
	suba.l	a0,a0
	rts
\FindSymEntry
	jmp	FindSymEntry
\Success:
	addq.l	#1,a0
	rts
	
; int system(const char *command asm("a0"))
system:
	movem.l	d3-d7/a2-a6,-(a7)
	pea	(a0)
	jsr	strlen		; Destroy a0 and read the length of the command
	move.l	(a7)+,a0	; so reload a0
	bsr	HomeExecute_reg	; Execute command
	bsr	Float2Int	; Convert FReg1 to int d0
	movem.l	(a7)+,d3-d7/a2-a6
	rts

; int setvbuf(FILE *stream, char *buf, int mode , size_t size);
; mode value: _IONBF (Unbuffered), _IOLBF (Line), _IOFBF (Fully Buffered)
setvbuf:
	moveq	#1,d0		; Error: streams can't be buffered.
	rts			; At least for the moment

;short DrawStrWidth (const char *str asm("a0"), const char *end asm("a1"));
StrWidthFromTo:
	movem.l	d1-d2/a0-a2,-(a7)
	
	lea	MediumFont+$800,a2
	moveq	#6,d2		; Medium
	moveq	#0,d0

	; Select Font
	cmpi.b	#1,CURRENT_FONT
	blt.s	\final_small
	beq.s	\final_calc

	; Large / Medium
	moveq	#8,d2		; Large
	bra.s	\final_calc
\loop_calc	add.w	d2,d0
\final_calc	addq.l	#1,a0
		cmp.l	a0,a1
		bge.s	\loop_calc
\rets	movem.l	(a7)+,d1-d2/a0-a2
	rts
	; Small
\loop_small	mulu.w	#6,d2
		add.b	0(a2,d2.w),d0		; Ca peut pas depasser 240 !
\final_small	clr.w	d2
		move.b	(a0)+,d2
		cmp.l	a0,a1
		bge.s	\loop_small
	bra.s	\rets
	