; How  TiOs runs an asm program an AMS 2.05 :
; Basic / Asm 
;	Em_twinSymFromExtMem
;	DerefSym ?
;	NextexpressionIndex ?
;	all_tail ?
;	VarRecall ?
;	DerefSym ?
;	HtoESI ?
;	Test ASM signature ($F3)
; Asm	
;	Handle of program
;	If GetLock(Hd) => ER_throw($A244)
;	If Hd->Ptr-$6880 < $FFFF (AMS 2.0x spec)
;		HeapMoveHigh(Hd)
;		HtoESI(Hd)
;	ER_cath			(AMS 2.0x spec)
;		HeapLock(Hd)
;		if Size(Hd) > $6000 (AMS 2.0x spec)
;			Er_throw($A0A1)
;		EX_patch(Start, end)
;		Trap B ($5D86,d3 = F) (AMS 2.0x spec)
;		Call programs
;		Something in $6888 (About Estack)
;		HeapUnLock(Hd)
;		If DerefSym(Sym).flags.10
;			bset #0,$64F1 ???
;		ER_success
;	Else (FA)
;		HeapUnLock(Hd)
;		If DerefSym(Sym).flags.10
;			bset #0,$64F1 ???
;		ER_throwVar(d3)
;	
newER_throw:
	pea	(a0)			; Push a0
	lea	FirstRun(Pc),a0		; Test if we are under crash protection
	cmpi.b	#-1,(a0)
	beq.s	crash_handler		; Yes => Crash Handler
	
	move.l	6(sp),a0		; The crash address
	cmp.w	#$A000+161,(a0)		; Test if it is 'Too long Exec Program'
	beq.s	ERThrow_return
	ifd	BasicFunction
		cmp.w	#$A1C2,(a0)	; Test if 'Invalid in a function or current expression'
		beq.s	ERThrow_return
	endif
	cmp.w	#$A244,(a0)		; Test if 'Illegal Program Reference'
	bne.s	ERTHrow_no			
AMS207_P1	cmpi.b	#$F3,(a3)	; Check if is an ASM program 
		bne.s	ERTHrow_no	; On AMS 2.08, it isn't a3 but a2 (That's why I patched)
AMS207_P2		cmp.l	#$200000,a3	; If the variable is archived, we MUST NOT SKIP THE ERROR	
			bge.s	ERTHrow_no	; Otherwise, we crash the calc (It tries to execute archived programs !)
ERThrow_return			addq.l	#2,6(sp)	; Skip the illegal instruction
				move.l	(a7)+,a0	; Restore a0
				rte		; We return to the program, skipping the illegal
ERTHrow_no
	move.l	(a7)+,a0		; Restore a0
OldER_throw
	jmp	($0).l			; Jump to old ER_throw
	
; it is preos trap 12 which does exactly what trap #12 should do.
; it is very likely tios's trap 12.
; in fact i add this function so that i am sure that trap #12 goes to supervisor mode
; (if the function intercepts trap #12...) that's all.
newtrap12:
	move.w	(sp)+,d0
	rts

; If $FFF0, 
;	~ jsr abs.l (Return address +6 / jsr to a1 ->Crash code+2 a1+(a1)
;	Ex:	dc.w	$FFF0 dc.l JumpAdr-*
; If $FFF1, 
;	~ jmp abs.l (Return address +6 / jmp to a1 ->Crash code+2 a1+(a1)
;	Ex:	dc.w	$FFF0 dc.l JumpAdr-*
; If $FFF2,
;	ROM_CALL avec un word.
;	Example: dc.w $FFF2, HeapAlloc*4
new1111:				; We don't have to save the register since if it is else a crash, else a ROM_CALL
	move.w	(sp)+,d1		; Get Old SR
	move.l	(sp)+,a0		; Get Address of the 'crash'
	move.w	(a0)+,d0		; We get the instruction and a0 ->next instruction
	subi.w	#$F800,d0		; Is it > $F800 ? 
	bls.s	crash_handler		; No, so it is a crash (First_Window isn't a ROM_CALL)
		move.l	a0,a1		
		cmp.w	#$FFF0-$F800,d0
		bne.s	\NoRelJsr
			adda.l	(a0)+,a1	; Get the Sub Routine
			bra.s	JumpRet		; Jsr with a 32 bits offset	
\NoRelJsr	cmp.w	#$FFF1-$F800,d0
		bne.s	\NoRelJmp
			adda.l	(a0)+,a1	; Get the Sub Routine
			move.w	d1,SR		; Restore SR
			jmp	(a1)		; Jmp with a 32 bits offset
\NoRelJmp	cmp.w	#$FFF2-$F800,d0
		bne.s	\NoBigRomCall
			move.w	(a0)+,d0	; Read Offset
			lsr.w	#2,d0
\NoBigRomCall
ROMBASE4	move.l	(ROM_VECTOR+$C8).l,a1	; The address of the rom_call table in ROM
		cmp.w	-(a1),d0		; Compare rom_call and number of entries
		bcc.s	crash_handler		; Out of range ? => Crash
			lsl.w	#2,d0		; * 4
			move.l	2(a1,d0.w),a1	; + ($C8) MAX: 8000 rom_calls
JumpRet			move.w	d1,SR		; Restore SR
			pea	(a0)		; Push return address
			jmp	(a1)		; Jump to Rom_call function
\no:

crash_handler:					; Crash handlers
	move.w  #$2700,SR			; Stop interrupts (Is it necessary ? YES !)
	move.w	FirstRun(pc),d0			; Test if crash under no-kernel mode ? (=0) or under Kernel Anti-Crash ? (= $FF00)
	ble.s	nostub_error
	lea	ErrorString(pc),a1
	lea	errortext(pc),a0
	move.l	a0,(a1)				; Get Error string and save it
	addq.l	#6,sp				; Pop SR / Return addr
	movea.w	#-$10,a5			; A5 -> Current prog ptr
	bra	_quit				; -$10 so that bit 2 of $11(a5) it bit 2 of byte 1, so this to say, byte = 0, so that it will redraw the screen.
		
newint6:
	pea	(a0)
	move.l	d0,-(sp)		; Save d0
	lea	$600018,a0		; To access special IO ports
	btst.b	#1,($1A-$18)(a0)	; Test if ON key if effectively pressed
	bne.s	NoShell			; ON key is not pressed
					; Test if ESC is pressed
	move.w	(a0),-(sp)		; Push Org Mask
int6msk	move.w	#%0111111,(a0)		; Write mask (int1 & 5 can't be called ;)
	moveq	#$58,d0			; TiOs uses $58
		dbra d0,*		; 
int6key	btst	#0,($1B-$18)(a0)	; Read Key Matrix 
	beq.s	crash_handler		; Yes => Crash handler
	move.w	(sp)+,(a0)		; Restore Org Mask
	ifd	ShiftOn
Statut		btst	#2,($6760).w		; SHIFT has been pressed ?
		beq.s	NoShell
			move.l ($4C).w,d0	; Test is we are already under SHIFT+ON call
			bne.s	NoShell
				move.l	($80).w,(GHOST_SPACE+$4C); Save old Trap
Trap0Adr			move.l	#0,(GHOST_SPACE+$80)	; New Trap #0
				move.l	(sp)+,d0	; Restore d0
				move.l	(sp)+,a0	; Restore a0
				rte			; Don't call original int6
	endif
NoShell	move.l	(sp)+,d0		; Restore d0
	move.l	(sp)+,a0
oldint6	jmp	($0).l			; Call the original int.



; HOT-RESET
; Reset AMS / hardware
; How it works ? It tries to reset as many variables, handles, ports, as it can
; without crashing :)
nostub_error:
	lea	($4C00-30*3).w,sp	; Load new Supervisor Stack Ptr (-30*3 to prevent some buggy programs to write inside the supervisor stack)
	bsr	kernel_install_int	; ReInstall ints.		// CAN NOT CRASH
	clr.w	(a6)			; Reinit kernel
	lea	NostubCrashFlags(Pc),a5	; Test for recursive nostub_crash
	
;	OSqclear and cmd_disphome doesn't exist on AMS 1.00 Ti-92 :(
; 	So it crashes once, but no twice :)
	bset.b	#0,(a5)
	bne.s	\crash1
		moveq	#6,d0		; 6 = Key Queue address
		trap	#9		; System Call
		move.l	a0,(sp)
		ROM_THROW OSqclear	; reset the keyboard Queue
		ROM_THROW cmd_disphome	; Set Home Apps
\crash1

	; Free some unused handles
	bset.b	#1,(a5)
	bne.s	Dont_Free_Handles
		ROM_THROW HS_freeAll		; Free Home Screen History (I could call cmd_clrHome, but it doesn't work on AMS 1.00).
ROMBASE3	move.l	(ROM_VECTOR+$C8).l,a2
		move.l	FirstWindow*4(a2),a2
		move.l	(a2),d0
		beq.s	Dont_Free_Handles	; If FirstWindow == NULL
\wloop			move.l	d0,a2
			move.w	32(a2),(sp)
			beq.s	\no_dupscr
				ROM_THROW HeapFree ; Free duplicate screen (IO and Graph)
\no_dupscr		move.l	34(a2),d0
			bne.s	\wloop
Dont_Free_Handles:

	; Reset the link		
	ROM_THROW OSLinkReset	

	; Reset AMS
	bset.b	#2,(a5)
	bne.s	crash3
AMS_HiddenFunc:
		jsr	($0).l			; Reset PortRestore / SetCurrentClip / ScreenClear(:() / FontSetSys + Some flags
		jsr	($0).l			; Reset Window List ;$529E10 ; Rom 2.03
crash3

	; Reset Vectors
	bsr	reinstall_tios_stat	; Statut / Vectors / AutoInts / IO / Contrast	// CAN NOT CRASH

	; Test if Auto-ints ok ?
	bset.b	#3,(a5)
	beq.s	autointorg_restored
		; Restore the original auto-ints !
ROMBASE1	lea	ROM_VECTOR+$64,a0		; Original Auto-ints
		lea	GHOST_SPACE+$64,a1		; Auto-Ints
		moveq	#7-1,d0
\ailoop			move.l	(a0),($E0-$64)(a1) ; New copy
			move.l	(a0)+,(a1)+
			dbf	d0,\ailoop
		lea	newint6(pc),a0		; Rewrite autoint 6
		move.l	a0,($E0-$64-8)(a1) ; New copy
		move.l	a0,-8(a1)
autointorg_restored:
	; Save current EV_hook vector if we restore the TSR
	ifd	RestoreTSR
		bset.b	#4,(a5)			; To avoid the save of the new trap and an end-less loop
		bne.s	restoreTSR_already
			ROM_PTR	EV_hook		; Save EV_hook vector
			lea	Saved_EV_Hook(Pc),a1
			move.l	(a0),(a1)
			move.l	($80).w,(GHOST_SPACE+$4C); Save old Trap // Prevent from SHIT+ON
resetTrap0Adr		move.l	#0,(GHOST_SPACE+$80)	; New Trap #0
restoreTSR_already
	endif

	move.w	#$0000,SR		; SR = $0000
ErrorFrameAdr	clr.l	($5CF8).w	; Reset ERROR FRAME
StackPtr	lea	($4200).w,a7	; ReLoad stack ptr
	ifnd	RestoreTSR
		clr.b	(a5)		; Reset Flags is there is not Restore TSR (It is worst because we don't let many time to the system, to crash if the auto-ints are corrupted). Nevertheless, if the auto-ints are really buggy, it will crash.
	endif
	ROM_THROW EV_centralDispatcher	; Redo the main loop
	
	ifd	ShiftOn
NewTrap0				; SHIFT+ON combo. Called either 'shell' or 'main\tictex'
	move.l	($4C).w,(GHOST_SPACE+$80)	; Restore original Trap #0
	trap	#0			; Call the original trap #0
	movem.l	d0-d7/a0-a6,-(sp)	; Push all registers
	move.w	#$0000,SR		; User Mode after saving register
	move.l	($2C).w,-(a7)		; Save current Line1111 vector
	bsr	kernel_install_int	; Install Int Handler
	clr.w	-(a7)			; Get rid of SHIFT indicator Now
	ROM_THROW ST_modKey		; Auto-Int1 will do it too late.
	pea	($0F00+60).w		; Push SCREEN size + some info about supervisor stack.
	ROM_THROW HeapAllocPtr		; Allocate a block to save the screen
	move.l	a0,(a7)			; Save a0 and test if a0 == NULL
	beq	ShiftOnEnd2
		lea	(LCD_MEM-60).w,a1	; Copy the LCD_MEM and some supervisor stack into the buffer
		move.w	#($0F00+60)/4-1,d0	; Buffer size / 4 (Longword copy)
\loop			move.l	(a1)+,(a0)+
			dbf	d0,\loop
		ROM_THROW FontGetSys		; Save current Font System
		move.w	d0,-(a7)

;		ROM_THROW HS_popEstack		; Pop the current value of the EStack. // Pb it can Thwon an error if it failed !
;		move.w	d0,-(a7)		; Push the Handle
;		ROM_THROW push_END_TAG		; Push END tag so that progs which needs args won't crash
		
top_estack1	move.l	($0).w,-(a7)		; Save top_estack
		ROM_THROW push_END_TAG		; Push END tag so that progs which needs args won't crash (I hope)
						; FIXME: I am sure it isn't the best solution. I should pop the Estack to a handle, calls the program. And finally repush the EStack, no ?
		ifeq	ShiftOn-1
		lea	doors_str(Pc),a0	; 'shell'
		clr.b	d0			; Version 0
		bsr	find_lib		; Find File 'shell'
		move.l	a0,d0
		beq.s	ShiftOnEnd
			HW2TSR_PATCH a0,d0	; Patch the file
			jsr	(a0)		; Execute
		endif

		ifeq	ShiftOn-2
		clr.w	-(a7)			; Normal Search
		pea	tictex_astr(Pc)		; File 'tictex'
		ROM_THROW SymFindPtr		; Find the file. If it failed, then a0 =0 and SYM_ENTRY.hVal = 7 or 3
		move.w	SYM_ENTRY.hVal(a0),-(a7)	; Get its handle
		ROM_THROW HeapDeref		; Get its address
		addq.l	#8,a7			; Pop all args
		cmp.l	#$200000,a0		; Test if program is archived ?
		bcc.s	\notlocked
			btst.b	#7,-2(a0)	; Test if program is locked ?
			bne.s	ShiftOnEnd	; Already locked : do not run it ! If it failed, the handle 3 or 7 are locked, so we exit (Even ifthere aren't locked, it doesn't matter).
\notlocked	clr.l	-(a7)			; No SYM symbol (Even if it was in a0)
		pea	tictex_astr(Pc)		; File 'tictex'
		ROM_THROW EM_twinSymFromExtMem	; Find the file and create a copy if it is archived.
		move.l	d0,(a7)			; Push the HSym and test if == NULL
		beq.s	\notfound
			ROM_THROW DerefSym		; Get Sym Entry of the symbol
			move.w	SYM_ENTRY.hVal(a0),-(a7) ; Push handle
			ROM_THROW HLock			; Lock the handle and get its address
			HW2TSR_PATCH a0,d0		; Hw2Tsr Patch
			moveq	#0,d0	
			move.w	(a0)+,d0		; Read size of the file.
			pea	-1(a0,d0.l)		; The end of the file
			pea	(a0)			; The start of the file
			ROM_THROW EX_patch		; Does the AMS relocation
			move.l	(a7)+,a0		; Read the start of the file	
			addq.l	#4,a7			; Pop the end of the file
			jsr	(a0)			; Execute the program
			nop				; Ignore RETURN Value
			nop				; If a man call a nostub program
			nop				; with a Return Value
			ROM_THROW HeapUnlock		; UnLock the allocated handle
			addq.l	#2,a7			; Pop its arg
\notfound:	addq.l	#8,a7			; Pop EM_twin... args : AMS will del the copy itself.
		endif
		
ShiftOnEnd
top_estack2	move.l	(a7)+,($0).w		; Restore top_estack
		
;		ROM_THROW HeapDeref		; Repush the poped EStack
;		addq.l	#2,a7
;		moveq	#0,d4
;		move.w	(a0)+,d4
;		pea	-1(a0,d4.l)		; End
;		pea	-1(a0)			; Beginning
;		ROM_THROW push_between		; Warning: Break Key is checked
;		addq.l	#8,a7
		
		ROM_THROW FontSetSys		; Restore current Font System
		addq.l	#2,a7
		move.l	(a7),a0
		lea	(LCD_MEM-60).w,a1	; Restore the LCD_MEM and some supervisor stack
		move.w	#($0F00+60)/4-1,d0	; Buffer size / 4 (Longword copy)
\loop2			move.l	(a0)+,(a1)+
			dbf	d0,\loop2
		ROM_THROW HeapFreePtr
ShiftOnEnd2
	addq.l	#6,a7			; Pop Screen_size + Mod_indicator
	ROM_THROW OSClearBreak		; Clear break now.
	move.l	(a7)+,GHOST_SPACE+$2C	; Restore the current Line1111 Handler
	trap	#12			; Supervisor mode
	movem.l	(sp)+,d0-d7/a0-a6	; restore all registers
	clr.l	(GHOST_SPACE+$4C)	; Clear the flag 'Shift+On is running'
	rte
	endif
	
; It is called after the Hot-reset, to restore the EV_hook
	ifd	RestoreTSR
ResetTrap0:
	move.l	($4C).w,-(sp)
idleN	cmpi.w	#$1E4,d0		; idle ?
	bne	return
	move.l	(a7)+,(GHOST_SPACE+$80)	; Restore original Trap #0

	trap	#0			; Call the original trap #0
					; IMPORTANT: Has to be done BEFORE any test
					; which might crash, otherwise AMS will cause an
					; endless crash loop for some reason.
	movem.l	d0-d7/a0-a6,-(sp)
	lea	NostubCrashFlags(Pc),a5	; Test for recursive nostub_crash
	clr.b	(a5)+			; Nostub crash ok (Auto ints ok !)
EV_hook3
	lea	($0).l,a4		; Get address of EV_hook
	lea	Saved_EV_Hook(Pc),a3	; get the address of the event hook
					; We need to use indirect addressing
					; so we can get rid of broken or
					; incompatible event hooks.
					; And we need to use the ghost space
					; because we want to write there!

	; Event hook restoring / freeing code
	tst.b	(a5)			; TSR have crashed ? 
	beq.s	\nocrash
		; Crash flag set - uninstall the event hook in the cleanest possible way
		move.l	(a3),a0			; get the address of the event hook
		; Check whether the event hook respects the evHk convention. This is
		; done to avoid restoring a corrupt address in case some broken
		; program corrupted EV_hook.
\crash_nexthook
		move.l	a0,d0
		beq.s	\crash_nomorehooks
		btst.b	#0,d0			; check if the address is even
		bne.s	\crash_nomorehooks	; if it is odd, it is obviuosly broken
		sub.l	#$40010,a0		; if <$40000, it doesn't respect the
		bcs.s	\crash_nomorehooks	; evHk convention (HW2 compatibility)
						; remove: * $40000 for HW2 AMS 2.0x
						;           without HW2Patch
						;         * $10 to get the begin of the
						;           handle (if compatible)
		cmp.l	#'EvHk',(a0)		; Signature of Event Hook v2
		beq.s	\crash_okhook
		cmp.l	#'evHk',(a0)		; check for signature v1
		bne.s	\crash_nomorehooks
\crash_okhook		move.l	12(a0),-(a7)		; get next event hook and save it on the stack
			pea.l	(a0)
			ROM_THROW HeapPtrToHandle	; get the handle number
			move.w	d0,(a7)
			beq.s	\nofree
				ROM_THROW HeapFree	; free (unallocate) the handle
\nofree 		addq.l #4,a7
			move.l	(a7)+,a0		; next event hook
			bra.s	\crash_nexthook
\crash_nomorehooks
		clr.l	(a4)			; get rid of EV_hook
		bra.s	evHk_crash

\nocrash:
	; Crash flag not set - try to restore the event hooks
	move.l	a3,a1
	
	; Check whether the event hook respects the evHk convention. This is
	; done to avoid restoring a corrupt address in case some broken
	; program corrupted EV_hook.
\nexthook
	tst.l	(a1)
	beq.s	\nomorehooks
	btst.b	#0,3(a1)		; check if the address is even
	bne	\incompatible		; if it is odd, it is obviuosly broken
	move.l	(a1),a0
	sub.l	#$40010,a0		; if <$40000, it doesn't respect the
	bcs.s	\incompatible		; evHk convention (HW2 compatibility)
					; remove: * $40000 for HW2 AMS 2.0x
					;           without HW2Patch
					;         * $10 to get the begin of the
					;           handle (if compatible)
	cmp.l	#'EvHk',(a0)		; check for signature v2
	beq.s	\next2
	cmp.l	#'evHk',(a0)		; check for signature
	bne.s	\incompatible
\next2		lea.l	12(a0),a1	; get next event hook
		bra.s	\nexthook
\incompatible clr.l (a1)		; get rid of incompatible or broken
					; event hooks the dirty way
\nomorehooks
	st.b	(a5)			; set crash flag - in case the event hook crashes,
					; we will get back here with the crash flag set
	move.l	(a3),(a4)		; Restore EV_hook
	beq.s	\noevHk
		; Now try to send an idle event to check whether the event hooks actually work.
		; If it fails, we will get back here with the crash flag set.
		move.w	#0,SR			; switch to user mode
		; Create a fake EVENT structure on the stack:
		clr.w	-(a7)			; StartType
		clr.l	-(a7)			; extra
		pea.l	$400			; Side, StatusFlags
		pea.l	$7000000		; Type, RunningApp
		move.l	a7,a2			; the convention requires a2 to hold the address of
						; the EVENT structure - while we are not worring about
						; TeOS here, unfortunately, some versions of XtraKeys for
						; the TI-92+ (including the latest released version) rely
						; on this too (because the move.l 64(a7),a2 got forgotten
						; by mistake)
		pea.l	(a7)			; EVENT structure
		move.l	(a3),a0			; adress of the EV_hook routines 
		jsr	(a0)
		lea.l	18(a7),a7		; pop the parameter AND the EVENT structure
		trap	#12			; switch back to supervisor mode
\noevHk

; Common (whether crash flag is set or not)
evHk_crash
	clr.b	(a5)			; clear crash flag

	pea	errortext(Pc)
	ROM_THROW ST_helpMsg		; Display Crash Intercepted
	addq.l	#4,a7
	movem.l	(sp)+,d0-d7/a0-a6
	clr.l	(GHOST_SPACE+$4C)	; Clear the flag 'Shift+On is running'
	rte
Saved_EV_Hook		dc.l	0	; Save EV_hook
	endif
NostubCrashFlags	dc.b	0	; OSqclear / disphome success ?
evHk_crash_flag		dc.b	0	;event hook has crashed?
	
	ifeq	ShiftOn-1
doors_str	dc.b	"shell",0
	endif
	ifeq	ShiftOn-2
	dc.b	0,"main\tictex"
tictex_astr	dc.b	0
	endif
	EVEN

;004A to 005F	2 + 4*5
;00CC to 00FF	13 x 4  

;OldEVHook	dc.l	0
;OldAutoInt1	dc.l	0	; $E0
;OldAutoInt2	dc.l	0
;OldAutoInt3	dc.l	0
;OldAutoInt4	dc.l	0
;OldAutoInt5	dc.l	0
;OldAutoInt6	dc.l	0
;OldAutoInt7	dc.l	0
