#ifndef COMMANDLINE_PARSER_H
#define COMMANDLINE_PARSER_H

#include <string>
#include <vector>
#include <map>

class CommandlineParser
{
public:
	class option
	{
	protected:
		std::string _name;
		std::string _value;
		char _shortopt;
		std::string _longopt;
		std::string _help;
		std::string _valname;
		bool _val_optional;
		bool _defined;

	public:
		option(const std::string& name, char shortopt, const std::string& longopt, const
				std::string& help, const std::string& valname, bool val_optional)
			throw() : _name(name), _shortopt(shortopt), _longopt(longopt),
						_help(help), _valname(valname),
							_val_optional(val_optional), _defined(false) {}

		bool defined() const throw () { return _defined; }
		bool hasValue() const throw () { return _value.size() > 0; }
		std::string stringVal() const throw () { return _value; }
		int intVal() const throw ();
		

		friend class CommandlineParser;
	};

protected:
	class WordWrapper
	{
	protected:
		const std::string& s;
		unsigned int cursor;
		
	public:
		WordWrapper(const std::string& s) throw () : s(s), cursor(0) {}

		void restart() throw () { cursor = 0; }

		bool hasData() const throw () { return cursor < s.size(); }
		
		std::string get(unsigned int width) throw ();
	};

	std::vector<option> options;
	std::map<char, int> shortopts;
	std::map<std::string, int> longopts;
	std::map<std::string, int> byname;
	std::string argv0;
	std::string cmdline_summary;
	std::string description;
	
	bool parseLongOption(const std::string& name, const std::string& value = "") throw ();
	bool parseShortOption(char opt, const std::string& value = "") throw ();
	
public:
	CommandlineParser(const std::string& argv0, const std::string& cmdline_summary,
			const std::string& description) throw ()
		: argv0(argv0), cmdline_summary(cmdline_summary), description(description)
	{
		add("help", 0, "help", "print this help message");
	}

	void add(const std::string& name, char shortopt, const std::string& longopt, const
			std::string& help, const std::string& valname = "",
			bool val_optional = false) throw ();
	
	void printHelp() throw ();

	bool parse(int& argc, const char**& argv) throw ();

	const option& get(const std::string& name) const throw ();
};

// vim:set ts=4 sw=4:
#endif
