/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.internal.ui.palette.editparts;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FocusEvent;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.ImageUtilities;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.draw2d.text.ParagraphTextLayout;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.gef.ui.palette.PaletteMessages;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;

public class DetailedLabelFigure
extends Figure {
    private static final FontCache FONTCACHE = new FontCache();
    private static final Border PAGE_BORDER = new MarginBorder(0, 1, 0, 1);
    private SelectableImageFigure image = new SelectableImageFigure();
    private FlowPage page;
    private TextFlow nameText;
    private TextFlow descText;
    private Font boldFont;
    private boolean selectionState;
    private int layoutMode = -1;
    private Font cachedFont;

    public DetailedLabelFigure() {
        this.image.setAlignment(1);
        this.page = new FocusableFlowPage();
        this.page.setBorder(PAGE_BORDER);
        this.nameText = new TextFlow();
        this.nameText.setLayoutManager((LayoutManager)new ParagraphTextLayout(this.nameText, 2));
        this.descText = new TextFlow();
        this.descText.setLayoutManager((LayoutManager)new ParagraphTextLayout(this.descText, 2));
        this.page.add((IFigure)this.nameText);
        this.add((IFigure)this.image);
        this.add((IFigure)this.page);
        BorderLayout layout = new BorderLayout();
        layout.setHorizontalSpacing(2);
        layout.setVerticalSpacing(0);
        this.setLayoutManager((LayoutManager)layout);
    }

    public void addNotify() {
        super.addNotify();
        this.updateFont(this.layoutMode);
    }

    protected void dispose() {
        if (this.boldFont != null) {
            this.nameText.setFont(null);
            FONTCACHE.checkIn(this.boldFont);
            this.boldFont = null;
        }
        if (this.image != null) {
            this.image.disposeShadedImage();
        }
    }

    public void handleFocusGained(FocusEvent event) {
        super.handleFocusGained(event);
        this.updateColors();
    }

    public void handleFocusLost(FocusEvent event) {
        super.handleFocusLost(event);
        this.updateColors();
    }

    public boolean isNameTruncated() {
        return this.nameText.isTextTruncated();
    }

    public boolean isSelected() {
        return this.selectionState;
    }

    public void setDescription(String s) {
        String str = "";
        if (s != null && !s.trim().equals("") && !s.trim().equals(this.nameText.getText().trim())) {
            str = " " + PaletteMessages.NAME_DESCRIPTION_SEPARATOR + " " + s;
        }
        if (this.descText.getText().equals(str)) {
            return;
        }
        this.descText.setText(str);
    }

    public void setImage(Image icon) {
        this.image.setImage(icon);
    }

    public void setLayoutMode(int layoutMode) {
        this.updateFont(layoutMode);
        if (layoutMode == this.layoutMode) {
            return;
        }
        this.layoutMode = layoutMode;
        this.add((IFigure)this.page);
        if (this.descText.getParent() == this.page) {
            this.page.remove((IFigure)this.descText);
        }
        BorderLayout layout = (BorderLayout)this.getLayoutManager();
        if (layoutMode == 1) {
            this.page.setHorizontalAligment(2);
            layout.setConstraint((IFigure)this.image, (Object)BorderLayout.TOP);
            layout.setConstraint((IFigure)this.page, (Object)BorderLayout.CENTER);
        } else if (layoutMode == 2) {
            layout.setConstraint((IFigure)this.image, (Object)BorderLayout.CENTER);
            this.remove((IFigure)this.page);
        } else if (layoutMode == 0) {
            this.page.setHorizontalAligment(1);
            layout.setConstraint((IFigure)this.image, (Object)BorderLayout.LEFT);
            layout.setConstraint((IFigure)this.page, (Object)BorderLayout.CENTER);
        } else if (layoutMode == 3) {
            this.page.add((IFigure)this.descText);
            this.page.setHorizontalAligment(1);
            layout.setConstraint((IFigure)this.image, (Object)BorderLayout.LEFT);
            layout.setConstraint((IFigure)this.page, (Object)BorderLayout.CENTER);
        }
    }

    public void setName(String str) {
        if (this.nameText.getText().equals(str)) {
            return;
        }
        this.nameText.setText(str);
    }

    public void setSelected(boolean state) {
        this.selectionState = state;
        this.updateColors();
    }

    private void updateColors() {
        if (this.isSelected()) {
            if (this.hasFocus()) {
                this.image.useShadedImage();
                this.setForegroundColor(ColorConstants.menuForegroundSelected);
                this.setBackgroundColor(ColorConstants.menuBackgroundSelected);
            } else {
                this.image.disposeShadedImage();
                this.setForegroundColor(null);
                this.setBackgroundColor(ColorConstants.button);
            }
        } else {
            this.image.disposeShadedImage();
            this.setForegroundColor(null);
            this.setBackgroundColor(null);
        }
    }

    private void updateFont(int layout) {
        boolean layoutChanged = this.layoutMode != layout;
        boolean fontChanged = this.cachedFont == null || this.cachedFont != this.getFont();
        this.cachedFont = this.getFont();
        if (layoutChanged || fontChanged) {
            if (this.boldFont != null) {
                FONTCACHE.checkIn(this.boldFont);
                this.boldFont = null;
            }
            if (layout == 3 && this.cachedFont != null) {
                this.boldFont = FONTCACHE.checkOut(this.cachedFont);
            }
            this.nameText.setFont(this.boldFont);
        }
    }

    private class FocusableFlowPage
    extends FlowPage {
        FocusableFlowPage() {
        }

        protected void paintFigure(Graphics g) {
            if (DetailedLabelFigure.this.isSelected()) {
                Rectangle childBounds = null;
                List children = this.getChildren();
                int i = 0;
                while (i < children.size()) {
                    Figure child = (Figure)children.get(i);
                    if (i == 0) {
                        childBounds = child.getBounds().getCopy();
                    } else {
                        childBounds.union(child.getBounds());
                    }
                    ++i;
                }
                childBounds.expand(new Insets(2, 2, 0, 0));
                this.translateToParent((Translatable)childBounds);
                childBounds.intersect(this.getBounds());
                g.fillRectangle(childBounds);
                if (DetailedLabelFigure.this.hasFocus()) {
                    g.setXORMode(true);
                    g.setForegroundColor(ColorConstants.menuBackgroundSelected);
                    g.setBackgroundColor(ColorConstants.white);
                    g.drawFocus(childBounds.resize(-1, -1));
                }
            } else {
                super.paintFigure(g);
            }
        }
    }

    private static class SelectableImageFigure
    extends ImageFigure {
        private Image shadedImage;

        SelectableImageFigure() {
        }

        protected void useShadedImage() {
            this.disposeShadedImage();
            if (super.getImage() != null) {
                ImageData data = ImageUtilities.createShadedImage((Image)super.getImage(), (Color)ColorConstants.menuBackgroundSelected);
                this.shadedImage = new Image(null, data, data.getTransparencyMask());
            }
        }

        protected void disposeShadedImage() {
            if (this.shadedImage != null) {
                this.shadedImage.dispose();
                this.shadedImage = null;
            }
        }

        public Image getImage() {
            if (this.shadedImage != null) {
                return this.shadedImage;
            }
            return super.getImage();
        }

        public void setImage(Image image) {
            if (image == super.getImage()) {
                return;
            }
            boolean wasShaded = this.shadedImage != null;
            this.disposeShadedImage();
            super.setImage(image);
            if (wasShaded) {
                this.useShadedImage();
            }
        }
    }

    private static class FontCache {
        private Hashtable table = new Hashtable();

        FontCache() {
        }

        public void checkIn(Font boldFont) {
            FontInfo info = null;
            Map.Entry entry = null;
            Set values = this.table.entrySet();
            Iterator iter = values.iterator();
            while (iter.hasNext()) {
                Map.Entry tempEntry = (Map.Entry)iter.next();
                FontInfo tempInfo = (FontInfo)tempEntry.getValue();
                if (tempInfo.boldFont != boldFont) continue;
                info = tempInfo;
                entry = tempEntry;
                break;
            }
            FontInfo fontInfo = info;
            fontInfo.refCount = fontInfo.refCount - 1;
            if (info.refCount == 0) {
                boldFont.dispose();
                this.table.remove(entry.getKey());
            }
        }

        public Font checkOut(Font font) {
            FontInfo info = null;
            FontData key = font.getFontData()[0];
            Object obj = this.table.get(key);
            if (obj != null) {
                info = (FontInfo)obj;
            } else {
                info = new FontInfo();
                FontData[] boldDatas = font.getFontData();
                int i = 0;
                while (i < boldDatas.length) {
                    boldDatas[i].setStyle(1);
                    ++i;
                }
                info.boldFont = new Font((Device)Display.getCurrent(), boldDatas);
                this.table.put(key, info);
            }
            FontInfo fontInfo = info;
            fontInfo.refCount = fontInfo.refCount + 1;
            return info.boldFont;
        }

        private class FontInfo {
            private Font boldFont;
            private int refCount;

            FontInfo() {
            }
        }
    }
}

