/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.internal.progress.JobInfo;
import org.eclipse.ui.internal.progress.JobTreeElement;
import org.eclipse.ui.internal.progress.ProgressManagerUtil;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.internal.progress.ProgressTreeContentProvider;
import org.eclipse.ui.internal.progress.ProgressTreeViewer;
import org.eclipse.ui.internal.progress.ProgressViewUpdater;
import org.eclipse.ui.part.ViewPart;

public class ProgressView
extends ViewPart
implements IViewPart {
    ProgressTreeViewer viewer;
    Action cancelAction;

    public void createPartControl(Composite parent) {
        this.viewer = new ProgressTreeViewer(parent, 770);
        this.viewer.setUseHashlookup(true);
        this.viewer.setSorter(ProgressManagerUtil.getProgressViewerSorter());
        this.initContentProvider();
        ProgressManagerUtil.initLabelProvider(this.viewer);
        this.initContextMenu();
        this.initPulldownMenu();
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
    }

    public void setFocus() {
    }

    protected void initContentProvider() {
        ProgressTreeContentProvider provider = new ProgressTreeContentProvider(this.viewer);
        this.viewer.setContentProvider((IContentProvider)provider);
        this.viewer.setInput(provider);
    }

    private void initContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        Menu menu = menuMgr.createContextMenu((Control)this.viewer.getTree());
        this.createCancelAction();
        menuMgr.add((IAction)this.cancelAction);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                JobInfo info = ProgressView.this.getSelectedInfo();
                if (info == null) {
                    return;
                }
            }
        });
        menuMgr.add((IContributionItem)new Separator("additions"));
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
        this.viewer.getTree().setMenu(menu);
    }

    private void initPulldownMenu() {
        IMenuManager menuMgr = this.getViewSite().getActionBars().getMenuManager();
        menuMgr.add((IAction)new Action(ProgressMessages.getString("ProgressView.VerboseAction"), 2){

            public void run() {
                ProgressViewUpdater updater = ProgressViewUpdater.getSingleton();
                updater.debug = !updater.debug;
                this.setChecked(updater.debug);
                updater.refreshAll();
            }
        });
    }

    private IStructuredSelection getSelection() {
        ISelectionProvider provider = this.getSite().getSelectionProvider();
        if (provider == null) {
            return null;
        }
        ISelection currentSelection = provider.getSelection();
        if (currentSelection instanceof IStructuredSelection) {
            return (IStructuredSelection)currentSelection;
        }
        return null;
    }

    JobInfo getSelectedInfo() {
        JobTreeElement element;
        IStructuredSelection selection = this.getSelection();
        if (selection != null && selection.size() == 1 && (element = (JobTreeElement)selection.getFirstElement()).isJobInfo()) {
            return (JobInfo)element;
        }
        return null;
    }

    private void createCancelAction() {
        this.cancelAction = new Action(ProgressMessages.getString("ProgressView.CancelAction")){

            public void run() {
                ProgressView.this.viewer.cancelSelection();
            }
        };
    }
}

