/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.internal.progress.AnimationItem;
import org.eclipse.ui.internal.progress.GroupInfo;
import org.eclipse.ui.internal.progress.IAnimationProcessor;
import org.eclipse.ui.internal.progress.IJobProgressManagerListener;
import org.eclipse.ui.internal.progress.JobInfo;
import org.eclipse.ui.internal.progress.ProgressAnimationProcessor;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.progress.WorkbenchJob;

public class AnimationManager {
    private static AnimationManager singleton;
    boolean animated = false;
    private IJobProgressManagerListener listener;
    IAnimationProcessor animationProcessor = new ProgressAnimationProcessor(this);
    WorkbenchJob animationStartJob;
    WorkbenchJob animationDoneJob;

    public static AnimationManager getInstance() {
        if (singleton == null) {
            singleton = new AnimationManager();
        }
        return singleton;
    }

    static Color getItemBackgroundColor(Control control) {
        return control.getDisplay().getSystemColor(29);
    }

    AnimationManager() {
        this.listener = this.getProgressListener();
        ProgressManager.getInstance().addListener(this.listener);
        this.animationStartJob = new WorkbenchJob(ProgressMessages.getString("AnimationManager.AnimationStart")){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                AnimationManager.this.animationProcessor.animationStarted();
                return Status.OK_STATUS;
            }
        };
        this.animationStartJob.setSystem(true);
        this.animationDoneJob = new WorkbenchJob(ProgressMessages.getString("AnimationManager.DoneJobName")){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                AnimationManager.this.animationProcessor.animationFinished();
                return Status.OK_STATUS;
            }
        };
        this.animationDoneJob.setSystem(true);
    }

    void addItem(AnimationItem item) {
        this.animationProcessor.addItem(item);
    }

    boolean isAnimated() {
        return this.animated;
    }

    void setAnimated(boolean bool) {
        this.animated = bool;
        if (bool) {
            this.animationStarted();
        } else {
            this.animationFinished();
        }
    }

    void dispose() {
        this.setAnimated(false);
        ProgressManager.getInstance().removeListener(this.listener);
    }

    private IJobProgressManagerListener getProgressListener() {
        return new IJobProgressManagerListener(){
            HashSet jobs = new HashSet();

            public void addJob(JobInfo info) {
                this.incrementJobCount(info);
            }

            public void refreshJobInfo(JobInfo info) {
                int state = info.getJob().getState();
                if (state == 4) {
                    this.addJob(info);
                } else {
                    this.removeJob(info);
                }
            }

            public void refreshAll() {
                ProgressManager manager = ProgressManager.getInstance();
                this.jobs.clear();
                AnimationManager.this.setAnimated(false);
                JobInfo[] currentInfos = manager.getJobInfos(this.showsDebug());
                int i = 0;
                while (i < currentInfos.length) {
                    this.addJob(currentInfos[i]);
                    ++i;
                }
            }

            public void removeJob(JobInfo info) {
                if (this.jobs.contains(info.getJob())) {
                    this.decrementJobCount(info.getJob());
                }
            }

            public boolean showsDebug() {
                return false;
            }

            private void incrementJobCount(JobInfo info) {
                if (this.isNotTracked(info)) {
                    return;
                }
                if (this.jobs.isEmpty()) {
                    AnimationManager.this.setAnimated(true);
                }
                this.jobs.add(info.getJob());
            }

            private void decrementJobCount(Job job) {
                this.jobs.remove(job);
                if (this.jobs.isEmpty()) {
                    AnimationManager.this.setAnimated(false);
                }
            }

            private boolean isNotTracked(JobInfo info) {
                Job job = info.getJob();
                return job.getState() != 4 || AnimationManager.this.animationProcessor.isProcessorJob(job);
            }

            public void addGroup(GroupInfo info) {
            }

            public void removeGroup(GroupInfo group) {
            }

            public void refreshGroup(GroupInfo info) {
            }
        };
    }

    private void animationStarted() {
        this.animationDoneJob.cancel();
        this.animationStartJob.schedule();
    }

    private void animationFinished() {
        this.animationStartJob.cancel();
        this.animationDoneJob.schedule();
    }

    int getPreferredWidth() {
        return this.animationProcessor.getPreferredWidth();
    }
}

