/*
 * Decompiled with CFR 0.152.
 */
package demo.swingset;

import demo.swingset.DemoModule;
import demo.swingset.SwingSet2;
import java.util.Random;
import swingwt.awt.Color;
import swingwt.awt.Component;
import swingwt.awt.Graphics;
import swingwt.awt.event.ActionEvent;
import swingwt.awt.event.ActionListener;
import swingwt.awt.image.ImageObserver;
import swingwtx.swing.AbstractButton;
import swingwtx.swing.ButtonGroup;
import swingwtx.swing.Icon;
import swingwtx.swing.ImageIcon;
import swingwtx.swing.JComponent;
import swingwtx.swing.JLabel;
import swingwtx.swing.JPanel;
import swingwtx.swing.JRadioButton;
import swingwtx.swing.JTabbedPane;
import swingwtx.swing.Timer;
import swingwtx.swing.event.ChangeEvent;
import swingwtx.swing.event.ChangeListener;

public class TabbedPaneDemo
extends DemoModule
implements ActionListener {
    HeadSpin spin;
    JTabbedPane tabbedpane;
    ButtonGroup group;
    JRadioButton top;
    JRadioButton bottom;
    JRadioButton left;
    JRadioButton right;

    public static void main(String[] stringArray) {
        TabbedPaneDemo tabbedPaneDemo = new TabbedPaneDemo(null);
        tabbedPaneDemo.mainImpl();
    }

    public TabbedPaneDemo(SwingSet2 swingSet2) {
        super(swingSet2, "TabbedPaneDemo", "toolbar/JTabbedPane.gif");
        JPanel jPanel = new JPanel();
        jPanel.add((Component)new JLabel(this.getString("TabbedPaneDemo.label")));
        this.top = (JRadioButton)jPanel.add((Component)new JRadioButton(this.getString("TabbedPaneDemo.top")));
        this.left = (JRadioButton)jPanel.add((Component)new JRadioButton(this.getString("TabbedPaneDemo.left")));
        this.bottom = (JRadioButton)jPanel.add((Component)new JRadioButton(this.getString("TabbedPaneDemo.bottom")));
        this.right = (JRadioButton)jPanel.add((Component)new JRadioButton(this.getString("TabbedPaneDemo.right")));
        this.getDemoPanel().add((Component)jPanel, (Object)"North");
        this.group = new ButtonGroup();
        this.group.add((AbstractButton)this.top);
        this.group.add((AbstractButton)this.bottom);
        this.group.add((AbstractButton)this.left);
        this.group.add((AbstractButton)this.right);
        this.top.setSelected(true);
        this.top.addActionListener((ActionListener)this);
        this.bottom.addActionListener((ActionListener)this);
        this.left.addActionListener((ActionListener)this);
        this.right.addActionListener((ActionListener)this);
        this.tabbedpane = new JTabbedPane();
        this.getDemoPanel().add((Component)this.tabbedpane, (Object)"Center");
        String string = this.getString("TabbedPaneDemo.laine");
        JLabel jLabel = new JLabel((Icon)this.createImageIcon("tabbedpane/laine.jpg", string));
        this.tabbedpane.add(string, (Component)jLabel);
        string = this.getString("TabbedPaneDemo.ewan");
        jLabel = new JLabel((Icon)this.createImageIcon("tabbedpane/ewan.jpg", string));
        this.tabbedpane.add(string, (Component)jLabel);
        string = this.getString("TabbedPaneDemo.hania");
        jLabel = new JLabel((Icon)this.createImageIcon("tabbedpane/hania.jpg", string));
        this.tabbedpane.add(string, (Component)jLabel);
        string = this.getString("TabbedPaneDemo.bounce");
        this.spin = new HeadSpin();
        this.tabbedpane.add(string, (Component)this.spin);
        this.tabbedpane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (TabbedPaneDemo.this.tabbedpane.getSelectedIndex() == TabbedPaneDemo.this.tabbedpane.getTabCount() - 1) {
                    TabbedPaneDemo.this.spin.go();
                }
            }
        });
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.top) {
            this.tabbedpane.setTabPlacement(1);
        } else if (actionEvent.getSource() == this.left) {
            this.tabbedpane.setTabPlacement(2);
        } else if (actionEvent.getSource() == this.bottom) {
            this.tabbedpane.setTabPlacement(3);
        } else if (actionEvent.getSource() == this.right) {
            this.tabbedpane.setTabPlacement(4);
        }
    }

    class HeadSpin
    extends JComponent
    implements ActionListener {
        Timer animator;
        ImageIcon[] icon = new ImageIcon[6];
        int tmpScale;
        static final int numImages = 6;
        double[] x = new double[6];
        double[] y = new double[6];
        int[] xh = new int[6];
        int[] yh = new int[6];
        double[] scale = new double[6];
        Random rand = new Random();

        public HeadSpin() {
            this.setBackground(Color.black);
            this.icon[0] = TabbedPaneDemo.this.createImageIcon("tabbedpane/ewan.gif", TabbedPaneDemo.this.getString("TabbedPaneDemo.ewan"));
            this.icon[1] = TabbedPaneDemo.this.createImageIcon("tabbedpane/stephen.gif", TabbedPaneDemo.this.getString("TabbedPaneDemo.stephen"));
            this.icon[2] = TabbedPaneDemo.this.createImageIcon("tabbedpane/david.gif", TabbedPaneDemo.this.getString("TabbedPaneDemo.david"));
            this.icon[3] = TabbedPaneDemo.this.createImageIcon("tabbedpane/matthew.gif", TabbedPaneDemo.this.getString("TabbedPaneDemo.matthew"));
            this.icon[4] = TabbedPaneDemo.this.createImageIcon("tabbedpane/blake.gif", TabbedPaneDemo.this.getString("TabbedPaneDemo.blake"));
            this.icon[5] = TabbedPaneDemo.this.createImageIcon("tabbedpane/brooke.gif", TabbedPaneDemo.this.getString("TabbedPaneDemo.brooke"));
            this.setDoubleBuffered(true);
        }

        public void go() {
            this.animator = new Timer(66, (ActionListener)this);
            this.animator.start();
        }

        public void paint(Graphics graphics) {
            graphics.setColor(Color.black);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            for (int i = 0; i < 6; ++i) {
                if (this.x[i] > (double)(3 * i)) {
                    this.nudge(i);
                    this.squish(graphics, this.icon[i], this.xh[i], this.yh[i], this.scale[i]);
                    continue;
                }
                int n = i;
                this.x[n] = this.x[n] + 0.05;
                int n2 = i;
                this.y[n2] = this.y[n2] + 0.05;
            }
        }

        public void nudge(int n) {
            int n2 = n;
            this.x[n2] = this.x[n2] + (double)this.rand.nextInt(1000) / 8756.0;
            int n3 = n;
            this.y[n3] = this.y[n3] + (double)this.rand.nextInt(1000) / 5432.0;
            int n4 = (int)(Math.abs(Math.sin(this.x[n])) * 10.0);
            this.scale[n] = (double)n4 / 10.0;
            int n5 = (int)((double)this.getWidth() / 2.0 * 0.8);
            int n6 = (int)((double)this.getHeight() / 2.0 * 0.6);
            this.xh[n] = (int)(Math.sin(this.x[n]) * (double)n5) + n5;
            this.yh[n] = (int)(Math.sin(this.y[n]) * (double)n6) + n6;
        }

        public void squish(Graphics graphics, ImageIcon imageIcon, int n, int n2, double d) {
            if (this.isVisible()) {
                graphics.drawImage(imageIcon.getImage(), n, n2, (int)((double)imageIcon.getIconWidth() * d), (int)((double)imageIcon.getIconHeight() * d), (ImageObserver)this);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.isVisible()) {
                this.repaint();
            } else {
                this.animator.stop();
            }
        }
    }
}

