// notice: here is a example_treedict.tar.bz2
// try "./directory2treedic example_treedict"

//only one type identifier is supported currently...who need more?

//If you have problem with filename convertion to utf, add 
//	G_BROKEN_FILENAMES=1
//	export G_BROKEN_FILENAMES
// to your ~/.bash_profile

#include "stdio.h"
#include "stdlib.h"
#include <string.h>
#include <sys/stat.h>

#include <gtk/gtk.h>

void add_dir(FILE *tdxfile, FILE *dicfile, char *dirname, glong *wordcount)
{
	gchar *utf8filename;
	glong tmpglong, offset_old;
	gchar *p;
	gsize bytes_written;
	
	p = strrchr(dirname, '/');
	if (p)
		utf8filename = g_filename_to_utf8(p+1, -1, NULL, &bytes_written,NULL);
	else
		utf8filename = g_filename_to_utf8(dirname, -1, NULL, &bytes_written,NULL);
	if (!utf8filename) {
		g_print("filename %s convert to utf8 error!\n", dirname);
		return;
	}
	fwrite(utf8filename,sizeof(gchar), bytes_written+1, tdxfile);
	tmpglong = g_htonl(0);
	fwrite(&(tmpglong),sizeof(glong),1,tdxfile); //need more work...
	tmpglong = g_htonl(0);
	fwrite(&(tmpglong),sizeof(glong),1,tdxfile); //need more work...
	glong subcount_offset = ftell(tdxfile);
	tmpglong = g_htonl(0);
	fwrite(&(tmpglong),sizeof(glong),1,tdxfile); //it will be rewrite later.

	(*wordcount)++;
	
	glong subwordcount = 0;
	
	GDir* dir = g_dir_open(dirname, 0, NULL);
	const gchar *filename;
	gchar fullfilename[256];
	gint len;
	FILE *file;
	struct stat stats;
	gchar *buffer = NULL;
	glong last_buffersize=0;
	gint dirname_len = strlen(dirname);
	while ((filename = g_dir_read_name(dir))!=NULL) {
		if (filename[0]=='.') //hiden file.
			continue;
		subwordcount++;
		sprintf(fullfilename, "%s/%s", dirname, filename);
		if (g_file_test(fullfilename, G_FILE_TEST_IS_DIR)) {
			add_dir(tdxfile, dicfile, fullfilename, wordcount);
		}
		else {			
			len = strlen(filename);
			utf8filename = g_filename_to_utf8(fullfilename+ dirname_len+1, len -2, NULL, &bytes_written,NULL);			
			if (utf8filename) {				
				offset_old = ftell(dicfile);	
				stat (fullfilename, &stats);						
				if (last_buffersize < stats.st_size) {
					buffer = (gchar *)g_realloc(buffer, stats.st_size);
					last_buffersize = stats.st_size;
				}
				file = fopen(fullfilename,"r");
				fread (buffer, 1, stats.st_size, file);
				fclose (file);
				fwrite(buffer, 1, stats.st_size, dicfile);				
								
				fwrite(utf8filename,sizeof(gchar), bytes_written+1, tdxfile);
				tmpglong = g_htonl(offset_old);
				fwrite(&(tmpglong),sizeof(glong),1,tdxfile);
				tmpglong = g_htonl(stats.st_size);
				fwrite(&(tmpglong),sizeof(glong),1,tdxfile);
				tmpglong = g_htonl(0);
				fwrite(&(tmpglong),sizeof(glong),1,tdxfile);
				
				g_free(utf8filename);								
				(*wordcount)++;
			}
			else {
				g_print("filename %s convert to utf8 error!\n", fullfilename);
				return;
			}
		}
	}
	g_dir_close(dir);
	g_free(buffer);
	
	glong tmp_offset = ftell(tdxfile);
	fseek(tdxfile,subcount_offset,SEEK_SET);
	tmpglong = g_htonl(subwordcount);
	fwrite(&(tmpglong),sizeof(glong),1,tdxfile);
	fseek(tdxfile,tmp_offset,SEEK_SET);
}

void convert(char *dirname)
{	
	struct stat stats;
	
	if (stat (dirname, &stats) == -1)
	{
		printf("directory not exist!\n");
		return;
	}		
		
	gchar filename[256];
	
	sprintf(filename, "%s/.ifo", dirname);
	if (stat (filename, &stats) == -1)
	{
		printf("%s not exist!\n", filename);
		return;
	}		
	FILE *ifofile;
	ifofile = fopen(filename, "r");
	gchar *buffer;
	gint buffer_len = stats.st_size;
	buffer = (gchar *)g_malloc (stats.st_size);
	fread (buffer, 1, stats.st_size, ifofile);
	fclose (ifofile);

	FILE *tdxfile,*dicfile;
	sprintf(filename, "%s.tdx", dirname);
	tdxfile = fopen(filename,"w");
	sprintf(filename, "%s.dict", dirname);
	dicfile = fopen(filename,"w");


	glong wordcount = 0;
	
	add_dir(tdxfile, dicfile, dirname, &wordcount);
		
	g_print("wordcount: %ld\n",wordcount);
	
	fclose(tdxfile);
	fclose(dicfile);

	sprintf(filename, "%s.ifo", dirname);
	ifofile = fopen(filename,"w");
	fprintf(ifofile, "StarDict's treedict ifo file\nversion=2.4.2\n");
	fprintf(ifofile, "wordcount=%ld\n", wordcount);	
	sprintf(filename, "%s.tdx", dirname);
	stat (filename, &stats);
	fprintf(ifofile, "tdxfilesize=%ld\n", stats.st_size);	
	fwrite(buffer, 1, buffer_len, ifofile);
	g_free(buffer);
	fclose(ifofile);


	gchar command[256];
	sprintf(command, "gzip -9 %s.tdx -f", dirname);
	system(command);	
	sprintf(command, "dictzip %s.dict -f", dirname);
	system(command);	
}

int
main(int argc,char * argv [])
{
	if (argc!=2) {
		printf("please type this:\n./directory2treedic InfoBrowse\n");
		return FALSE;
	}

	gtk_set_locale ();
	g_type_init ();
	convert (argv[1]);
	return FALSE;	
}
