#ifndef OPENGL_H

#ifdef HAVE_CONFIG_H
#include "config.H"
#endif

#ifdef __GNUC__
#  pragma interface
#endif

#include <iostream.h>
#include "graph2D.H"

class TOpenGL : public Tgraph2D {
private:
	greal xmax,ymax;
	greal titlefontsize, labelfontsize, axisfontsize, annotfontsize;
	void *font;
	greal fontheight;
	bool font_is_bitmap;
	int pal[3][Ncolors];
public:
	TOpenGL(greal xmax1, greal ymax1,
			greal titlefontsize1, greal labelfontsize1, greal axisfontsize1, greal annotfontsize1);
	void begin_line(greal x, greal y);
	void vertex(greal x1, greal y1);
	void end_line();
	void begin_fill(greal x, greal y);
	void end_fill();
	bool polygons_always_convex() const {return true;}
	void point(greal x, greal y);
	void circle(greal x, greal y, greal r);
	void fillcircle(greal x, greal y, greal r);
	void text(greal x, greal y, const char *s, int Xoffset, int Yoffset, bool rotate);
	void text_exponent(greal x, greal y, const char *mant, const char *expo, int Xoffset, int Yoffset);
	void comment(greal x, greal y);
	void comment(const char *s);
	void setfont(TFontType font);
	void setlinewidth(greal lw);
	void setlinetype(TLineType lt);
	void setcolor(const greal rgb[3]);
	void setcolor(int i);
	void begin_clipped(greal x1, greal y1, greal x2, greal y2);
	void end_clipped();
	void fillrrect(greal x1, greal y1, greal dx, greal dy);
	void fillrrect_interp(greal x1, greal y1, greal dx, greal dy, int u1, int u2, int u3, int u4);
	void setpalette(const int pal1[3][Ncolors]);
	void gsave();
	void grestore();
	~TOpenGL();
};

#define OPENGL_H

#endif
