# Songwrite
# Copyright (C) 2001-2002 Jean-Baptiste LAMY
#
# This program is free software. See README or LICENSE for the license terms.

import Tkinter

class LinksBar:
  def __init__(self, canvas, x, y, content, **kargs):
    self.links   = []
    self.delta_x = {}
    self.funcids = {}
    self.canvas  = canvas
    
    x0 = x
    
    for (text, func) in content:
      link = canvas.create_text(x, y, text = text, font = "Helvetica -12 underline", fill = "blue3", activefill = "red", anchor = "w", **kargs)
      self.links  .append(link)
      self.funcids[link] = canvas.tag_bind(link, "<ButtonRelease>", func)
      self.delta_x[link] = x - x0
      x = canvas.bbox(link)[2] + 20
      
  def coords(self, x, y):
    for link in self.links:
      self.canvas.coords(link, x + self.delta_x[link], y)
    
  def destroy(self):
    for link in self.links:
      self.canvas.tag_unbind(link, "<ButtonRelease>", self.funcids[link])
      
      
      
