/* Somaplayer - Copyright (C) 2003-5 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif

#ifdef ENABLE_GTK

#include "../player.h"
#include "../other.h"
#include "gdaemon.h"

static GtkWidget *gstatus_treeview;

char *gstatus_color(GdkColor *c) {
  static char buf[8];

  snprintf(buf, sizeof(buf), "#%.2X%.2X%.2X", (c->red >> 8), (c->green >>8), (c->blue >> 8));

  return buf;
}

char *gstatus_get(daemon_client *c) {
  static char status[1024];
  char *buf;

  if (!c->socket)
    return "unknow";

  else
    {
      somaplayer_controller *sc = NULL;

      if (!(buf = strdup (c->socket)))
        fatal (_("Error: memory."));

      if (!strncmp (buf, "unix://", 7))
        {
          sc = somaplayer_open_unix (buf + 7);
        }

      else if (!strncmp (buf, "tcp://", 6))
        {
          char *server;
          int i, port = 0;

          server = buf + 6;

          for (i = 0; i < strlen (server); i++)
            {
              if (server[i] == ':')
                {
                  if (i + 1 < strlen (server))
                    port = atoi (&server[i + 1]);

                  server[i] = 0;
                }
            }

          server = c->addr;
          sc = somaplayer_open_tcp (server, port);
        }

      free (buf);
      buf=NULL;

      if (sc)
        {
          buf=somaplayer_this (sc);
          somaplayer_close (sc);
        }
    }

  if(!buf) return "unknow";
  else {
    strncpy(status, buf, sizeof(status));
    free(buf);
    return status;
  }

}

int gstatus_timeout(gpointer dummy) {
  GtkListStore *model;
  GtkTreeIter iter;
  char *status;
  char buf[1024];
  int i;

  model = (GtkListStore *)gtk_tree_view_get_model(GTK_TREE_VIEW(gstatus_treeview));
  while(gtk_tree_model_iter_nth_child(GTK_TREE_MODEL(model), &iter, NULL, 0))
	  gtk_list_store_remove(model, &iter);

  pthread_mutex_lock (&play->daemon->mutex);

  for(i=0;i<DAEMON_MAX_CLIENTS;i++) {
    if(play->daemon->client[i]!=NULL) {
      status=gstatus_get(play->daemon->client[i]);

      gtk_list_store_append(model, &iter);
      snprintf(buf, sizeof(buf), "<span color=\"%s\">%s</span>", gstatus_color(play->daemon->client[i]->color), play->daemon->client[i]->addr);
      gtk_list_store_set(model, &iter, 0,  buf,  -1);
      gtk_list_store_set(model, &iter, 1,  gstatus_get(play->daemon->client[i]),  -1);
    }
  }

  pthread_mutex_unlock (&play->daemon->mutex);

  return TRUE;
}

/* Hide and Show functions */
void
gstatus_hide (GtkWidget * w, gpointer data)
{
  gtk_widget_hide (wingstatus);
}

void
gstatus_show (GtkWidget * w, gpointer data)
{
  gstatus_timeout(NULL);
  gtk_widget_show (wingstatus);
}

/* Create the window */
GtkWidget *
create_wingstatus (void)
{
  GtkWidget *window;
  GtkWidget *frame;
  GtkWidget *scrolledwindow;
  GtkListStore *list;
  GtkTreeViewColumn *column;
  GtkTreeSelection *selection;
static GtkCellRenderer *cell;

  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_size_request (window, 400, 300);
  gtk_window_set_title (GTK_WINDOW (window), _("SdS - status input"));

  frame = gtk_frame_new (NULL);
  gtk_widget_show (frame);
  gtk_container_add (GTK_CONTAINER (window), frame);

  g_signal_connect ((gpointer) window, "delete_event",
		    G_CALLBACK (gstatus_hide), NULL);

  scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show(scrolledwindow);
  gtk_container_add (GTK_CONTAINER (frame), scrolledwindow);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow),
                                  GTK_POLICY_NEVER, GTK_POLICY_NEVER);
  gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (scrolledwindow),
                                       GTK_SHADOW_IN);

  list = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING);
  gstatus_treeview = gtk_tree_view_new ();
  gtk_widget_show(gstatus_treeview);
  gtk_tree_view_set_model (GTK_TREE_VIEW (gstatus_treeview),
                           GTK_TREE_MODEL (list));
  gtk_container_add (GTK_CONTAINER (scrolledwindow), gstatus_treeview);
  gtk_tree_view_set_rules_hint (GTK_TREE_VIEW (gstatus_treeview), TRUE);
  gtk_tree_view_set_reorderable (GTK_TREE_VIEW (gstatus_treeview), TRUE);
  gtk_tree_view_set_enable_search (GTK_TREE_VIEW (gstatus_treeview), TRUE);
  selection =
    gtk_tree_view_get_selection (GTK_TREE_VIEW (gstatus_treeview));
  gtk_tree_selection_set_mode (selection, GTK_SELECTION_MULTIPLE);

  g_object_unref (list);

  cell = gtk_cell_renderer_text_new ();
  column = gtk_tree_view_column_new_with_attributes ("Inputs", cell, "markup", 0, NULL);
  gtk_tree_view_append_column (GTK_TREE_VIEW (gstatus_treeview), GTK_TREE_VIEW_COLUMN (column));

  cell = gtk_cell_renderer_text_new ();
  column = gtk_tree_view_column_new_with_attributes ("Status", cell, "text", 1, NULL);
  gtk_tree_view_append_column (GTK_TREE_VIEW (gstatus_treeview), GTK_TREE_VIEW_COLUMN (column));

  return window;
}

#endif

/* EOF */
