#! /usr/local/bin/perl

# summary2gp.pl : generate input data for gnuplot from summary of log.

# Usage: cat summary* | summary2gp.pl

open (GP1, ">gp-data.a") || die("gp-data.a");
open (GP2, ">gp-data.b") || die("gp-data.b");
open (GP3, ">gp-data.c") || die("gp-data.c");
open (GP4, ">gp-data.d") || die("gp-data.d");
open (GP5, ">gp-data.e") || die("gp-data.e");
open (GP6, ">gp-data.f") || die("gp-data.f");

while (<>) {
	chop;
	next if (/^#/);
	@data = split(',');

#	next if ($data[9] > 3000);	# ignore too slow completion
#	next if ($data[6] < 0);		# ignore tsendmail=-1
	next if ($data[2] < 10);	# ignore too small recipients
	next if ($data[4] < 10);	# ignore too small transactions

#####
	next if ($data[2] < 3000);
	next if ($data[2] > 4000);
#####

	$data[6] = 0 if ($data[6] < 0);

	# par recipient
	print  GP1 "1, 2, 3, 4, 5, 6, 7, ";
	printf GP1 "%d, %d, %d, %d, %d, %d, %d\n",
		$data[2], $data[6], $data[7], $data[8], $data[9],
		$data[6] + $data[7] + $data[8],
		$data[6] + $data[7] + $data[9];

	# par transaction
	print  GP2 "1, 2, 3, 4, 5, 6, 7, ";
	printf GP2 "%d, %d, %d, %d, %d, %d, %d\n",
		$data[4], $data[6], $data[7], $data[8], $data[9],
		$data[6] + $data[7] + $data[8],
		$data[6] + $data[7] + $data[9];

	# average par recipient
	print  GP3 "1, 2, 3, 4, 5, 6, 7, ";
	printf GP3 "%d, %f, %f, %f, %f, %f, %f\n",
		$data[2],
		$data[6] / $data[2], $data[7] / $data[2],
		$data[8] / $data[2], $data[9] / $data[2],
		($data[6] + $data[7] + $data[8]) / $data[2],
		($data[6] + $data[7] + $data[9]) / $data[2];

	# average par transaction
	print  GP4 "1, 2, 3, 4, 5, 6, 7, ";
	printf GP4 "%d, %f, %f, %f, %f, %f, %f\n",
		$data[4],
		$data[6] / $data[4], $data[7] / $data[4],
		$data[8] / $data[4], $data[9] / $data[4],
		($data[6] + $data[7] + $data[8]) / $data[4],
		($data[6] + $data[7] + $data[9]) / $data[4];

	($time1, $time2) = split(' ', $data[0]);
	($M, $D) = split('/', $time1);
	($h, $m, $s) = split(':', $time2);
	$M -= 8;	# XXX
	$x = ((($M * 31 + $D) * 24 + $h) * 60 + $m) * 60 + $s;

	# par recipient
	print  GP5 "1, 2, 3, 4, 5, 6, 7, ";
	printf GP5 "%d, %f, %f, %f, %f, %f, %f\n",
		$x,
		$data[6] / $data[2], $data[7] / $data[2],
		$data[8] / $data[2], $data[9] / $data[2],
		($data[6] + $data[7] + $data[8]) / $data[2],
		($data[6] + $data[7] + $data[9]) / $data[2];

	# par transaction
	print  GP6 "1, 2, 3, 4, 5, 6, 7, ";
	printf GP6 "%d, %f, %f, %f, %f, %f, %f\n",
		$x,
		$data[6] / $data[4], $data[7] / $data[4],
		$data[8] / $data[4], $data[9] / $data[4],
		($data[6] + $data[7] + $data[8]) / $data[4],
		($data[6] + $data[7] + $data[9]) / $data[4];

}

exit 0;
