package SliMP3::Buttons::Search;

# SliMP3 Server Copyright (C) 2001 Sean Adams, Slim Devices Inc.
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License,
# version 2.

use strict;
use File::Spec::Functions qw(:ALL);
use File::Spec::Functions qw(updir);
use SliMP3::Buttons::Common;
use SliMP3::Buttons::SearchFor;
use SliMP3::Strings qw (string);

# button functions for search directory
my @searchChoices = ('ARTISTS','ALBUMS','SONGS');
my %functions = (
	'up' => sub  {
		my $client = shift;
		my $newposition = SliMP3::Buttons::Common::scroll($client, -1, ($#searchChoices + 1), $client->searchSelection);
		$client->searchSelection($newposition);
		SliMP3::Display::update($client);
	},
	'down' => sub  {
		my $client = shift;
		my $newposition = SliMP3::Buttons::Common::scroll($client, +1, ($#searchChoices + 1), $client->searchSelection);
		$client->searchSelection($newposition);
		SliMP3::Display::update($client);
	},
	'left' => sub  {
		my $client = shift;
		my @oldlines = SliMP3::Display::curLines($client);
		SliMP3::Buttons::Common::setMode($client, 'home');
		SliMP3::Animation::pushRight($client, @oldlines, SliMP3::Display::curLines($client));
	},
	'right' => sub  {
		my $client = shift;
		my @oldlines = SliMP3::Display::curLines($client);
		SliMP3::Buttons::Common::pushMode($client, 'searchfor');
		SliMP3::Buttons::SearchFor::searchFor($client, $searchChoices[$client->searchSelection]);
		SliMP3::Animation::pushLeft($client, @oldlines, SliMP3::Display::curLines($client));
	}
);

sub getFunctions {
	return \%functions;
}

sub setMode {
	my $client = shift;
	if (!defined($client->searchSelection)) { $client->searchSelection(0); };
	$client->lines(\&lines);
}

#
# figure out the lines to be put up to display the directory
#
sub lines {
	my $client = shift;
	my ($line1, $line2);
	$line1 = string('SEARCH');
	$line2 = string('SEARCHFOR') . ' ' . string($searchChoices[$client->searchSelection]);
	return ($line1, $line2, undef, SliMP3::VFD::symbol('rightarrow'));
}

1;

__END__
