/* Pretty printing exported functions. */

#if !defined PPRINT_H
#define PPRINT_H

#ifdef __cplusplus
extern "C"
{
#endif

typedef struct pretty *pretty_t;

/* The empty pretty printing data structure. */
#define PPRINT_NULL ((pretty_t)0)

/* Call this before building all pretty printing data structures. */
void pprint_init();

/* Creates a pretty printing data structure for a string and adds it
   in front of a list of pretty printing data structures. */
pretty_t pstring(const char *, pretty_t);

/* Creates a pretty printing data structure for unbreakable space and
   adds it in front of a list of pretty printing data structures. */
pretty_t pspace(int, pretty_t);

/* Creates a pretty printing data structure for breakable space and
   adds it in front of a list of pretty printing data structures. */
pretty_t pbreak(int, pretty_t);

/* Creates a pretty printing data structure that may use only some of
   the breaks in a block when breaking a block across multiple lines
   and adds it in front of a list of pretty printing data structures.
   The indent is added to the current indent when this block is
   broken.  */
pretty_t pblock(int, pretty_t, pretty_t);

/* Creates a pretty printing data structure that must use all of the
   breaks in a block when breaking a block across multiple lines and
   adds it in front of a list of pretty printing data structures.  The
   indent is added to the current indent when this block is broken.  */
pretty_t pgroup(int, pretty_t, pretty_t);

/* Write a pretty printing data structure thereby pretty printing an
   object.  This function also deallocates all pretty printing data
   structures allocated since the last call to pprint_init.  It
   returns -1 when given a flawed pretty data printing structure, or
   zero on success. */
int pprint(FILE *, pretty_t, int);

#ifdef __cplusplus
}
#endif

#endif
