dnl gssapi.m4 -- Find appropriate GSSAPI libraries.
dnl gssapi.m4,v 1.4 2004/06/14 01:20:55 eagle Exp
dnl
dnl Defines the macro SIDENT_LIB_GSSAPI, which probes for Kerberos v5 GSSAPI
dnl libraries from both MIT Kerberos and Heimdal.  Also tries to find the
dnl appropriate Kerberos v4 compatibility libraries at the same time and
dnl defines the output variables KRB_CPPFLAGS, KRB_LDFLAGS, and KRB_LIBS to
dnl the appropriate preprocessor and linker flags.

AC_DEFUN([SIDENT_LIB_GSSAPI],
[KRB_CPPFLAGS=
KRB_LDFLAGS=
AC_ARG_WITH([kerberos],
    AC_HELP_STRING([--with-kerberos=DIR],
        [Path to Kerberos headers and libraries]),
    [if test x"$withval" != xno ; then
         kerberos=$withval
         KRB_CPPFLAGS="-I$kerberos/include"
         KRB_LDFLAGS="-L$kerberos/lib"
     fi])
KRB_LDFLAGS_save=$LDFLAGS
LDFLAGS="$LDFLAGS $KRB_LDFLAGS"
AC_CHECK_LIB([gssapi], [gss_import_name],
    [KRB_LIBS="-lgssapi -lkrb -lkrb5 -lasn1 -lroken -lcrypto -lcom_err"],
    [AC_CHECK_LIB([gssapi_krb5], [gss_import_name],
        [KRB_LIBS="-lgssapi_krb5 -lkrb4 -ldes425 -lkrb5 -lk5crypto -lcom_err"],
        [AC_MSG_ERROR([no suitable Kerberos GSSAPI libraries found])],
        [-lkrb4 -ldes425 -lkrb5 -lk5crypto -lcom_err])],
    [-lkrb -lkrb5 -lasn1 -lroken -lcrypto -lcom_err])
LDFLAGS=$KRB_LDFLAGS_save
AC_SUBST(KRB_LDFLAGS)
AC_SUBST(KRB_LIBS)
AC_SUBST(KRB_CPPFLAGS)])
