/* $Id: mbuf.h,v 1.4 2003/05/30 00:42:40 cgd Exp $ */

/*
 * Copyright 2001, 2003
 * Broadcom Corporation. All rights reserved.
 *
 * This software is furnished under license and may be used and copied only
 * in accordance with the following terms and conditions.  Subject to these
 * conditions, you may download, copy, install, use, modify and distribute
 * modified or unmodified copies of this software in source and/or binary
 * form. No title or ownership is transferred hereby.
 *
 * 1) Any source code used, modified or distributed must reproduce and
 *    retain this copyright notice and list of conditions as they appear in
 *    the source file.
 *
 * 2) No right is granted to use any trade name, trademark, or logo of
 *    Broadcom Corporation.  The "Broadcom Corporation" name may not be
 *    used to endorse or promote products derived from this software
 *    without the prior written permission of Broadcom Corporation.
 *
 * 3) THIS SOFTWARE IS PROVIDED "AS-IS" AND ANY EXPRESS OR IMPLIED
 *    WARRANTIES, INCLUDING BUT NOT LIMITED TO, ANY IMPLIED WARRANTIES OF
 *    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR
 *    NON-INFRINGEMENT ARE DISCLAIMED. IN NO EVENT SHALL BROADCOM BE LIABLE
 *    FOR ANY DAMAGES WHATSOEVER, AND IN PARTICULAR, BROADCOM SHALL NOT BE
 *    LIABLE FOR DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *    CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 *    SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 *    BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *    WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 *    OR OTHERWISE), EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _MBUF_H
#define _MBUF_H

#include "port.h"

/* 
 * (Rather threadbare) implementation of an mbuf
 * structure for building and taking apart packets.  
 */

#define MBUF_BUFSIZE 4096


typedef struct {
	unsigned char  buf[MBUF_BUFSIZE];
	unsigned int   size;
	unsigned char *front_ptr;
	unsigned char *end_ptr;
} mbuf_t;

/* Return values */
enum {
	MBUF_SUCCESS,
	MBUF_OUT_OF_ROOM,
};


/*
 * For initializing new mbufs and ones that have just recieved data.
 * If length is 0, set up the mbuf to an empty packet with room
 * both in the header and tail directions.  If length is nonzero,
 * assume we've recieved a packet into the start of the
 * buffer; update size and pointers accordingly
 */
void mbuf_init(mbuf_t *mbuf, int length);

/* 
 * Add bytes bytes from ptr into the buffer at the head or tail.  Return 
 * MBUF_SUCCESS or MBUF_OUT_OF_ROOM
 */
int mbuf_prepend(mbuf_t *mbuf, void *ptr, unsigned int bytes);
int mbuf_append(mbuf_t *mbuf, void *ptr, unsigned int bytes);

/* 
 * Add bytes bytes of uninitialized space into the buffer at the head or tail.  Return 
 * MBUF_SUCCESS or MBUF_OUT_OF_ROOM
 */
int mbuf_prepend_space(mbuf_t *mbuf, unsigned int bytes);
int mbuf_append_space(mbuf_t *mbuf, unsigned int bytes);

/* 
 * Remove bytes bytes from the head and tail, respectively
 */
void mbuf_trim_head(mbuf_t *mbuf, unsigned int bytes);
void mbuf_trim_tail(mbuf_t *mbuf, unsigned int bytes);

/*
 * Check that the range ptr:ptr+bytes all exists in
 * valid space within the mbuf.
 */
int mbuf_range_ok(mbuf_t *mbuf, void *ptr, unsigned int bytes);

#endif
