/***************************************************************************
                          mainwindow.h  -  description
                             -------------------
    begin                : Sat Dec 1 2001
    copyright            : (C) 2001 by Richard Groult
    email                : rgroult@jalix.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU      *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software           *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307   *
 *   USA.                                                                  *
 *                                                                         *
 *   For license exceptions see LICENSE.EXC file, attached with the source *
 *   code.                                                                 *
 *                                                                         *
 ***************************************************************************/

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Local 
#include "showimg_export.h"
#include "history_action.h"

// KDE 
#include <kdockwindow.h>
#include <kbookmarkmanager.h>
#include <kdockwidget.h>
#include <kio/job.h>

class Directory;
class DirectoryView;
class ImageListView;
class DirectoryView;
class ImageViewer;
class HistoryAction;
class ListItem;
class ImageSimilarityData;
class RenameSeries;
class ImageMetaInfo;
class CDArchive;
class FormatConversion;
#ifdef HAVE_KIPI
class KIPIPluginManager;
#endif /*HAVE_KIPI*/

class QKeyEvent;
class QFile;
class QSize;
class QDate;
class QDateTime;
class QStringList;
class QString;
class QCloseEvent;
class QImage;
class QListViewItem;
class QProgressBar;

class KDockMainWindow;
class KBookmarkOwner;
class KProcess;
class KDockWidget;
class KAction;
class KToggleAction;
class KRadioAction;
class KAccel;
class KActionMenu;
class KBookmarkMenu;
class KScanDialog;
class KProgress;
class KActionCollection;
class KURLCompletion;
class KHistoryCombo;
class KProgressDialog;
class KSqueezedTextLabel;

class SHOWIMGCORE_EXPORT MainWindow:public KDockMainWindow, public KBookmarkOwner
{
	Q_OBJECT
public:
	MainWindow (const QString& name="MainWindow");
	MainWindow (const QString& pic, const QString&);

	~MainWindow();

	/**
		@return true if the 2 files are the sames
	*/
	bool equals(QFile*, QFile*);

	/**
		launch the exact comparison
	*/	
	void compareFast();
	
	/**
		launch the approximative comparison
	*/
	void compareAlmost();

	DirectoryView* getDirectoryView();
	ListItem* findDir(QString);
	void nextDir (ListItem *r);

	/**
		open a directory given its fullname
	*/
	bool openDir (const QString& dir, bool updateHistory_=TRUE);

	/**
		diplay the txt in the status bar
	*/
	void setMessage (const QString& txt);
	
	/**
		set the number of item in the file view in the statusbar
	*/
	void setNbrItems (int nbr);
	
	/**
		set the zoom of displayed image in the statusbar
	*/	
	void setZoom (float zoom);
	
	/**
		set the Imagename of displayed image in the statusbar
	*/	
	void setImagename (const QString& name);
	
	/**
		set the Imagetype of displayed image in the statusbar
	*/
	void setImagetype (const QString& type);

	/**
		set the Imagetype of displayed image in the statusbar
	*/
	void setImageIndex (int index);
	
	/**
		set the Dimension of displayed image in the statusbar
	*/	
	void setDim (const QSize& size, float dpi=0);
	
	/**
		set the Size  of displayed image in the statusbar
	*/	
	void setSize (int size);
	
	/**
		set the Date  of displayed image in the statusbar
	*/	
	void setDate (QDateTime *date);
	void setDate (const QString& date);
	
	/**
	*/
	void setActionsEnabled(bool enable);  
	
	/**
		set the imageViewer to an empty image
	*/
	void setEmptyImage();

	/**
		@return true if icons preview is enabled
	*/
	bool preview();	

	//
	/**
	 * This function is called if the user selects a bookmark.  It will
	 * open up the bookmark in a default fashion unless you override it.
	 */
	virtual void openBookmarkURL(const QString& _url);

	/**
	 * This function is called whenever the user wants to add the
	 * current page to the bookmarks list.  The title will become the
	 * "name" of the bookmark.  You must overload this function if you
	 * wish to give your users the ability to add bookmarks.
	 *
	 * @return the title of the current page.
	 */
	virtual QString currentTitle() const;

	 /**
	 * This function is called whenever the user wants to add the
	 * current page to the bookmarks list.  The URL will become the URL
	 * of the bookmark.  You must overload this function if you wish to
	 * give your users the ability to add bookmarks.
	 *
	 * @return the URL of the current page.
	 */
	virtual QString currentURL() const;

	/**
	* add the url in the groupText group of the bookmark
	*/
	void addToBookmark(const QString& groupText, const QString& url);

	//
	/**
		@return true if in fullscreen mode
	*/
	bool fullScreen();
	
	/**
		copy uris to the specified directory
	*/
	void copyFilesTo(const QStringList& uris, const QString& dest);
	
	/**
		move uris to the specified directory
	*/
	void moveFilesTo(const QStringList& uris, const QString& dest);

	void startWatchDir();
	void stopWatchDir();
	
	QString getcdromPath();
	
	void readConfig(KConfig *config);
	void writeConfig(KConfig *config);
	
	KProgress *progress;
	int total;
	int done;
	
	ImageViewer *iv;
	ImageListView *imageList;
	DirectoryView *dirView;
	ImageMetaInfo *imageMetaInfo;

#ifdef HAVE_KIPI
	 KIPIPluginManager* pluginManager();
#endif /*HAVE_KIPI*/


public slots:
	void clearCache();
	void clearCacheRec();
	void updateCache();

	void setHasImageSelected(bool selected);

	void slotFullScreen (); //switch to full screen and windows mode
	void slotSlideShow ();  //launch the slide show
	void slotPreview ();	  //show/hide thes thumbertails
	void slotRefresh (bool forceRefresh=false);	 //refresh the image list
	void slotRefresh (const QString& dir);	//refresh a specifique dir
	
	void slotCompareFast (){compareFast();}; //compare the pictures loaded
	void slotCompareAlmost (){compareAlmost();}; //compare the pictures loaded

	void convert();

	void slotNewWindow();
	void slotUndo();
	void slotRedo();

	void slotOpenLocation();
	void slotSaveImage();

	void slotTODO ();
	void slotcopy ();
	void slotcopyPixmap ();
	void slotcut ();
	void slotpaste ();
	void slotStop();

	void configureKey();
	void configureToolbars();
	void configureShowImg();
	void slotShowTips();

	void slotForward();
	void slotBack();
	void goHome();
	void goUp();

	void slotAddImage (int number=1);
	void slotRemoveImage();
	void slotPreviewDone (int number=1);
	void slotReset (bool init=true);
	void slotDone ();
	void slotRemoveImage (int val);

	void slotDirChange (const QString& path);
	void slotDirChange_created(const QString& path);
	void slotDirChange_deleted(const QString& path);
	
	void slotEditFileType();
	void renameSeries();

	void slotArrangement();
	void slotTxtPos();
	
	void slotIconSize(bool refresh=true);

	void changeDirectory(QString);
	void changeDirectory();

	void backMenuActivated(int);
	void forwardMenuActivated(int);
	void slotForwardAboutToShow();
	void slotBackAboutToShow();

	//void quit();
	bool queryClose();
	bool closeAppl();

	void toolsRotateLeft();
	void toolsRotateRight();
	
	void slotScanImage();
	void slotScanned( const QImage&, int );

	void slotDisplayNBImg();

	/**
		set the zoom of displayed image 
	*/	
	void setZoom ( const QString&);


private slots:
	void slotEndConvert(KProcess *);
	void escapePressed();
	void spacePressed();
	void updateWindowActions();
	void deleteTempDirectoriesDone( KIO::Job *job );
	
protected:
	KActionCollection *m_actions;
	void setupActions();
	void setupStatusBar();

	bool inFullScreen;
	KProgressDialog *pdCache;

	void init ();

	void closeEvent( QCloseEvent* );

	void clearCacheRec(const QString& fromDir);
	KURL::List updateCache(const QString &fromDir);

	QString getFileName(QString *fullName);
	QString getFileExt(QString *fullName);
	QString getFullName(QString *fullName);
	QString getFullPath(QString *fullName);  

	inline char getRed(QImage *im, int x, int y);
	inline char getGreen(QImage *im, int x, int y);
	inline char getBlue(QImage *im, int x, int y);

	ImageSimilarityData* image_sim_fill_data(const QString& filename);
	float image_sim_compare(ImageSimilarityData *a, ImageSimilarityData *b);
	float image_sim_compare_fast(ImageSimilarityData *a, ImageSimilarityData *b, float min);

	void updateHistory();
	void go( int steps );
	
	QString currentDir() const;
	void setCurrentDir(const QString& dir);

	QLabel *label;

	QPopupMenu *file;
	QPopupMenu *options;

	KDockWidget *dockIV;
	KDockWidget *dockDir;
	KDockWidget *dockIL;
	KDockWidget *dockIMI;

	Directory *root;
	CDArchive *cdArchiveRoot;
	
	QSize oldSize;
	QPoint oldPos;

	QTimer *timer;

	KToolBar *mainToolbar, *pathToolbar;
#ifndef SHOWIMG_NO_SCAN_IMAGE
	KScanDialog *m_scanDialog;
#endif
	RenameSeries *m_renameS;


private:

	KSqueezedTextLabel *SB_NAME_Label, *SB_DATE_Label;

	KConfig *config;
	
	FormatConversion *formatConver;
	
	QColor bgColor;
	bool checkDelete, checkShred, checkTrash;
	int grayscale, slideshowTime, slideshowType, openDirType;
	bool storeth, showFrame;
	bool smooth;
	QString openDirname;
	bool showSP, startFS;
	bool showToolbar, showStatusbar;

	QString cdromPath, convertPath, jpegtranPath;
	
	bool hasimageselected;
	QString currentDir_;
	QString lastDestDir;
	QLabel *lnbrItems, *lZoom, *lImagename, *lImagetype, *lDim, *lSize, *lDate;

	int fit; //index of 'fit' to screen menu
	int ss;  //index of 'smooth' menu
	bool inInterface;

	int nbrItems; //number of item
	int imageIndex; //current item index

	void createActions(); 
	void createHideShowAction(KDockWidget* dock) ;
	void createAccels();
	void createMenus();
	void createToolbar();
	void createStatusbar();
	void createMainView();
	void setLayout(int layout);
	void deleteTempDirectories();

	bool deleteTempDirectoriesDone_;
	
	KActionCollection *actionCollect;

	KAction *aCut, *aCopy, *aPaste, *aDelete, *aCopyPixmap,
	      *aNewWindow,
	      *aQuickPrint,
	      *aOpenLocation, *aSaveImage,
	      *aQuit,*aClose,
	      *aUndo,*aRedo,
	      *aRename,*aTrash,*aShred,
	      *aEditType,*aFileProperties,*aImageProperties,
	      *aImageInfo, *aDirInfo,
	      *aSelect,*aUnselect,*aUnselectAll,*aInvertSelection,
	      *aPrevious,*aNext,*aFirst,*aLast,
	      *aPreviousDir,*aNextDir,
	      *aConfigureKey,*aConfigureToolbars,*aConfigureShowImg,
	      *aRenameSeries,
	      *aCompareFast,*aCompareAlmost,*aCovert,
	      *aReloadDir,*aStop,
	      *aOpenWithGimp, *aOpenWithKhexedit, *aOpenWith,
	      *aWallpaper_CENTER,*aWallpaper_MOSAIC,*aWallpaper_CENTER_MOSAIC,*aWallpaper_CENTER_MAX,*aWallpaper_ADAPT,*aWallpaper_LOGO,

	      *aDirNewFolder, *aDirProperties,
	      *aDirNewAlbum,
#ifndef SHOWIMG_NO_CDARCHIVE
	      *aDirNewCDArchive,
#endif
	      *aDirCut, *aDirCopy, *aDirPaste, *aDirMove, *aDirPasteFiles, *aDirRecOpen,
	      *aDirRename, *aDirTrash, *aDirDelete,
	      *aDirBookmark,
	      *aFilesMoveTo, *aFilesCopyTo,
	
	      *aScrollXR, *aScrollXL, *aScrollYB, *aScrollYT,
	      
	      *aToolsRotateLeft, *aToolsRotateRight,

	      *aGoHome, *aGoUp, *aGo,

	      *aClearCache, *aClearCacheRec, *aUpdateCache,
	      
#ifndef SHOWIMG_NO_SCAN_IMAGE
	      *aScan,
#endif
	      *aTime,
	      
	      *aDisplayExifInformation;

	HistoryAction *aBack, *aForward;
	HistoryEntryList m_lstHistory;
	KHistoryCombo *m_URLHistory;
	KURLCompletion *m_URLHistoryCompletion;
	
	KComboBox *m_zoomCombo;

	KToggleAction *aSlideshow,
	      *aPreview,
	      *aFullScreen;

	KRadioAction
	      *aIconSmall, *aIconMed, *aIconBig,
	      *aArrangementLR, *aArrangementTB,
	      *aArrangementB, *aArrangementR,
	      *aSortBySize,*aSortByDirName,*aSortByType,*aSortByName, *aSortByDate;

	KAccel* mAccel;
	KActionMenu* abookmarkmenu;

	KBookmarkMenu *mBookMenu;

	QPtrList<KAction> m_windowListActions;
	
#ifdef HAVE_KIPI
	 KIPIPluginManager *pluginManager_;
#endif /*HAVE_KIPI*/

};

#endif
