#ifndef _CLASSDEF_HPP_
#define _CLASSDEF_HPP_

#include <queue>
#include <list>
#include "packet.hpp"
#include "sched.hpp"
#include "classifier.hpp"

class classdef {
	int id;
	char *name;
	int bandwidth;

	int n_queues;
	std::queue<generic_packet*> *v_queues;
	int q_bytes, q_pckts;
	int q_maxbytes, q_maxpckts;

	public:
		int n_classifiers;
		int divert_reinjection;
		packet_classifier **v_classifiers;

		scheduler my_sched;
		list<char*> lenders;

		classdef();
		~classdef();
		int queue_init();
		int check_packet(generic_packet *pckt, int *prio);
		int add_lender(char *id);
		int add_packet_classifier(packet_classifier *pc);
		int set_name(const char *newname, int len);
		int get_id();
		int queue_empty();
		int queue_packet(generic_packet *packet, int prio);
		generic_packet *dequeue_packet();
		void get_queue_limits(int *b, int *p);
		void set_queue_limits(int b, int p);
		void set_id(int newid);
		void set_bw(const int &bw);
		int get_bw();
		char *get_name();
};

#endif
