/***************************************************************************
                          player_interface.h  -  description
                             -------------------
    begin                : Sun Sep 16 2001
    copyright            : (C) 2001 by Juan Sebastian Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PLAYER_INTERFACE_H
#define PLAYER_INTERFACE_H

#include <vector>
#include "effect_table.h"
#include "song.h"
#include "player_data.h"
#include "event_queue.h"

/**
  *@author Juan Sebastian Linietsky
  */

class Player_Interface {

	Song *song;
        Player_Data *data;
	Event_Queue *queue;

	struct Effect_Column_Data {

		Effect_Table *table;
		Uint8 current_command;
		Uint8 current_parameter;
		Uint8 last_note;

                void reset() {

			current_command=Note::CLEAR;
			current_parameter=0;
			last_note=Note::CLEAR;
		}

		Effect_Column_Data() {

			reset();
		}		
	};
			
	typedef vector<Effect_Column_Data> Effect_Track;
	vector<Effect_Track> fx;


        void execute_effect(Effect *p_effect);
        void parse_effect(int p_track,int p_column);
        void queue_note(int p_track,int p_column,Note p_note);


public:

	void parse_note(int p_track,int p_pattern,int p_column,int p_row);
	void parse_row(int p_pattern,int p_row);
	

	void set_song(Song *p_song);
	void set_data(Player_Data *p_data);
	void set_queue(Event_Queue *p_queue);

	void reset();

	Player_Interface();
	~Player_Interface();
};

#endif
