/* @(#)dsklabel.h	1.3 01/04/24 Copyright 1997 J. Schilling */
/*
 * 	Definitions for disk labels
 *
 *	Copyright (c) 1997 J. Schilling
 */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef	_DSKLABEL_H
#define	_DSKLABEL_H

#if	(defined(HAVE_SYS_DKIO_H) && defined(HAVE_SYS_DKLABEL_H)) || \
	(defined(HAVE_SUN_DKIO_H) && defined(HAVE_SUN_DKLABEL_H))
#define	HAVE_DKIO
#endif

#ifdef	HAVE_DKIO

#	ifdef	HAVE_SYS_DKIO_H
#		include <sys/dkio.h>
#	endif
#	ifdef	HAVE_SYS_DKLABEL_H
#		include <sys/dklabel.h>
#	endif
#	ifdef	HAVE_SUN_DKIO_H
#		include <sun/dkio.h>
#	endif
#	ifdef	HAVE_SUN_DKLABEL_H
#		include <sun/dklabel.h>
#	endif

#else
#	include "sun_dkio.h"
#	include "sun_dklabel.h"
#	undef	DKIOCGCONF
#	define	DKIOCGCONF	12345678
#	undef	DKIOCGAPART
#	define	DKIOCGAPART	12345679
#	undef	DKIOCSAPART
#	define	DKIOCSAPART	12345670
#	undef	DKIOCSGEOM
#	define	DKIOCSGEOM	12345671
#	undef	DKIOCINFO
#	define	DKIOCINFO	12345672
#endif

#endif	/* _DSKLABEL_H */
