#ifndef MAPFILE_H
#define MAPFILE_H

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif


#ifdef HAVE_MMAP
#  include <cstdlib>
#  include <sys/types.h>
#  include <fcntl.h>
#  include <sys/mman.h>
#  else
#  ifdef _WIN32
#  else
#  endif
#endif


class TMapFile{
public:
  TMapFile(void) : data_buffer(NULL){}
  ~TMapFile(){close();}
  bool open(const char *filename, size_t _file_size);
  bool open(const char *filename);
  void close(void);
  inline const char *begin(void){return data_buffer;}
  inline const char *end(void){return data_buffer+file_size;}
private:
  char *data_buffer;
  size_t file_size;
#ifdef HAVE_MMAP
  int mmap_fd;
#else
#  ifdef _WIN32
  HANDLE hFile;
  HANDLE hFileMap;
#  else
#  endif
#endif
};

#endif/*mapfile.h*/
