
#ifndef RESOLUTION_FUNC_HH
#define RESOLUTION_FUNC_HH

// Copyright (c) 1995-1999 The University of Cincinnati.
// All rights reserved. 

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Dale E. Martin          dmartin@ece.uc.edu

//---------------------------------------------------------------------------

template <class type> class set;
class IIR_TypeDefinition;
class IIR_Name;
class IIR_IndexedName;
class IIR_DeclarationList;
class IIR_Signature;
class IIR_Declaration;
class IIR_TypeDeclaration;
class IIR_ProcedureDeclaration;
class IIR_ScalarTypeDefinition;
class IIR_AssociationList;
class IIR_InterfaceList;
class IIR_SubprogramDeclaration;
class symbol_table;
class IIR_EnumerationLiteral;
class IIR_Aggregate;
class IIR_Label;
class IIR_TextLiteral;
class IIR_Identifier;

#include "savant.hh"
#include "IRBasicDataTypes.hh"

template <class type> class dl_list;

/** This method checks to see if a set has only one member.  If it does,
    then it returns the single declaration.  If it has zero members, it
    complains that symbol name_for_error is undeclared (if it is provided.)
    If there is more than one declaration in this set, it returns a NULL
    pointer. (and doesn't complain, as more context is probably need to
    figure it out which one it needs.) */
IIR_Declaration *
resolve_if_one( set<IIR_Declaration> *set_to_resolve,
		IIR_Name *name_for_error = NULL );

/** This method takes two sets and intersects them.  It returns the number of
    common elements between them.  If the optional IIR * is passed in, the
    line number information is used to generate an error message (either
    ambiguous or incompatible) */
int 
check_lval_rval_sets( set<IIR_TypeDefinition> *lval_set, 
		      set<IIR_TypeDefinition> *rval_set,
		      IIR *error_info = NULL);


/** This function takes a set of subprogram declarations, (optionally) a
    set of possible return types for those declarations, and a list of
    arguments.  It modifies the set of subprogram declarations in that it
    REMOVES any declarations that are not valid based on return type and
    arguments. */
void 
resolve_subprogram_decls(set<IIR_Declaration> *possible_subprogram_decls,
			 IIR_AssociationList *arguments,
			 const set<IIR_TypeDefinition> *possible_return_types = NULL);

/** This method is as described above.  However, it takes it's list of
    arguments with the rvals "pre-computed"... */
void 
resolve_subprogram_decls( set<IIR_Declaration> *possible_subprogram_decls,
			  dl_list<IIR_TypeDefinition> *parameter_rval_list,
			  set<IIR_TypeDefinition> *possible_return_types );

void 
resolve_subprogram_decls( set<IIR_Declaration> *possible_subprogram_decls,
			  IIR_Signature *signature );


/** This method takes a set of declarations, and produce the set of r_vals
    for it...  The memory returned needs to be deleted! */
set<IIR_TypeDefinition> *
decl_set_to_typedef_set( set<IIR_Declaration> *decl_set,
			 IIR_Boolean (IIR::*constraint_function)() = 0 );

/** This method takes a set of declarations, and a set of type definitions,
    and attempts to figure out which definitions in the lval set are
    compatible across an assignment with the type definitions on the right
    hand side.  Both sets are modified - they are reduced to only the
    compatible assignments. */
void 
reconcile_sets( set<IIR_Declaration> *decls, 
		set<IIR_TypeDefinition> *rval_set );


void 
reconcile_sets( set<IIR_TypeDefinition> *lval_set, 
		set<IIR_TypeDefinition> *rval_set );

/** This function takes the set given, and reduces it to the "deepest"
    scoped item that's in it. */
void 
reduce_scope( set<IIR_Declaration> *declaration_set );

/** This method is used by the parser.  It looks at an aggregate it has
built, and decides whether it should remain an aggregate, or if it should
convert it to a more simple expression.  ( x ) doesn't need to be an
aggregate.  ( x => y ) does.  ( others => '1' ) does too. */
IIR *reduce_aggregate( IIR_Aggregate *aggregate );

IIR *reduce_association_list( IIR_AssociationList * );

/** This method is used by the parser to "unroll" choices in an aggregate
    initialization ( 0 | 1 | 2 => '1' ) becomes ( 0 => '1', 1 => '1', 2 =>
    '1' ); It also properly builds IIR_OthersInitialization if
    necessary. */
void 
process_aggregate_with_choices( IIR *formal_part, IIR *actual_part, IIR_Aggregate *retval );

/** This function checks a declaration's identifier against the ending name
    found at the end of a declaration, and reports an error if they don't
    match.  The last argument is the string literal of the type we're
    looking at.  So, we can generate the error message "foo doesn't match
    entity name bar".  We'd pass in "entity". */
void 
check_name( IIR_TextLiteral *, IIR_Name *, char *declaration_type );

void 
check_name( IIR_TextLiteral *, IIR_TextLiteral *, char *declaration_type );

void 
check_name( IIR_Label *, IIR_Name *, char *declaration_type );


/** This method builds a default port map or generic map for this
    configurationSpecification or a componentInstantiationStatement, or a
    component configuration.  Since it is used by several different
    classes, it really belongs in neither.  So, it's just a normal
    function.*/
void build_default_map( IIR_InterfaceList   &formal_list, 
			IIR_InterfaceList   &actual_list, 
			IIR_AssociationList &default_map);


IIR_TypeDeclaration *
find_incomplete_type_declaration( IIR_Identifier *type_name );

#endif

