#ifndef IIRSCRAM_SCALAR_TYPE_DEFINITION_HH
#define IIRSCRAM_SCALAR_TYPE_DEFINITION_HH
// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------

#include "IIRBase_ScalarTypeDefinition.hh"

class IIRScram_ScalarTypeDefinition : public IIRBase_ScalarTypeDefinition {

public:
  virtual void _publish_vhdl(ostream &);
  virtual void _publish_vhdl_decl(ostream &);
  virtual void _publish_vhdl_constraint(ostream &);
  virtual void _publish_vhdl_range(ostream &);
  virtual void _publish_vhdl_index(ostream &);
  virtual void _publish_cc_left( published_file &_cc_out );
  virtual void _publish_cc_right( published_file &_cc_out );
  virtual void _publish_cc_universal_left( published_file &_cc_out );
  virtual void _publish_cc_universal_right( published_file &_cc_out );
  virtual void _publish_cc_range( published_file &_cc_out );
  IIR_Boolean _is_ascending_range();
  IIR_Boolean _is_scalar_type(){ return TRUE; }
  IIR_Boolean _is_iir_scalar_type_definition(){ return TRUE; }

  IIR_Boolean _is_bit_type();
  IIR_Boolean _is_boolean_type();
  IIR* _get_direction();
  IIR* _get_base_type_left();
  IIR* _get_base_type_direction();
  IIR* _get_base_type_right();
  IIR_TypeDefinition* _get_base_type();

  virtual void _publish_cc_init_implicit_signal( published_file &_cc_out );
  virtual void _publish_cc_init_explicit_signal( published_file &_cc_out );
  virtual void _publish_cc_init_signal( published_file &_cc_out );
  virtual void _publish_cc_composite_init( published_file &_cc_out );
  virtual void _publish_cc_array_info( published_file &_cc_out );

  virtual void _publish_cc_constructor_args( published_file &_cc_out );

  void _publish_cc_signal_value_left( published_file &_cc_out );
  virtual void _publish_cc_init_val( published_file &_cc_out );

  virtual void _publish_cc_decl_constructors( published_file &_cc_out );
  virtual void _publish_cc_type_constructors( published_file &_cc_out );
  virtual void _publish_cc_subtype_constructors( published_file &_cc_out );
  virtual void _publish_cc_decl_destructors( published_file &_cc_out );
  
  virtual const string _get_cc_type_name();

  virtual void _publish_cc_headers( published_file &_cc_out );

  /** The following function, publishes the range checking in the 
      generated code. */
  virtual void _publish_cc_range_check( published_file &_cc_out );

  //The following function publishes the declarations 
  //of the type attribute functions in the generated .hh file
  virtual void _publish_cc_decl_type_attributes( published_file &_cc_out );

  // The following function publishes the body 
  //of the Type attribute functions in the generated .cc file
  virtual void _publish_cc_define_type_attributes( published_file &_cc_out );

  // The following function publishes the body 
  //of the individual Type attribute functions in the generated .cc file
  virtual void  _publish_cc_init_last_event( published_file &_cc_out );

  virtual void  _publish_cc_class_last_event( published_file &_cc_out );
  virtual void  _publish_cc_class_event( published_file &_cc_out );

  virtual void  _publish_cc_necessary_decl_in_state( published_file &_cc_out );
  
  void _publish_cc_constructor_args_type_info( published_file &_cc_out,
					       IIR *initializer );

  ostream &_print( ostream & );

  void _add_decl_into_cgen_symbol_table();

  IIR_Boolean _is_resolved();

  virtual IIR_TypeDefinition *
  _construct_new_subtype( IIR_Name *resolution_function,
			  IIR_ScalarTypeDefinition *new_constraint );
  
  /** This method takes all of the data passed in, and attempts to
     generate valid IIR for it.  */
  static void _init_scalar_type( IIR_RangeTypeDefinition *init_info,
				 IIR_ScalarTypeDefinition *base_type,
				 IIR_ScalarTypeDefinition *subtype,
				 IIR_TypeDeclaration *type_decl );

  virtual void set_resolution_function( IIR_FunctionDeclaration * );

  virtual void _clone( IIR * );

  /** This method takes the range passed in, and determines the discrete type that applies.
      The type must be determinable WITHOUT context.  This method is appropriate for 
      determining the type of the range given in:
      1) Index constraints of arrays.
      2) The discrete range of iteration schemes in for loops.
      3) The discrete range of iteration schemes in generate statements.
      See pg 42, line 354 of the 93 LRM. */
  static IIR_ScalarTypeDefinition *_determine_discrete_type( IIR_RangeTypeDefinition * );

  IIR_Boolean _is_locally_static();
  IIR_Boolean _is_globally_static();

protected:
  IIRScram_ScalarTypeDefinition() {}
  virtual ~IIRScram_ScalarTypeDefinition() = 0;

  void _build_implicit_operators( set<IIR_Declaration> * );
    
private:
};
#endif
