
// Copyright (c) 2002-2003 The University of Cincinnati.
// All rights reserved.
 
// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR
// NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR DISTRIBUTING
// THIS SOFTWARE OR ITS DERIVATIVES.
 
// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S., and
// the terms of this license.
 
// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2, June
// 1991. A copy of this license agreement can be found in the file "LGPL",
// distributed with this archive.
 
// Authors: Sivakumar Gowrisankar             gowriss@ececs.uc.edu
//          Vinod Chamarty                    chamarv@ececs.uc.edu
//          Vasudevan Shanmugasundaram
//          Kathiresan Nellayappan
 
//---------------------------------------------------------------------------

#include "IIRScram_ScalarNatureDefinition.hh"
#include "IIR_NatureDeclaration.hh"
#include "error_func.hh"
#include "IIR_TextLiteral.hh"
#include "published_file.hh"
#include "published_header_file.hh"
#include "published_cc_file.hh"
#include "sstream-wrap.hh"
#include "IIR_Declaration.hh"
#include <iostream>

using std::cerr;
using std::endl;

IIRScram_ScalarNatureDefinition::~IIRScram_ScalarNatureDefinition() {}

void
IIRScram_ScalarNatureDefinition::_publish_vhdl_decl(ostream &_vhdl_out) {
  get_across()->_publish_vhdl(_vhdl_out);
  _vhdl_out << " across " ;
  get_through()->_publish_vhdl(_vhdl_out);
  _vhdl_out << " through " ;
  get_reference_terminal()->_get_declarator()->_publish_vhdl(_vhdl_out);
  _vhdl_out << " reference " ;
}


const string
IIRScram_ScalarNatureDefinition::_get_cc_type_name(){
  ostringstream os;
  _get_declaration()->get_declarator()->_print_cc( os );
  return os.str();
}


void 
IIRScram_ScalarNatureDefinition::floating_point_type_check(IIR_TypeDefinition *check_type_def) {
    if (check_type_def->_is_floating_type() == FALSE) {
     cerr << "Error : Nature type mark must denote floating point types." << endl;
     abort();
    }		    
}

