
// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu
//	    Magnus Danielson	cfmd@swipnet.se

//---------------------------------------------------------------------------

#include "IIRScram.hh"
#include "IIRScram_QualifiedExpression.hh"
#include "IIR_ArrayTypeDefinition.hh"
#include "set.hh"
#include "savant.hh"
#include "published_file.hh"

IIRScram_QualifiedExpression::~IIRScram_QualifiedExpression(){}

void 
IIRScram_QualifiedExpression::_publish_vhdl(ostream &_vhdl_out) {
  ASSERT(get_subtype() != NULL);
  get_type_mark()->_publish_vhdl(_vhdl_out);
  _vhdl_out << "'" ;
  if ( get_expression()->_is_aggregate_expression() == FALSE ){ 
  _vhdl_out << " ( ";
  }
  get_expression()->_publish_vhdl(_vhdl_out);
  if ( get_expression()->_is_aggregate_expression() == FALSE ){
  _vhdl_out << " ) ";
  }
}


void
IIRScram_QualifiedExpression::_publish_cc_headers( published_file &_cc_out ) {
  SCRAM_CC_REF( _cc_out, "IIRScram_QualifiedExpression::_publish_cc_headers" );
  get_type_mark()->_publish_cc_include( _cc_out );
}

void
IIRScram_QualifiedExpression::_publish_cc_lvalue( published_file &_cc_out ){
  SCRAM_CC_REF( _cc_out, "IIRScram_QualifiedExpression::_publish_cc" );
  
  if(get_type_mark()->_is_scalar_type() == TRUE) {
    _cc_out << get_type_mark()->_get_cc_type_name();
    _cc_out << OS("(");
    _cc_out << "ObjectBase::VARIABLE," << NL();
    get_type_mark()->_publish_cc_universal_type( _cc_out );
    _cc_out << OS("::typeCast((");
    get_expression()->get_subtype()->_publish_cc_universal_type( _cc_out );
    _cc_out << " &)";
    get_expression()->_publish_cc_lvalue( _cc_out );
    _cc_out << CS(".readVal())");
    get_type_mark()->_publish_cc_object_type_info( _cc_out );
    _cc_out << CS(")");
  }
  else if(get_type_mark()->_is_array_type() == TRUE) {
    get_expression()->_publish_cc_lvalue( _cc_out );
  }
  else {
    get_expression()->_publish_cc_lvalue( _cc_out );
  }
}

void
IIRScram_QualifiedExpression::_add_decl_into_cgen_symbol_table(){
  get_expression()->_add_decl_into_cgen_symbol_table();
}

IIR_TypeDefinition*
IIRScram_QualifiedExpression::get_subtype(){
  return get_type_mark();
}

void 
IIRScram_QualifiedExpression::_get_list_of_input_signals( set<IIR> *list ){
  get_expression()->_get_list_of_input_signals(list);
}

void
IIRScram_QualifiedExpression::_build_sensitivity_list(IIR_DesignatorList* sensitivity_list) {
  get_expression()->_build_sensitivity_list(sensitivity_list);
}

void 
IIRScram_QualifiedExpression::_type_check( set<IIR_TypeDefinition> * ){
  // The parser originally built this as an IIR_UserAttribute...  Then it got
  // transformed into an IIRScram_QualifiedExpression.  When it got trasnformed,
  // an effort was made to make sure that the type and expression were compatible...

  // Whatever is "sitting above" us should complain if we're incompatible with what
  // we're being assigned to, so, we don't have to do anything here...

}

set<IIR_TypeDefinition> *
IIRScram_QualifiedExpression::_get_rval_set(IIR_Boolean (IIR::*)()){
  return new set<IIR_TypeDefinition>( get_type_mark() );
}

IIR * 
IIRScram_QualifiedExpression::_rval_to_decl( IIR_TypeDefinition *my_rval ){
  ASSERT( get_type_mark()->_is_resolved() == TRUE );
  ASSERT( my_rval->_is_compatible( get_type_mark() ) != NULL );
  
  if( get_type_mark() != NULL && get_expression() != NULL ){
    set_expression( get_expression()->_semantic_transform( get_type_mark() ) );
    get_expression()->_type_check( get_type_mark() );
    set_expression( get_expression()->_rval_to_decl( get_type_mark() ) );
  }

  return this;
}

ostream &
IIRScram_QualifiedExpression::_print( ostream &os ){
  os << *get_type_mark() << "'";
  if( get_expression()->get_kind() == IIR_AGGREGATE ){
    os << *get_expression();
  }
  else{
    os << "( ";
    os << *get_expression();
    os << " )";
  }

  return os;
}

IIR_Boolean 
IIRScram_QualifiedExpression::_is_resolved(){
  if( get_type_mark()->_is_resolved() == FALSE ||  get_expression()->_is_resolved() == FALSE ){
    return FALSE;
  }
  else{
    return TRUE;
  }
}

IIR_Boolean 
IIRScram_QualifiedExpression::_is_locally_static_primary(){
  ASSERT( get_expression() != NULL );
  ASSERT( get_expression()->_is_resolved() == TRUE );
  return get_expression()->_is_locally_static();
}

IIR_Boolean 
IIRScram_QualifiedExpression::_is_globally_static_primary(){
  ASSERT( get_expression() != NULL );
  ASSERT( get_expression()->_is_resolved() == TRUE );
  return get_expression()->_is_globally_static();
}

visitor_return_type *
IIRScram_QualifiedExpression::_accept_visitor(node_visitor *visitor, visitor_argument_type *arg) {
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_QualifiedExpression(this, arg);
}
