#ifndef IIRSCRAM_PROCEDURE_DECLARATION_HH
#define IIRSCRAM_PROCEDURE_DECLARATION_HH

// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------

#include "IIRBase_ProcedureDeclaration.hh"
#include "IIRScram_ProcedureReturnTypeDefinition.hh"

class IIR_List ;
class IIR_WaitStatement;
class IIRScram_ProcedureDeclaration : public IIRBase_ProcedureDeclaration {

public:
  /// Accept visitations \Ref{_accept_visitor}.
  visitor_return_type* _accept_visitor(node_visitor *, visitor_argument_type *);

  void _publish_vhdl_decl(ostream &);
  void _mangle_declarator();
  void _publish_cc_lvalue( published_file &_cc_out );
  void _publish_cc_decl( published_file &_cc_out );
  void _publish_cc_wait_init( published_file &_cc_out, dl_list<IIR_WaitStatement> *_wait_stmt_list );
  void _publish_cc_wait_data( published_file &_cc_out, dl_list<IIR_WaitStatement> *_wait_stmt_list );
  void _publish_cc_type_info( published_file &_cc_out );
  void _publish_cc_extern_type_info( published_file &_cc_out );

  declaration_type _get_type();

  IIR_TypeDefinition *get_subtype();

  void _get_signal_source_info( set<IIR> *siginfo );

  static IIR_TypeDefinition *_get_procedure_return_type();

  IIR_Boolean _is_iir_procedure_declaration(){ return TRUE; }

protected:
  IIRScram_ProcedureDeclaration() {}
  virtual ~IIRScram_ProcedureDeclaration() = 0;
    
private:
  /**
     Returns true if this name needs mangle, false otherwise.
   */
  bool _need_to_mangle();
  /**
     Adds parameters onto the mangled name.
  */
  void _publish_cc_add_parameters( ostream & );
};
#endif




