
#ifndef IIRSCRAM_NATURE_DEFINITION_HH
#define IIRSCRAM_NATURE_DEFINITION_HH

// Copyright (c) 2002-2003 The University of Cincinnati.
// All rights reserved.
 
// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 
// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.
  
// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.
 
// Authors: Sivakumar Gowrisankar             gowriss@ececs.uc.edu
//          Vinod Chamarty                    chamarv@ececs.uc.edu
//          Vasudevan Shanmugasundaram
 
//---------------------------------------------------------------------------

#include "IIRBase_NatureDefinition.hh"

class IIRScram_NatureDefinition : public IIRBase_NatureDefinition {

public:
  void _publish_vhdl(ostream&);
  const string _get_cc_type_name();
  IIR_Boolean _is_nature_definition() { return TRUE; }
  IIR_Boolean _is_array_type() { return FALSE; }
  IIR_TextLiteral *_get_declarator();
  virtual IIR_TerminalDeclaration *get_reference_terminal();
  virtual void _set_element_subtype( IIR_NatureDefinition * );
  virtual IIR_TypeDefinition *_get_element_subtype();
  void _set_resolution_function(IIR_FunctionDeclaration *);
  virtual IIR_TypeDefinition *_get_final_subtype();

protected:
  IIRScram_NatureDefinition() {}
  virtual ~IIRScram_NatureDefinition() = 0;

private:

};
#endif
