
#ifndef IIRSCRAM_DYADIC_OPERATOR_HH
#define IIRSCRAM_DYADIC_OPERATOR_HH

// Copyright (c) 1996-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Malolan Chetlur     
//          Umesh Kumar V. Rajasekaran
//          Krishnan Subramani  
//          Timothy J. McBrayer 

#include "IIRBase_DyadicOperator.hh"
class IIR_AboveAttribute;

class IIRScram_DyadicOperator : public IIRBase_DyadicOperator {
public:
  void _publish_vhdl(ostream &);
  
  void _publish_cc_lvalue( published_file &_cc_out );
  void _publish_cc_rvalue( published_file &_cc_out );

  void _publish_cc_headers( published_file &_cc_out );
  void _publish_cc_wait_data( published_file &_cc_out );

  //  virtual void _publish_cc_wait_data_short_circuit( published_file &_cc_out );
  void _publish_cc_ams_function(published_file &);
  void _publish_cc_ams_function_call_in_simult_stmt(published_file &);
  virtual void _publish_cc_ams_operator_name( published_file & );

  virtual IIR_Boolean _is_iir_dyadic_operator(){ return TRUE; }

//   /** This function returns TRUE if the operation is a short circuit
//       operation.  As per section 7.2 of LRM: The logical operations
//       "and", "or", "nand" and "nor" defined for types BIT and BOOLEAN
//       are all short-circuit operations; furthermore, these are the only
//       short-circuit operations.  */
//   virtual IIR_Boolean _is_short_circuit();

  void _get_list_of_input_signals( set<IIR> *list );
  IIR  *_transmute();
  void _build_sensitivity_list(IIR_DesignatorList* sensitivity_list);
  
  void _build_generic_parameter_set(set<IIR_Declaration> *);

  const string _get_function_name() const;

  IIR_Boolean _is_readable();
  IIR_Boolean _is_resolved();

  void _resolve_operands( IIR_TypeDefinition *left_type, IIR_TypeDefinition *right_type );

  void _resolve_operand( IIR *(IIRScram_DyadicOperator::*get_method)(), 
			 void (IIRScram_DyadicOperator::*set_method)( IIR *),
			 IIR_TypeDefinition *operand_type );

  virtual void _add_decl_into_cgen_symbol_table();

  virtual void _clone( IIR * );

  virtual bool _is_associative(IIR_Kind oper_kind){ (void)oper_kind; return TRUE;}
  virtual IIR_Boolean _is_left_associative(){ return TRUE; }
  virtual IIR_Boolean _is_logical_operator() { return FALSE ;}
  IIR_Boolean _is_static_expression();
  IIR_Boolean _is_operator();
  IIR_Boolean _is_locally_static_primary();

  IIR *_rval_to_decl( IIR_TypeDefinition *my_rval );

  virtual void _flush_stmt_index();
  void _set_stmt_node_index(IIR_Int32 *, bool, bool&);
  void _set_stmt_qty_index(IIR_Int32 *, set<IIR_Declaration> *);
  void _set_stmt_signal_index(IIR_Int32 *, set<IIR_Declaration> *);
  IIR_Boolean _contribution_quantity_found();
  void _build_contribution_quantity_list(dl_list<IIR_ContributionAttribute> *);
  IIR_Boolean _reference_quantity_found();
  void _build_reference_quantity_list(dl_list<IIR_ReferenceAttribute> *);
  IIR_Boolean _differential_quantity_found();
  void _build_differential_quantity_list(dl_list<IIR_DotAttribute> *);

protected:
  IIR_Int32 _get_num_args(){ return 2; }
  IIR_AssociationList *_build_argument_list();

  IIR_Boolean _is_above_attribute_found();
  void _build_above_attribute_set(set<IIR_AboveAttribute> *);

  IIRScram_DyadicOperator() {};
  virtual ~IIRScram_DyadicOperator() = 0;

  void _type_check_operands( );
  
protected:
  /**
     Does short circuit publishing for the operators passed in.  Expects _publish_cc_rvalue
     or _publish_cc_wait_data, in general.
  */
  void _publish_cc_short_circuit_positive( published_file &_cc_out,
					   void (IIR::*_publish_function)( published_file & ));


  void _publish_cc_short_circuit_negative( published_file &_cc_out,
					   void (IIR::*_publish_function)( published_file & ));
  /**
     Does publishing for _publish_cc_{r,l}value.  Publishes:
     left_operand.operator_name( right_operand ) 
     Publishing of left and right operand are handled by the method call
     passed in.
  */
  virtual void _publish_cc_xvalue( published_file &_cc_out,
				   void (IIR::*publish_function)( published_file & ) );

private:
  IIR_Int32 _stmt_node_index;

};
#endif
