#ifndef IIRSCRAM_DECLARATION_LIST_HH
#define IIRSCRAM_DECLARATION_LIST_HH
// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
#include "IIRBase_DeclarationList.hh"

class IIR_Name;
class IIR_StatementList;
class symbol_table;
class IIR_AttributeSpecification;

class IIRScram_DeclarationList : public IIRBase_DeclarationList {

public:

  /// Accept visitations \Ref{_accept_visitor}.
  visitor_return_type* _accept_visitor(node_visitor *, visitor_argument_type *);


  virtual void _publish_cc( published_file &_cc_out );
  void _publish_cc_decl( published_file &_cc_out );
  void _publish_cc_package_declarations( published_file &_cc_out );
  void _publish_cc_decl_subprograms_and_types( published_file &_cc_out );
  void _publish_cc_prototype( published_file &_cc_out );
  IIR_Boolean _publish_cc_type_info( published_file &_cc_out, IIR_Boolean = FALSE );
  void _publish_cc_extern_type_info( published_file &_cc_out );
  void _publish_cc_type_info_and_constant_declarations( published_file &_cc_out );
  IIR_Boolean  _publish_cc_type_info_and_constant_definitions( published_file &_cc_out, IIR_Boolean = FALSE );  
  void _publish_vhdl_decl(ostream&);
  void _publish_vhdl(ostream&);

  set<IIR_Declaration> *_find_declarations( IIR_Name * );
  set<IIR_Declaration> *_find_declarations( IIR_TextLiteral * );

  /** This method walks through the list of declarations and publishes
      initializations for constants declared here. This method is called
      from process statement only as of now. */
  void _publish_cc_constants( published_file &_cc_out );
  IIR_Boolean _publish_cc_constants_init( published_file &_cc_out, IIR_Boolean first = TRUE );
  void _publish_cc_global_constants_assignments( published_file &_cc_out );

  void _publish_cc_file_objects( published_file &_cc_out );
  void _publish_cc_file_objects_init( published_file &_cc_out );
  
  /** This method looks through the list, finds the configuration
      specifications, and does the appropriate type checking on them.  The
      statement list passed in is so that labels can be found if needed. */
  void _type_check_configuration_specifications( IIR_List &statement_list );

  /** This method looks through the list, finds the disconnection
      specifications, and does the appropriate type checking on them. */
  void _type_check_disconnection_specifications( );

  /** This method looks through the list, finds the attribute
      specifications, and does the appropriate type checking on them.  The
      statement list passed in is so that labels can be found if needed. */
  void _type_check_attribute_specifications( IIR_List &statement_list );

  /** This method assumes this list is a list of context items (use clauses
      and library clauses) and makes the appropriate stuff visible in the
      symbol table passed in. */
  void _make_visible_as_context_list( symbol_table * );

  /** This method applies the method passed in to each element, and builds
      a newly allocated list of the members that returned true. */
  IIR_DeclarationList *_build_constrained_list( IIR_Boolean (IIR::*constraint_function)() );

  IIR *_clone();

  /** Returns true if this list contains a foreign attribute specification,
      false otherwise. */
  bool _contains_foreign_attribute();
  
  /**
     Makes the declarative region of all of the elements in this list point
     to the new region passed in.
  */
  void _set_declarative_region( IIR * );

  /**
     Returns the set of foreign attribute specifications.  Must delete
     return memory.
  */
  set<IIR_AttributeSpecification> *_find_foreign_attributes();

protected:
  IIRScram_DeclarationList() {}
  virtual ~IIRScram_DeclarationList() = 0;
    
private:
};
#endif
