
// Copyright (c) 1996-2002 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Timothy J. McBrayer
//          Malolan Chetlur    
//	    Magnus Danielson	cfmd@swipnet.se

//---------------------------------------------------------------------------

#include "IIRScram.hh"
#include "IIRScram_CaseStatementAlternativeList.hh"
#include "IIR_CaseStatementAlternative.hh"
#include "savant.hh"

IIRScram_CaseStatementAlternativeList::~IIRScram_CaseStatementAlternativeList() {}

void 
IIRScram_CaseStatementAlternativeList::_publish_cc( published_file &_cc_out ) {
  IIR_CaseStatementAlternative *node;

  SCRAM_CC_REF( _cc_out, "IIRScram_CaseStatementAlternativeList::_publish_cc" );

  for (node = first(); node != NULL; node = successor(node)) {
    node->_publish_cc_lvalue( _cc_out );
  }
}

void
IIRScram_CaseStatementAlternativeList::_get_list_of_input_signals( set<IIR> *list ){
  IIR_CaseStatementAlternative *node = first();
  while( node != NULL ) {
    node->_get_list_of_input_signals(list);
    node = successor(node);
  }
}


void
IIRScram_CaseStatementAlternativeList::_build_wait_list(dl_list<IIRScram_WaitStatement>* list) {
  IIR_CaseStatementAlternative *stmt = first();

  while (stmt != NULL) {
    stmt->_build_wait_list(list);
    stmt = successor(stmt);
  }
}

void
IIRScram_CaseStatementAlternativeList::_get_signal_source_info( set<IIR> *siginfo ){
  IIR_CaseStatementAlternative* stmt = first();
  while( stmt != NULL ){
    stmt->_get_signal_source_info(siginfo);
    stmt = successor(stmt);
  }
}

visitor_return_type *IIRScram_CaseStatementAlternativeList::_accept_visitor(node_visitor *visitor, visitor_argument_type *arg) {
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_CaseStatementAlternativeList(this, arg);
};

void
IIRScram_CaseStatementAlternativeList::_publish_cc_decl_for_loop_iterator( published_file &_cc_out ) {
  IIR_CaseStatementAlternative* stmt = first();
  for(; stmt != NULL; ) {
    stmt->_publish_cc_decl_for_loop_iterator(_cc_out);
    stmt = successor(stmt);
  }
}
  
