
// Copyright (c) 2002-2003 The University of Cincinnati.
// All rights reserved.
 
// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.
 
// Authors: Harish Venkataramani venkath@ececs.uc.edu

//---------------------------------------------------------------------------

#include "IIRBase_BranchQuantityDeclaration.hh"
#include "savant.hh"

IIRBase_BranchQuantityDeclaration::IIRBase_BranchQuantityDeclaration() {

  set_across_aspect_expression(NULL);
  set_through_aspect_expression(NULL);
  set_plus_terminal_name(NULL);
  set_minus_terminal_name(NULL);
}

IIRBase_BranchQuantityDeclaration::~IIRBase_BranchQuantityDeclaration() {
}

void
IIRBase_BranchQuantityDeclaration::set_across_aspect_expression(IIR* across_aspect){
  this->across_aspect_expression = across_aspect;
}

IIR*
IIRBase_BranchQuantityDeclaration::get_across_aspect_expression() {
  return across_aspect_expression;
}

void
IIRBase_BranchQuantityDeclaration::set_through_aspect_expression(IIR* through_aspect){
  this->through_aspect_expression = through_aspect;
}

IIR*
IIRBase_BranchQuantityDeclaration::get_through_aspect_expression() {
  return through_aspect_expression;
}

void
IIRBase_BranchQuantityDeclaration::set_plus_terminal_name(IIR* plus_terminal_name  ) {
  this->plus_terminal_name = plus_terminal_name;
}

IIR*
IIRBase_BranchQuantityDeclaration::get_plus_terminal_name() {
  return plus_terminal_name;
}

void
IIRBase_BranchQuantityDeclaration::set_minus_terminal_name(IIR* minus_terminal_name ) {
  this->minus_terminal_name = minus_terminal_name;
}

IIR*
IIRBase_BranchQuantityDeclaration::get_minus_terminal_name() {
  return minus_terminal_name;
}

void
IIRBase_BranchQuantityDeclaration::set_across_aspect_tolerance(IIR* tol_aspect) {
  this->across_aspect_tolerance = tol_aspect;
} 
 
IIR*
IIRBase_BranchQuantityDeclaration::get_across_aspect_tolerance() {
  return across_aspect_tolerance;
} 

void
IIRBase_BranchQuantityDeclaration::set_through_aspect_tolerance(IIR* tol_aspect) {
  this->through_aspect_tolerance = tol_aspect;
}
  
IIR*
IIRBase_BranchQuantityDeclaration::get_through_aspect_tolerance() {
  return through_aspect_tolerance;
}

