
// Copyright (c) 2002-2003 The University of Cincinnati.
// All rights reserved.
 
// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.
 
// Author: Harish Venkataramani venkath@ececs.uc.edu

#include "IIRScram_FreeQuantityDeclaration.hh"
#include "IIR_TypeDefinition.hh"
#include "published_file.hh"
#include "published_header_file.hh"
#include "published_cc_file.hh"
#include "IIR_StringLiteral.hh"
#include "set.hh"
#include "IIR_FloatingPointLiteral.hh"
#include "IIR_Attribute.hh"
#include "symbol_table.hh"
#include "published_file.hh"
#include <string.h>

extern symbol_table *cgen_sym_tab_ptr;
extern symbol_table *cgen_arch_sym_tab_ptr;

IIRScram_FreeQuantityDeclaration::~IIRScram_FreeQuantityDeclaration() {}

IIRScram_FreeQuantityDeclaration::IIRScram_FreeQuantityDeclaration() {
  _stmt_qty_index = -1;
  default_rtol = 1e-3;
  default_atol = 1e-12;
  _qty_occurence_index=0;
}

void
IIRScram_FreeQuantityDeclaration::_publish_vhdl_decl(ostream &_vhdl_out) {
  _vhdl_out << " quantity " ;
  get_declarator()->_publish_vhdl(_vhdl_out);
  _vhdl_out << " : " ;
  get_subtype()->_publish_vhdl(_vhdl_out);
  if(get_value() != NULL) {
    _vhdl_out << " := ";
    get_value()->_publish_vhdl(_vhdl_out);
  }
  _vhdl_out << " ;\n";

}

void
IIRScram_FreeQuantityDeclaration::_publish_cc_lvalue(published_file &_cc_out) {
  if(_is_implicit_declaration() == FALSE ) {
    if (cgen_sym_tab_ptr != NULL &&
        !cgen_sym_tab_ptr->in_scope(this)) {
      cgen_sym_tab_ptr->add_declaration(this);
    }
  }
  _get_declarator()->_publish_cc_lvalue(_cc_out);	
}

void IIRScram_FreeQuantityDeclaration::_publish_cc_decl(published_file &_cc_out) {
  SCRAM_CC_REF(_cc_out,"IIRScram_FreeQuantityDeclaration::_publish_cc_decl");
  IIRScram_FreeQuantityDeclaration::_type_check();
  _cc_out << "AMSType ";
  _get_declarator()->_publish_cc_lvalue(_cc_out);
  _cc_out << ";" << NL();
}

void
IIRScram_FreeQuantityDeclaration::_set_stmt_qty_index(IIR_Int32 *index,
                                                      set<IIR_Declaration>
                                                      *quantity_set) {
  if(!cgen_arch_sym_tab_ptr->in_scope(this)) {
    cgen_arch_sym_tab_ptr->add_declaration(this);
  }
  if( _get_stmt_qty_index() == -1 && index != NULL ){
    _stmt_qty_index = *index;
    (*index)++;
  }
  if( quantity_set != NULL)
    quantity_set->add(this);
}


IIR_Int32
IIRScram_FreeQuantityDeclaration::_get_stmt_qty_index() {
  return _stmt_qty_index;
}

void
IIRScram_FreeQuantityDeclaration::_flush_stmt_index() {
 _stmt_qty_index = -1;
}

void
IIRScram_FreeQuantityDeclaration::_set_stmt_node_index(IIR_Int32 *index, bool _is_right_child, bool &reducibleFlag) {
  if (_is_right_child == true) {
   _stmt_node_index.push_back(2 * (*index)+ 1);
  }
  else {
   _stmt_node_index.push_back(2 * (*index));
  }
}

void
IIRScram_FreeQuantityDeclaration::_publish_cc_ams_function(published_file &_cc_out) {
  if( _get_currently_publishing_unit() == SIMULTANEOUS_IF ) {
    ASSERT(get_subtype() != NULL);
    _cc_out << get_subtype()->_get_cc_type_name();
    _cc_out << "(ObjectBase::VARIABLE,qty["
            << _get_stmt_qty_index() << "])";
  }
  else {
    _cc_out << "  new equationNode('Q'," << _get_stmt_qty_index() << ",node"
            << (int)(_stmt_node_index[_qty_occurence_index++]/2) <<");" <<NL();
  }
}

const string
IIRScram_FreeQuantityDeclaration::_get_cc_object_type(){
  if(_is_implicit_declaration() == TRUE) {
    return "IMPLICIT_QUANTITY";
  } 
  else {
    return "QUANTITY";
  }
}

IIR_Boolean
IIRScram_FreeQuantityDeclaration::_is_readable() {
  return TRUE;
}

void
IIRScram_FreeQuantityDeclaration::_publish_cc_init(published_file &_cc_out) {
  ASSERT(_is_implicit_declaration() == FALSE);
  _publish_cc_init_quantity(_cc_out);
}

void
IIRScram_FreeQuantityDeclaration::_publish_cc_init_quantity(published_file &_cc_out) {
  if(_is_implicit_declaration() == TRUE) {
    _get_attribute_name()->_publish_cc_necessary_decl_init(_cc_out);
  }
}

void
IIRScram_FreeQuantityDeclaration::_type_check() {
  RTOL = default_rtol;
  ATOL = default_atol;
}

void
IIRScram_FreeQuantityDeclaration::_publish_cc_tolerances(published_file &_cc_out) {
  _cc_out << RTOL;
  _cc_out << ", " ;
  _cc_out << ATOL;
  _cc_out << ", ";
}
