
// Copyright (c) 1996-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Timothy J. McBrayer 
//          Malolan Chetlur     
//          Krishnan Subramani  

//---------------------------------------------------------------------------

#include "IIR_EqualityOperator.hh"
#include "savant.hh"
#include "published_file.hh"

IIRScram_EqualityOperator::~IIRScram_EqualityOperator() {}

void 
IIRScram_EqualityOperator::_publish_vhdl_operator(ostream &_vhdl_out) {
  _vhdl_out << " = ";
}

const string &
IIRScram_EqualityOperator::_get_cc_operator_name() const {
  static const string operator_name = "vhdlEqual";
  return operator_name;
}

IIR*
IIRScram_EqualityOperator::_clone() {
  IIR_EqualityOperator *clone = new IIR_EqualityOperator();
  IIRScram_DyadicOperator::_clone(clone);
  return clone;
}

IIRScram::OperatorPrecedenceLevel
IIRScram_EqualityOperator::_get_operator_precedence(){
  return IIRScram::RELATIONAL_OPERATOR;
}

IIR_Boolean
IIRScram_EqualityOperator::_is_relational_operator(){
  return TRUE ;
}

visitor_return_type *IIRScram_EqualityOperator::_accept_visitor(node_visitor *visitor, visitor_argument_type *arg) {
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_EqualityOperator(this, arg);
};

void
IIRScram_EqualityOperator::_publish_cc_ams_operator_name(published_file &_cc_out) {
  _cc_out << " == ";
}

