// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Krishnan Sunbramani skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//	    Magnus Danielson	cfmd@swipnet.se

//---------------------------------------------------------------------------
#include "IIRScram.hh"
#include "IIR_EnumerationLiteral.hh"
#include "IIR_EnumerationSubtypeDefinition.hh"
#include "IIR_IntegerLiteral32.hh"
#include "IIR_StringLiteral.hh"
#include "StandardPackage.hh"
#include "symbol_table.hh"
#include "error_func.hh"
#include "resolution_func.hh"
#include "published_file.hh"
#include "sstream-wrap.hh"


IIRScram_EnumerationTypeDefinition::~IIRScram_EnumerationTypeDefinition() {}

void 
IIRScram_EnumerationTypeDefinition::_publish_vhdl_type_decl(ostream &_vhdl_out) {
  enumeration_literals._publish_vhdl(_vhdl_out);
}

ostream&
IIRScram_EnumerationTypeDefinition::_print(ostream& os) {
  if( enumeration_literals.num_elements() > 0 ){
    enumeration_literals._print(os);
  }
  else{
    IIR_ScalarTypeDefinition::_print( os );
  }
  return os;
}

void 
IIRScram_EnumerationTypeDefinition::_publish_cc_list( published_file &_cc_out ) {
  IIR_EnumerationLiteral *literal;

  SCRAM_CC_REF( _cc_out, "IIRScram_EnumerationTypeDefinition::_publish_cc_list" );

  literal = enumeration_literals.first();
  _cc_out << "enum";
  _cc_out << this->_get_cc_type_name();
  ((IIR_StringLiteral *) literal->_get_declarator())->_publish_cc_variable_name( _cc_out );
  literal = enumeration_literals.successor(literal);
  for(register int i = 1; i < enumeration_literals.num_elements(); i++) {
    _cc_out << ", ";
    _cc_out << "enum";
    ((IIR_StringLiteral *) literal->_get_declarator())->_publish_cc_variable_name( _cc_out );
    literal = enumeration_literals.successor(literal);
  }
}

void
IIRScram_EnumerationTypeDefinition::_publish_cc_temporary_type_info( published_file &_cc_out,
								     char*, 
								     char*) {
  IIR_EnumerationLiteral *literal;

  SCRAM_CC_REF( _cc_out, "IIRScram_EnumerationTypeDefinition::_publish_cc_temporary_type_info" );
  
  // The type info structure is published here...
  _cc_out << "EnumerationTypeInfo(";
  
  if (_is_subtype() == TRUE)  {
    ASSERT (_get_base_type()->_is_iir_enumeration_type_definition() == TRUE);
    _cc_out << ((IIR_EnumerationTypeDefinition *) _get_base_type())->enumeration_literals.num_elements();
  }
  else  {
    _cc_out << enumeration_literals.num_elements();
  }
  _cc_out << ", ";
  
  //The imageMap strings are being published here
  _cc_out << " EnumerationTypeInfo::createImageMap("
	  << enumeration_literals.num_elements();
  
  literal = enumeration_literals.first();
  for(int i = 0; (i < enumeration_literals.num_elements()); i++) {
    _cc_out << ", \"" << literal->_get_declarator()->_convert_to_string()
	    << "\"";
    literal = enumeration_literals.successor(literal);
  }
  
  _cc_out << "), " ;
  if (_is_subtype() == FALSE) {
    _cc_out << "0";
  }
  else {
    get_left()->_publish_cc_universal_value( _cc_out );
  }
  
  _cc_out << ", ";
  _get_direction()->_publish_cc_direction( _cc_out );
  _cc_out << ")";
}

void 
IIRScram_EnumerationTypeDefinition::_publish_cc_type_info( published_file &_cc_out ){
  IIR_EnumerationLiteral *literal;
  
  if (_is_anonymous() == FALSE) {
    SCRAM_CC_REF( _cc_out, "IIRScram_EnumerationTypeDefinition::_publish_cc_type_info" );    
    // The type info structure is published here...
    if (_get_currently_publishing_unit() == PROCEDURE ||
	_get_currently_publishing_unit() == FUNCTION  ||
	_get_currently_publishing_unit() == PACKAGE_BODY ||
	_get_currently_publishing_unit() == PACKAGE_PUB ){
      _cc_out << "EnumerationTypeInfo" << NL();
    }
    
    _publish_cc_lvalue( _cc_out );
    _cc_out << OS("_info(");
    
    if (_is_subtype() == TRUE)  {
      SCRAM_CC_REF( _cc_out, "IIRScram_EnumerationTypeDefinition::_publish_cc_type_info" );
      ASSERT (_get_base_type()->_is_iir_enumeration_type_definition() == TRUE);
      _cc_out << ((IIR_EnumerationTypeDefinition *) _get_base_type())->enumeration_literals.num_elements();
    }
    else  {
      SCRAM_CC_REF( _cc_out, "IIRScram_EnumerationTypeDefinition::_publish_cc_type_info" );
      _cc_out << enumeration_literals.num_elements();
    }
    _cc_out << "," << NL();
    
    //The imageMap strings are being published here
    _cc_out << OS("EnumerationTypeInfo::createImageMap(")
	    << enumeration_literals.num_elements();
    
    literal = enumeration_literals.first();
    for( int i = 0; i < enumeration_literals.num_elements(); i++) {
      _cc_out << "," << NL()
	      << "\"" << literal->_get_declarator()->_convert_to_string()
	      << "\"";
      literal = enumeration_literals.successor(literal);
    }
    
    _cc_out << CS("),");
    if( !_is_subtype() ){
      _cc_out << "0";
    }
    else {
      get_left()->_publish_cc_universal_value( _cc_out );
    }
    
    _cc_out << "," << NL();
    _get_direction()->_publish_cc_direction( _cc_out );
    _cc_out << CS(")");
  }
  SCRAM_CC_REF( _cc_out, "IIRScram_EnumerationTypeDefinition::_publish_cc_type_info" );    

  if ((_get_currently_publishing_unit() == PACKAGE_BODY) ||
      (_get_currently_publishing_unit() == PACKAGE_PUB)) {
    _cc_out << ";" << NL()
	    << "TypeInfo &" << NL()
	    << "get";
    _publish_cc_lvalue( _cc_out );
    _cc_out << OS("Info(){")
	    << "return ";
    _publish_cc_lvalue( _cc_out );
    _cc_out << "_info;" << NL()
	    << CS("}");
  }
}

void 
IIRScram_EnumerationTypeDefinition::_publish_cc_extern_type_info( published_file &_cc_out ){

  SCRAM_CC_REF( _cc_out, "IIRScram_EnumerationTypeDefinition::_publish_cc_extern_type_info" );

  ASSERT ( _is_scalar_type() == TRUE );
  
  if (_is_anonymous() == FALSE) {
    if ((_get_currently_publishing_unit() == PACKAGE_PUB) ||
	(_get_currently_publishing_unit() == PACKAGE_BODY)) {
      _cc_out << "  extern EnumerationTypeInfo ";
      
    }
    else {
      _cc_out << "  EnumerationTypeInfo ";
    }
    
    _publish_cc_lvalue( _cc_out );
    _cc_out << "_info;\n";
    
    
    _cc_out << "  TypeInfo& get";
    _publish_cc_lvalue( _cc_out );
    _cc_out << "Info()";
    
    if ((_get_currently_publishing_unit() != PACKAGE_PUB) &&
	(_get_currently_publishing_unit() != PACKAGE_BODY)) {
      _cc_out << " const {\n"
	      << "    return (TypeInfo &) ";
      _publish_cc_lvalue( _cc_out );
      _cc_out << "_info;\n"
	      << "  }\n\n";
    }
    else {
      _cc_out << ";\n";
    }
  }
  else {
    ASSERT (_get_base_type() != NULL);
    if (_get_base_type()->_is_anonymous() == FALSE) {
      _get_base_type()->_publish_cc_extern_type_info( _cc_out );
    }
  }
}

void 
IIRScram_EnumerationTypeDefinition::_publish_cc_type_string( published_file &_cc_out ){

  SCRAM_CC_REF( _cc_out, "IIRScram_EnumerationTypeDefinition::_publish_cc_type_string" );

  _cc_out << "EnumerationType";
}

void 
IIRScram_EnumerationTypeDefinition::_publish_cc_data_members( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_EnumerationTypeDefinition::_publish_cc_data_members" );

// Publish the imageMap array
  _cc_out << "  static char *imageMap[" << enumeration_literals.num_elements() 
	  << "];" << NL();

// Publish the enumeration list
  _cc_out << "  enum ";
  _cc_out << _get_cc_type_name();
  _cc_out << "Enum {";
  _publish_cc_list( _cc_out );
  _cc_out << "};" << NL();
  _cc_out << NL();
}

void
IIRScram_EnumerationTypeDefinition::_publish_cc_decl_constructors( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_EnumerationTypeDefinition::_publish_cc_decl_constructors" );

  if(_is_subtype_decl() == TRUE) {
    _publish_cc_subtype_constructors( _cc_out );
  }
  else {
    _publish_cc_type_constructors( _cc_out );
  }
}

void
IIRScram_EnumerationTypeDefinition::_publish_cc_type_constructors( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_EnumerationTypeDefinition::_publish_cc_type_constructors" );

   IIRScram_ScalarTypeDefinition::_publish_cc_type_constructors( _cc_out );

// Constructor taking ObjectBase::ObjectType and enum as parameters
  _cc_out << "  ";
  _cc_out << _get_cc_type_name();
  _cc_out << "(ObjectBase::ObjectType objType, ";
  _cc_out << _get_cc_type_name();
  _cc_out << "Enum val):";
  _publish_cc_parent_type_name( _cc_out );
  _cc_out << "(objType, UniversalInteger(int(val)), "; 
  _cc_out << _get_cc_type_name();
  _cc_out << "_info) {}" << NL();
}

void
IIRScram_EnumerationTypeDefinition::_publish_cc_subtype_constructors( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_EnumerationTypeDefinition::_publish_cc_subtype_constructors" );

  //Call the parents function first

  IIRScram_ScalarTypeDefinition::_publish_cc_subtype_constructors( _cc_out );

  // Constructor taking ObjectBase::ObjectType and enum as parameters
  _cc_out << "  ";
  _cc_out << _get_cc_type_name();
  _cc_out << "(ObjectBase::ObjectType objType, ";
  // Only the base type has the enumeration list.  All the subtypes of
  // that type inherit this list.
  _cc_out << _get_base_type()->_get_cc_type_name();
  _cc_out << "Enum val) :";
  _publish_cc_parent_type_name( _cc_out );
  _cc_out << "(objType, UniversalInteger(int(val)),";
  _cc_out << _get_cc_type_name();
  _cc_out << "_info) {}" << NL();
}
  
void 
IIRScram_EnumerationTypeDefinition::_publish_cc_decl_cc( published_file &_cc_out ) {
  IIR_EnumerationLiteral *literal;

  SCRAM_CC_REF( _cc_out, "IIRScram_EnumerationTypeDefinition::_publish_cc_decl_cc" );

  _publish_cc_include( _cc_out );
  _cc_out << NL();

  // Only the base type has the image map list.  All the subtypes inherit
  // this image map list from the bottom base type.
  if(_is_subtype_decl() == FALSE) {
    ostringstream classStream;
    string className;
    _publish_cc_class_name( classStream );
    className = classStream.str();

    _cc_out << "char *" << className << "::imageMap[" 
	    << enumeration_literals.num_elements() << "] = {";
    literal = enumeration_literals.first();
    for(register int i = 0; i < (enumeration_literals.num_elements()-1); i++) {
      _cc_out << "\"" << literal->_get_declarator()->_convert_to_string()
	      << "\", ";
      literal = enumeration_literals.successor(literal);
    }
    if(enumeration_literals.num_elements() > 0) {
      _cc_out << "\"" << literal->_get_declarator()->_convert_to_string()
	      << "\"";
    }
    _cc_out << "};" << NL();
  }
}

void 
IIRScram_EnumerationTypeDefinition::_publish_cc_universal_type( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_EnumerationTypeDefinition::_publish_cc_universal_type" );

  _cc_out << "UniversalInteger";
}

const string
IIRScram_EnumerationTypeDefinition::_get_cc_kernel_type(){
  //  SCRAM_CC_REF( _cc_out, "IIRScram_EnumerationTypeDefinition::_publish_cc_kernel_type" );
  return string("EnumerationType");
}

void 
IIRScram_EnumerationTypeDefinition::_publish_cc_range( published_file &_cc_out ) {
  ASSERT(get_left() != NULL);
  ASSERT(get_direction() != NULL);
  ASSERT(get_right() != NULL);

  SCRAM_CC_REF( _cc_out, "IIRScram_EnumerationTypeDefinition::_publish_cc_range" );

  get_left()->_publish_cc_universal_value( _cc_out );
//   enumeration_literals.first()->_publish_cc_universal_value( _cc_out );
  _cc_out << ", ";
  get_direction()->_publish_cc_direction( _cc_out );
  _cc_out << ", ";
  get_right()->_publish_cc_universal_value( _cc_out );
//   enumeration_literals.last()->_publish_cc_universal_value( _cc_out );
}

// LRM defnies an enumeration type as a character type thus (Section 3.1.1):
//   An enumeration type is said to be a character type if at least one of
//   its enumeration literals is a character literal.
IIR_Boolean
IIRScram_EnumerationTypeDefinition::_is_character_type() {
  IIR_Boolean retval = FALSE;

  if( get_base_type() != 0 ){
    retval = get_base_type()->_is_character_type();
  }
  else{

    IIR_EnumerationLiteral *literal = enumeration_literals.first();
    while(literal != NULL) {
      if(literal->_is_character_literal() == TRUE) {
	retval = TRUE;
	break;
      }
      literal = enumeration_literals.successor(literal);
    }
  }

  return retval;
}

IIR_TypeDefinition *
IIRScram_EnumerationTypeDefinition::_get_new_subtype(){
  IIR_TypeDefinition *retval = new IIR_EnumerationSubtypeDefinition();
  
  return retval;
}

IIR *
IIRScram_EnumerationTypeDefinition::_clone(){
  IIR_EnumerationTypeDefinition *retval = new IIR_EnumerationTypeDefinition();
  _clone( retval );

  return retval;
}

void 
IIRScram_EnumerationTypeDefinition::_clone( IIR *copy_into ){
  ASSERT( copy_into->_is_iir_enumeration_type_definition() == TRUE );
  IIR_EnumerationTypeDefinition *as_enumeration_type = 
    (IIR_EnumerationTypeDefinition *)copy_into;

  as_enumeration_type->enumeration_literals = enumeration_literals;
  IIR_ScalarTypeDefinition::_clone( copy_into );
}

set<IIR_Declaration> *
IIRScram_EnumerationTypeDefinition::_find_declarations( IIR_TextLiteral *to_find ){
  return enumeration_literals._find_declarations( to_find );
}

set<IIR_Declaration> *
IIRScram_EnumerationTypeDefinition::_find_declarations( IIR_Name *to_find ){
  return enumeration_literals._find_declarations( to_find );
}

void 
IIRScram_EnumerationTypeDefinition::_come_into_scope( symbol_table *sym_tab,
						      IIR_TypeDeclaration *type_decl ){
  IIR_ScalarTypeDefinition::_come_into_scope( sym_tab, type_decl );

  IIR_EnumerationLiteral *literal = enumeration_literals.first();
  while( literal != NULL ){
    sym_tab->add_declaration( literal );
    literal = enumeration_literals.successor( literal );
  }
}

void 
IIRScram_EnumerationTypeDefinition::_come_out_of_scope( symbol_table *sym_tab ){
  IIR_ScalarTypeDefinition::_come_out_of_scope( sym_tab );

  IIR_EnumerationLiteral *literal = enumeration_literals.first();
  while( literal != NULL ){
    sym_tab->remove_from_scope( literal );
    literal = enumeration_literals.successor( literal );
  }
}

void 
IIRScram_EnumerationTypeDefinition::_set_resolution_function( IIR_FunctionDeclaration * ){
  ostringstream err;
  err << "Internal error - IIRScram_EnumerationTypeDefinition::_set_resolution_function was "
      << "called.  Resolution functions can't be associated with an enumeration type and this "
      << "should have been caught earlier.";
  report_error( this, err.str() );
}

IIR_EnumerationSubtypeDefinition *
IIRScram_EnumerationTypeDefinition::_construct_new_type( IIR_EnumerationLiteralList *literals,
							 IIR_TypeDeclaration *type_decl ){
  ASSERT( literals != NULL );

  IIR_EnumerationSubtypeDefinition *retval = NULL;
  IIR_EnumerationTypeDefinition *base_type = new IIR_EnumerationTypeDefinition();
  copy_location( type_decl, base_type );

  base_type->set_left( literals->first() );
  base_type->set_direction( StandardPackage::get_true_literal( ) );  
  base_type->set_right( literals->last() );
  base_type->enumeration_literals = *literals;
  base_type->_set_declaration( type_decl );

  IIR_TypeDefinition *temp = base_type->_construct_new_subtype( 0, 0 );
  copy_location( type_decl, temp );
  ASSERT( temp->get_kind() == IIR_ENUMERATION_SUBTYPE_DEFINITION );
  retval = (IIR_EnumerationSubtypeDefinition *)temp;

  retval->_set_declaration( type_decl );

  IIR_EnumerationLiteral *current = base_type->enumeration_literals.first();
  while( current != NULL ){
    current->set_subtype( retval );
    current = base_type->enumeration_literals.successor( current );
  }

  return retval; 
}

visitor_return_type *
IIRScram_EnumerationTypeDefinition::_accept_visitor(node_visitor *visitor, visitor_argument_type *arg) {
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_EnumerationTypeDefinition(this, arg);
};
