
#ifndef IIRSCRAM_COMPONENT_DECLARATION_HH
#define IIRSCRAM_COMPONENT_DECLARATION_HH

// Copyright (c) 1996-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR
// NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR DISTRIBUTING
// THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S., and
// the terms of this license.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2, June
// 1991. A copy of this license agreement can be found in the file "LGPL",
// distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Malolan Chetlur     
//          Umesh Kumar V. Rajasekaran
//          Narayanan Thondugulam

#include "IIRBase_ComponentDeclaration.hh"

class IIR_List ;
class IIR_Name;

class IIRScram_ComponentDeclaration : public IIRBase_ComponentDeclaration {

public:

  /// Accept visitations \Ref{_accept_visitor}.
  visitor_return_type* _accept_visitor(node_visitor *, visitor_argument_type *);

  declaration_type _get_type();
  IIR_PortList *_get_port_list();
  IIR_GenericList *_get_generic_list();
  set<IIR_Declaration> *_find_declarations( IIR_Name * );

  void _make_interface_visible( symbol_table * );

  IIR_TypeDefinition *_get_port_type( int );

  void _publish_vhdl_decl(ostream &);
  void _publish_cc_binding_name( ostream& outstream );

  /**
     Publish elaboration files.  Needs the fake param to match the
     signature correctly.
  */
  void _publish_cc_elaborate( published_file & );
  void _publish_cc_headerfile();
  void _publish_cc_ccfile();
  void _publish_cc_class( published_file &_cc_out );
  void _publish_cc_constructor( published_file &_cc_out );
  void _publish_cc_constructor_with_no_arguments( published_file &_cc_out );
  void _publish_cc_constructor_with_arguments( published_file &_cc_out );
  void _publish_cc_destructor( published_file &_cc_out );
  void _publish_cc_instantiate( published_file &_cc_out );
  void _publish_cc_createNetInfo( published_file &_cc_out );
  void _publish_cc_connect( published_file &_cc_out );
  void _publish_cc_getboundentityinfo( published_file &_cc_out );
  void _publish_cc_include( published_file &_cc_out );
 
  void _publish_cc_ams_form_characteristic_expressions( published_file &_cc_out );
  void _publish_cc_ams_connect_terminals( published_file &_cc_out );

#ifdef PROCESS_COMBINATION
  void _static_elaborate(IIR_ArchitectureDeclaration*, IIR_DeclarationList*,  char*);
#endif

  IIR_Boolean _is_iir_component_declaration(){ return TRUE; }
  IIR_Boolean _is_component_decl() { return TRUE; }

  IIR_AttributeSpecificationList* _get_attribute_specification_list(){ return &attributes; }
  
protected:
  IIRScram_ComponentDeclaration() {}
  virtual ~IIRScram_ComponentDeclaration() = 0;
    
private:
};
#endif
