
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu

//---------------------------------------------------------------------------

#include "IIRBase_Name.hh"
#include "set.hh"
#include "symbol_table.hh"
#include <cstdlib>
#include <iostream>
#include "IIR_Identifier.hh"

#include "savant.hh"

IIRBase_Name::IIRBase_Name(){
  set_prefix( NULL );
}

IIRBase_Name::~IIRBase_Name(){}

IIR **
IIRBase_Name::lookup(IIR_Identifier *identifier,
		     IIR_Int32      &number_of_matches,
		     IIR            *&first_match){

  set<IIR_Declaration> *matches = identifier->_get_symbol_table()->find_set( identifier );
  number_of_matches = matches->num_elements();

  IIR **return_array = new IIR *[ number_of_matches ];

  IIR_Declaration *current = matches->get_element();

  int i;
  for( i = 0; i < number_of_matches ; i++ ){
    return_array[i] = current;
    current = matches->get_next_element();
  }

  return return_array;
}

IIR **
IIRBase_Name::lookup(IIR_Name    *name,
		     IIR_Int32   &number_of_matches,
		     IIR         *&first_match){
  IIR** return_array = NULL;
  cerr << "IIRBase_Name::lookup(IIR_Name    *name not implemented yet!"<< endl;
  abort();
  return return_array;
}

IIR *
IIRBase_Name::get_prefix(){
  return prefix;
}

void 
IIRBase_Name::set_prefix( IIR *prefix ){
  this->prefix = prefix;
}



