// Copyright (C) 1999-2004
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __panda_h__
#define __panda_h__

#include "basecircle.h"

class Panda : public BaseCircle {
 private:
  double *angles;
  int angnum;
  Matrix flip;               // iis needs a flip in Y

  void sortRadii();
  void sortAngles();
  void render(Drawable, const Matrix&, double, RenderMode);
  void listA(ostream&, CoordSystem, SkyFrame, SkyFormat, char);
  void listB(ostream&, CoordSystem, SkyFrame, SkyFormat, char);

 public:
  Panda(FrameBase* p, const Vector& ctr, 
	double ang1, double ang2, int angnum,
	double start, double stop, int num,
	const char* clr, int w, const char* f, 
	const char* t, unsigned short prop, const char* c,
	const List<Tag>& tag);

  Panda(FrameBase* p, const Vector& ctr, 
	double* a, int an,
	double* r, int rn,
	const char* clr, int w, const char* f, 
	const char* t, unsigned short prop, const char* c,
	const List<Tag>& tag);

  Panda(const Panda&);

  virtual ~Panda();

  Marker* dup() {return new Panda(*this);}
  void updateBBox();
  void edit(const Vector&, int);
  void editEnd();

  void rotateBegin() {}
  void rotate(const Vector& v, int h) {}
  void rotateEnd() {}

  const double* getAngles() {return angles;}
  int getAnglesCount() {return angnum;}
  const double* getRadii() {return radii;}

  int addAngles(const Vector&);
  int addRadii(const Vector&);

  void setAnglesRadii(double, double, int, double, double, int);
  void setAnglesRadii(const double*, int, const double*, int);
  void deleteAnglesRadii(int h);

  void ps(int);

  void list(ostream&, CoordSystem, SkyFrame, SkyFormat, char);
  void listCiao(ostream&, CoordSystem, SkyFrame, SkyFormat, char);

  double radToDeg(double r);
};

#endif
