#  Copyright (C) 1999-2004
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc TextDialog {frame id} {
    # see if we already have a header window visible

    set w ".marker$id"
    set mb ".mb$id"

    if [winfo exist $w] {
	raise $w
	return
    }

    # Init common items

    InitMarkerDialog $frame $id
    PropMenuTextDialog $frame $mb $id
    CoordMenuMarkerDialog $frame $mb $id CoordTextCB
    CoordMarkerCB $frame $id

    # file menu items

    $mb.file add command -label "Apply" \
	-command "ApplyTextDialog $frame $id"
    $mb.file add separator
    $mb.file add command -label "Close" \
	-command "CloseTextDialog $frame $id"

    # Init Text variables

    RotateMarkerCB $frame $id

    # Text specific callbacks

    $frame marker $id callback rotate RotateMarkerCB $frame
    $frame marker $id callback delete DeleteTextDialog $frame

    # Dialog

    CommonMarkerDialog $frame $id
    wm protocol $w WM_DELETE_WINDOW "CloseTextDialog $frame $id"

    # Angle

    label $w.ref.f.angleTitle -text "Angle"
    entry $w.ref.f.angle -textvariable marker($frame,$id,angle) -width 13
    label $w.ref.f.angleUnit -relief groove -width 9 -padx 4 \
	-text "degrees"

    grid $w.ref.f.angleTitle $w.ref.f.angle x $w.ref.f.angleUnit \
	-padx 4 -sticky w

    # Buttons

    button $w.buttons.apply -text "Apply" \
	-command "ApplyTextDialog $frame $id"
    button $w.buttons.close -text "Close" \
	-command "CloseTextDialog $frame $id"
    pack $w.buttons.apply $w.buttons.close -side left -padx 10 -expand true

    bind $w <Return> "ApplyTextDialog $frame $id"

    # some window managers need a hint
    raise $w
}

proc PropMenuTextDialog {frame mb id} {
    global menu
    global marker

    menu $mb.properties -tearoff 0 -selectcolor $menu(selectcolor)
    $mb.properties add checkbutton -label "Can Move" \
	-variable marker($frame,$id,move) \
	-command "PropertyMarkerDialog $frame $id move"
    $mb.properties add checkbutton -label "Can Delete" \
	-variable marker($frame,$id,delete) \
	-command "PropertyMarkerDialog $frame $id delete"
}

proc ApplyTextDialog {frame id} {
    RotateMarkerDialog $frame $id
    ApplyMarkerDialog $frame $id
}

# dialog is closed, marker still exist

proc CloseTextDialog {frame id} {
    global marker

    $frame marker $id delete callback rotate RotateMarkerCB
    $frame marker $id delete callback delete DeleteTextDialog
    DeleteMarkerCBs $frame $id

    DeleteTextDialog $frame $id
}

# marker is being deleted, just close dialog

proc DeleteTextDialog {frame id} {
    global marker

    DeleteMarkerDialog $frame $id

    unset marker($frame,$id,angle)
}

proc CoordTextCB {frame id} {
    CoordMarkerCB $frame $id

    MoveMarkerCB $frame $id
}

