#  Copyright (C) 1999-2004
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc EllipseDialog {frame id} {
    global marker

    # see if we already have a header window visible

    set w ".marker$id"
    set mb ".mb$id"

    if [winfo exist $w] {
	raise $w
	return
    }

    # Init common items

    InitMarkerDialog $frame $id
    PropMenuMarkerDialog $frame $mb $id
    CoordMenuMarkerDialog $frame $mb $id CoordEllipseCB
    CoordMarkerCB $frame $id

    # file menu items

    $mb.file add command -label "Apply" \
	-command "ApplyEllipseDialog $frame $id"
    $mb.file add separator
    $mb.file add command -label "Close" \
	-command "CloseEllipseDialog $frame $id"

    # ellipse menu items

    set marker($frame,$id,rcoord) $marker(dialog,dist,system)
    set marker($frame,$id,rlabel) $marker(dialog,dist,system)
    set marker($frame,$id,rformat) $marker(dialog,dist,format)

    DistMenuMarkerDialog $frame $mb $id DistEllipseCB radius rcoord rformat
    $mb add cascade -label Radius -menu $mb.radius
    DistEllipseCB $frame $id

    # Init ellipse variables

    EditEllipseCB $frame $id
    RotateMarkerCB $frame $id

    # ellipse specific callbacks

    $frame marker $id callback edit EditEllipseCB $frame
    $frame marker $id callback rotate RotateMarkerCB $frame
    $frame marker $id callback delete DeleteEllipseDialog $frame

    # Dialog

    CommonMarkerDialog $frame $id
    wm protocol $w WM_DELETE_WINDOW "CloseEllipseDialog $frame $id"

    # Radius

    label $w.ref.f.radiusTitle -text "Radius"
    entry $w.ref.f.radius1 -textvariable marker($frame,$id,radius1) -width 13 
    entry $w.ref.f.radius2 -textvariable marker($frame,$id,radius2) -width 13 
    label $w.ref.f.radiusCoord -textvariable marker($frame,$id,rlabel) \
	-relief groove -width 9 -padx 4

    label $w.ref.f.angleTitle -text "Angle"
    entry $w.ref.f.angle -textvariable marker($frame,$id,angle) -width 13 
    label $w.ref.f.angleUnit -relief groove -width 9 -padx 4 \
	-text "degrees"

    grid $w.ref.f.radiusTitle $w.ref.f.radius1 $w.ref.f.radius2 \
	$w.ref.f.radiusCoord -padx 4 -sticky w
    grid $w.ref.f.angleTitle $w.ref.f.angle x $w.ref.f.angleUnit \
	-padx 4 -sticky w

    # Buttons

    button $w.buttons.apply -text "Apply" \
	-command "ApplyEllipseDialog $frame $id"
    button $w.buttons.close -text "Close" \
	-command "CloseEllipseDialog $frame $id"
    pack $w.buttons.apply $w.buttons.close -side left -padx 10 -expand true

    bind $w <Return> "ApplyEllipseDialog $frame $id"

    # some window managers need a hint
    raise $w
}

proc ApplyEllipseDialog {frame id} {
    EditEllipseDialog $frame $id
    RotateMarkerDialog $frame $id
    ApplyMarkerDialog $frame $id
}

proc CloseEllipseDialog {frame id} {
    global marker

    $frame marker $id delete callback edit EditEllipseCB
    $frame marker $id delete callback rotate RotateMarkerCB
    $frame marker $id delete callback delete DeleteEllipseDialog
    DeleteMarkerCBs $frame $id

    DeleteEllipseDialog $frame $id
}

proc DeleteEllipseDialog {frame id} {
    global marker

    DeleteMarkerDialog $frame $id

    unset marker($frame,$id,radius1)
    unset marker($frame,$id,radius2)
    unset marker($frame,$id,angle)
    unset marker($frame,$id,rcoord)
    unset marker($frame,$id,rformat)
    unset marker($frame,$id,rlabel)
}

proc EditEllipseDialog {frame id} {
    global marker

    $frame marker $id ellipse radius \
	$marker($frame,$id,radius1) $marker($frame,$id,radius2) \
	$marker($frame,$id,rcoord) $marker($frame,$id,rformat)
}

proc EditEllipseCB {frame id} {
    global marker

    set r [$frame get marker $id ellipse radius \
	       $marker($frame,$id,rcoord) $marker($frame,$id,rformat)]

    set marker($frame,$id,radius1) [lindex $r 0]
    set marker($frame,$id,radius2) [lindex $r 1]
}

proc CoordEllipseCB {frame id} {
    CoordMarkerCB $frame $id

    MoveMarkerCB $frame $id
    EditEllipseCB $frame $id
    RotateMarkerCB $frame $id
}

proc DistEllipseCB {frame id} {
    global marker
    set mb ".mb$id"

    AdjustDist $frame marker($frame,$id,rcoord)

    set marker($frame,$id,rlabel) $marker($frame,$id,rcoord)
    switch -- $marker($frame,$id,rcoord) {
	image -
	physical -
	amplifier -
	detector {}
	default {
	    if [$frame has wcs $marker($frame,$id,rcoord)] {
		if [$frame has wcs equatorial $marker($frame,$id,rcoord)] {
		    set marker($frame,$id,rlabel) $marker($frame,$id,rformat)
		} else {
		    set name [$frame get wcs name $marker($frame,$id,rcoord)]
		    if {$name != ""} {
			set marker($frame,$id,rlabel) $name
		    }
		}
	    }
	}
    }

    MoveMarkerCB $frame $id
    EditEllipseCB $frame $id
}

proc EllipseDefaultDialog {} {
    global marker
    global ed

    set w ".ellipse"

    set ed(ok) 0
    set ed(radius1) $marker(ellipse,radius1)
    set ed(radius2) $marker(ellipse,radius2)

    DialogCreate $w "Default Ellipse" -borderwidth 2
    frame $w.ed  -relief groove -borderwidth 2
    frame $w.buttons -relief groove -borderwidth 2
    pack $w.ed $w.buttons -fill x -ipadx 4 -ipady 4

    label $w.ed.title -text "Radius 1"
    entry $w.ed.radius1 -textvariable ed(radius1) -width 10 
    label $w.ed.unit -text "image" -relief groove -width 8
    
    label $w.ed.title2 -text "Radius 2"
    entry $w.ed.radius2 -textvariable ed(radius2) -width 10 
    label $w.ed.unit2 -text "image" -relief groove -width 8

    grid $w.ed.title $w.ed.radius1 $w.ed.unit -padx 4 -pady 1 -sticky w
    grid $w.ed.title2 $w.ed.radius2 $w.ed.unit2 -padx 4 -pady 1 -sticky w

    button $w.buttons.ok -text "OK" -default active -command {set ed(ok) 1}
    button $w.buttons.cancel -text "Cancel" -command {set ed(ok) 0}
    pack $w.buttons.ok -side left -padx 10
    pack $w.buttons.cancel -side right -padx 10

    bind $w <Return> {set ed(ok) 1}
    bind $w <Alt-o> "tkButtonInvoke $w.buttons.ok"
    bind $w <Alt-c> "tkButtonInvoke $w.buttons.cancel"

    DialogCenter $w 
    $w.ed.radius1 select range 0 end
    DialogWait $w ed(ok) $w.ed.radius1
    DialogDismiss $w

    if {$ed(ok)} {
	set marker(ellipse,radius1) $ed(radius1)
	set marker(ellipse,radius2) $ed(radius2)
    }

    unset ed
}
