/*
*  Rubrica
*  file: utils.h
*
*  
*  Copyright (C) 2000-2003 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef __RUBRICA_UTILS_H
#define __RUBRICA_UTILS_H

#include <gnome.h>
#include <libxml/tree.h>
#include <libxml/parser.h>

#include "rubrica.h"
#include "rubrica_type.h"

gboolean rubrica_utils_is_start(void);
void rubrica_utils_set_start(gboolean state);

void rubrica_utils_file_split(gchar *file, gchar **f, gchar **ext, gint *n);

int rubrica_utils_str2int(gchar *str);

void rubrica_utils_check_home(gchar *home);
void rubrica_utils_check_dictionary_home(gchar *home);
void rubrica_utils_check_folders(gchar *home);
gint rubrica_utils_make_user_rubrica_home(gchar *foder);
gint rubrica_utils_make_rubrica_home(gchar *home);
gint rubrica_utils_make_dictionary_home(gchar *home);
gint rubrica_utils_make_home(gchar *folder);
void rubrica_utils_copy_script(void);

void rubrica_utils_add_tooltip(GtkTooltips *tooltip);
void rubrica_utils_enable_tooltips(void);
void rubrica_utils_disable_tooltips(void);

void rubrica_utils_add_pixmap_directory(const gchar *directory);
gchar* rubrica_utils_find_pixmap_file (const gchar *filename);
void rubrica_utils_set_atk_action_description (AtkAction *action, 
					       const gchar *action_name,
					       const gchar *description);

GList *rubrica_utils_get_all_data(GtkWidget *tree, RubricaTreeType type);
gboolean rubrica_utils_extract_net_data(GtkTreeModel *model, GtkTreePath *path,
					GtkTreeIter *iter, gpointer data);
gboolean rubrica_utils_extract_phone_data(GtkTreeModel *model, 
					  GtkTreePath *path,
					  GtkTreeIter *iter, gpointer data);

RubricaTelephoneType rubrica_utils_telephone2int(gchar *tipo);

gchar *rubrica_utils_bool2str(gchar *str);
gboolean rubrica_utils_str2bool(gchar *str);

gchar* rubrica_utils_decode_date(gchar *str);
gchar* rubrica_utils_convert_time(time_t t,/* RubricaTimeFormatType type,*/ 
				  gboolean has_hour);
gint rubrica_utils_option_len(RubricaOptionType *option);

void rubrica_utils_debug_net_list(GList *lst);
void rubrica_utils_debug_tel_list(GList *lst);


#endif
