/*
 * This file was generated automatically by xsubpp version 1.9507 from the 
 * contents of Database.xs. Do not edit this file, edit Database.xs instead.
 *
 *	ANY CHANGES MADE HERE WILL BE LOST! 
 *
 */

#line 1 "Database.xs"
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include <fcntl.h>
#include "RPM.h"

static char * const rcsid = "$Id: Database.xs,v 1.15 2001/05/15 06:22:36 rjray Exp $";

/*
  rpmdb_TIEHASH

  This is the implementation of the tied-hash class constructor. The XS
  wrapper will verify that the value of class is correct, then massage the
  arguments as needed. The return value is expected to be either NULL or a
  valid RPM__Database value (which the XS wrapper will fix up).
*/
RPM__Database rpmdb_TIEHASH(pTHX_ char* class, SV* opts)
{
    char*  root  = (char *)NULL;
    int    mode  = O_RDONLY;
    mode_t perms = 0;
    HV*    opt_hash;
    SV*    t_magic;
    SV**   svp;
    RPM_Database* retvalp; /* For "private" */
    RPM__Database RETVAL;

    if (opts)
    {
        if (SvROK(opts) && (SvTYPE(opts) == SVt_PVHV))
        {
            /* This is a hash reference. We are concerned only with
               the key "root". "mode" and "perms" don't apply, as we are
               going to open the database as read-only. */
            opt_hash = (HV*)SvRV(opts);

            svp = hv_fetch(opt_hash, "root", 4, FALSE);
            if (svp && SvPOK(*svp))
                root = SvPV(*svp, PL_na);
        }
        else if (SvPOK(opts))
        {
            /* They passed a scalar, assumed to be the "root" */
            root = SvPV(opts, PL_na);
        }
        else
        {
            rpm_error(aTHX_ RPMERR_BADARG,
                      "Wrong type for argument 2 to TIEHASH");
            return (Null(RPM__Database));
        }
    }

    /* With that all processed, attempt to open the actual RPM DB */
    /* The retvalp is used for the C-level rpmlib information on databases */
    retvalp = new_RPM_storage(RPM_Database);
    if (rpmdbOpen(root, &retvalp->dbp, mode, perms) != 0)
        /* rpm lib will have set the error already */
        return (Null(RPM__Database));
    else
    {
        retvalp->current_rec = 0;
#if RPM_MAJOR < 4
        retvalp->index_set = (void *)NULL;
#else
        retvalp->noffs = retvalp->offx = 0;
        retvalp->offsets = (int *)NULL;
#endif
    }

    RETVAL = newHV();
    retvalp->storage = newHV();
    t_magic = newSViv((unsigned)retvalp);

    sv_magic((SV *)RETVAL, Nullsv, 'P', Nullch, 0);
    sv_magic((SV *)RETVAL, t_magic, '~', Nullch, 0);
    SvREFCNT_dec(t_magic);

    return RETVAL;
}

SV* rpmdb_FETCH(pTHX_ RPM__Database self, SV* key)
{
    const char* name = NULL; /* For the actual name out of (SV *)key */
    int namelen;             /* Arg for SvPV(..., len)               */
    int offset;              /* In case they pass an integer offset  */
    Header hdr;              /* For rpmdbGetRecord() calls           */
#if RPM_MAJOR >= 4
    rpmdbMatchIterator mi;
#else
    int result;
#endif
    SV** svp;
    SV* FETCH;
    RPM__Header FETCHp;
    RPM_Database* dbstruct;  /* This is the struct used to hold C-level data */

    struct_from_object_ret(RPM_Database, dbstruct, self, FETCH);
    /* De-reference key, if it is a reference */
    if (SvROK(key))
        key = SvRV(key);

    /* For sake of flexibility (and because it's almost zero overhead),
       allow the request to be by name -or- by an offset number */
    if (SvPOK(key))
    {
        name = SvPV(key, namelen);

        /* Step 1: Check to see if this has already been requested and is
           thus cached on the hash itself */
        svp = hv_fetch(dbstruct->storage, (char *)name, namelen, FALSE);
        if (svp && SvROK(*svp))
            return newSVsv(*svp);

#if RPM_MAJOR < 4
        /* This is the old (3.0.4+) way of setting up and searching */
        /* Create an index set if we don't already have one */
        if (! dbstruct->index_set)
        {
            dbstruct->index_set =
                (dbiIndexSet *)safemalloc(sizeof(dbiIndexSet));
            Zero(dbstruct->index_set, 1, dbiIndexSet);
        }
        /* Run the search */
        result = rpmdbFindPackage(dbstruct->dbp, name, dbstruct->index_set);
        if (result)
            /* Some sort of error occured when reading the DB or the
               name was not found. */
            return &PL_sv_undef;
        else
        {
            /* There may have been more than one match, but for now
               I can only take the first one off the list. */
            if (dbstruct->index_set->count)
            {
                offset = dbstruct->index_set->recs[0].recOffset;
            }
            else
            {
                /* In theory, this wouldn't happen since zero matches
                   would mean a return value of 1 from the library.
                   But I ain't betting the core on that... */
                return &PL_sv_undef;
            }
        }
#else
        /* This is the 4.0 way */
        offset = -1;
        mi =  rpmdbInitIterator(dbstruct->dbp, RPMTAG_NAME, name, 0);
        while ((hdr = rpmdbNextIterator(mi)) != NULL)
        {
            offset = rpmdbGetIteratorOffset(mi);
            break;
        }
        rpmdbFreeIterator(mi);
        if (offset == -1)
            /* Some sort of error occured when reading the DB or the
               name was not found. */
            return &PL_sv_undef;
#endif
    }
    else if (SvIOK(key))
    {
        /* This is actually a lot easier than fetch-by-name, which is
           why I've thrown it in */
        offset = SvIV(key);
    }
    else
    {
        rpm_error(aTHX_ RPMERR_BADARG,
                  "RPM::Database::FETCH: Second arg should be name or offset");
        return &PL_sv_undef;
    }

#if RPM_MAJOR < 4
    hdr = rpmdbGetRecord(dbstruct->dbp, offset);
    /* An error results in hdr getting NULL, which is just fine */
#else
    mi = rpmdbInitIterator(dbstruct->dbp, RPMDBI_PACKAGES,
                           &offset, sizeof(offset));
    hdr = rpmdbNextIterator(mi);
#endif
    if (hdr)
    {
#if RPM_MAJOR >= 4
        hdr = headerLink(hdr);
#endif
        FETCHp = rpmhdr_TIEHASH(aTHX_ "RPM::Header",
                                sv_2mortal(newSViv((unsigned)hdr)),
                                RPM_HEADER_FROM_REF | RPM_HEADER_READONLY);
        if (name == Null(const char *))
            name = SvPV(rpmhdr_FETCH(aTHX_ FETCHp,
                                     sv_2mortal(newSVpv("NAME", 4)),
                                     Null(const char *), 0, 0), namelen);
        FETCH = sv_bless(newRV_noinc((SV*)FETCHp),
                         gv_stashpv("RPM::Header", TRUE));
        hv_store(dbstruct->storage, (char *)name, namelen, newSVsv(FETCH),
                 FALSE);
    }
#if RPM_MAJOR >= 4
    rpmdbFreeIterator(mi);
#endif

    return FETCH;
}

bool rpmdb_EXISTS(pTHX_ RPM__Database self, SV* key)
{
    SV* tmp;

    tmp = rpmdb_FETCH(aTHX_ self, key);
    return (tmp != &PL_sv_undef);
}

/*
  This is quite a bit easier than the FIRSTKEY/NEXTKEY combo for headers.
  In these cases, the transition is based on the last offset fetched, which
  we store on the struct part of self. We don't have to worry about an
  iterator struct.
*/
int rpmdb_FIRSTKEY(pTHX_ RPM__Database self, SV** key, SV** value)
{
    RPM_Database* dbstruct;

    struct_from_object_ret(RPM_Database, dbstruct, self, 0);
#if RPM_MAJOR < 4
    /* This more or less resets our "iterator" */
    dbstruct->current_rec = 0;

    if (! (dbstruct->current_rec = rpmdbFirstRecNum(dbstruct->dbp)))
        return 0;
#else
    if (dbstruct->offsets == NULL || dbstruct->noffs <= 0)
    {
        rpmdbMatchIterator mi;
        Header h;

        if (dbstruct->offsets)
            free(dbstruct->offsets);
        dbstruct->offsets = NULL;
        dbstruct->noffs = 0;
        mi = rpmdbInitIterator(dbstruct->dbp, RPMDBI_PACKAGES, NULL, 0);
        while ((h = rpmdbNextIterator(mi)) != NULL)
        {
            dbstruct->noffs++;
            dbstruct->offsets =
                realloc(dbstruct->offsets,
                        dbstruct->noffs * sizeof(dbstruct->offsets[0]));
            dbstruct->offsets[dbstruct->noffs-1] = rpmdbGetIteratorOffset(mi);
        }
        rpmdbFreeIterator(mi);
    }

    if (dbstruct->offsets == NULL || dbstruct->noffs <= 0)
        return 0;

    dbstruct->offx = 0;
    dbstruct->current_rec = dbstruct->offsets[dbstruct->offx++];
#endif

    *value = rpmdb_FETCH(aTHX_ self, newSViv(dbstruct->current_rec));
    *key = rpmhdr_FETCH(aTHX_ (RPM__Header)SvRV(*value), newSVpv("name", 4),
                        Nullch, 0, 0);

    return 1;
}

int rpmdb_NEXTKEY(pTHX_ RPM__Database self, SV* key,
                  SV** nextkey, SV** nextvalue)
{
    RPM_Database* dbstruct;

    struct_from_object_ret(RPM_Database, dbstruct, self, 0);

#if RPM_MAJOR < 4
    if (! (dbstruct->current_rec = rpmdbNextRecNum(dbstruct->dbp,
                                                   dbstruct->current_rec)))
        return 0;
#else
    if (dbstruct->offsets == NULL || dbstruct->noffs <= 0)
         return 0;
    if (dbstruct->offx >= dbstruct->noffs)
        return 0;

    dbstruct->current_rec = dbstruct->offsets[dbstruct->offx++];
#endif

    *nextvalue = rpmdb_FETCH(aTHX_ self, newSViv(dbstruct->current_rec));
    *nextkey = rpmhdr_FETCH(aTHX_ (RPM__Header)SvRV(*nextvalue),
                            newSVpv("name", 4), Nullch, 0, 0);

    return 1;
}

void rpmdb_DESTROY(pTHX_ RPM__Database self)
{
    RPM_Database* dbstruct;  /* This is the struct used to hold C-level data */

    struct_from_object(RPM_Database, dbstruct, self);

    rpmdbClose(dbstruct->dbp);
#if RPM_MAJOR < 4
    if (dbstruct->index_set)
        dbiFreeIndexRecord(*dbstruct->index_set);
#else
    if (dbstruct->offsets)
        safefree(dbstruct->offsets);
#endif

    hv_undef(dbstruct->storage);
    safefree(dbstruct);
    hv_undef(self);
}

int rpmdb_init(SV* class, const char* root, int perms)
{
    return (1 - rpmdbInit(root, perms));
}

int rpmdb_rebuild(SV* class, const char* root)
{
    return (1 - rpmdbRebuild(root));
}

/*
  This is a front-end to all the rpmdbFindBy*() set, including FindByPackage
  which differs from FETCH above in that if there is actually more than one
  match, all will be returned.
*/
AV* rpmdb_find_by_whatever(pTHX_ RPM__Database self, SV* string, int idx)
{
    const char* str = NULL; /* For the actual string out of (SV *)string    */
    RPM_Database* dbstruct; /* This is the struct used to hold C-level data */
    AV* return_val;
    int loop;
    SV* tmp_hdr;
#if RPM_MAJOR >= 4
    rpmdbMatchIterator mi;
#else
    int result;
#endif

    /* Any successful operation will store items on this */
    return_val = newAV();

    struct_from_object_ret(RPM_Database, dbstruct, self, return_val);
    if (sv_derived_from(string, "RPM::Header"))
    {
        SV* fetch_string = rpmhdr_FETCH(aTHX_ (RPM__Header)SvRV(string),
                                        sv_2mortal(newSVpvn("NAME", 4)),
                                        Nullch, 0, 0);

        str = SvPV(fetch_string, PL_na);
    }
    else
    {
        /* De-reference key, if it is a reference */
        if (SvROK(string))
            string = SvRV(string);
        /* Get the string */
        str = SvPV(string, PL_na);
    }

#if RPM_MAJOR < 4
    /* Create an index set if we don't already have one */
    if (! dbstruct->index_set)
    {
        dbstruct->index_set = (dbiIndexSet *)safemalloc(sizeof(dbiIndexSet));
        Zero(dbstruct->index_set, 1, dbiIndexSet);
    }
    if (idx == RPMTAG_BASENAMES)
        result = rpmdbFindByFile(dbstruct->dbp, str, dbstruct->index_set);
    else if (idx == RPMTAG_GROUP)
        result = rpmdbFindByGroup(dbstruct->dbp, str, dbstruct->index_set);
    else if (idx == RPMTAG_PROVIDENAME)
        result = rpmdbFindByProvides(dbstruct->dbp, str, dbstruct->index_set);
    else if (idx == RPMTAG_REQUIRENAME)
        result = rpmdbFindByRequiredBy(dbstruct->dbp,str, dbstruct->index_set);
    else if (idx == RPMTAG_CONFLICTNAME)
        result = rpmdbFindByConflicts(dbstruct->dbp, str, dbstruct->index_set);
    else if (idx == RPMTAG_NAME)
        result = rpmdbFindPackage(dbstruct->dbp, str, dbstruct->index_set);

    /* The various rpmdbFind*() routines return 0 on success */
    if (! result)
    {
        av_extend(return_val, dbstruct->index_set->count);
        for (loop = 0; loop < dbstruct->index_set->count; loop++)
        {
            idx = dbstruct->index_set->recs[loop].recOffset;
            tmp_hdr = rpmdb_FETCH(aTHX_ self, sv_2mortal(newSViv(idx)));
            av_store(return_val, loop, sv_2mortal(newSVsv(tmp_hdr)));
        }
    }
#else
    mi = rpmdbInitIterator(dbstruct->dbp, idx, str, 0);
    if (mi)
    {
        av_extend(return_val, rpmdbGetIteratorCount(mi));
        loop = 0;
        while ((rpmdbNextIterator(mi)) != NULL)
        {
            idx = rpmdbGetIteratorOffset(mi);
            tmp_hdr = rpmdb_FETCH(aTHX_ self, sv_2mortal(newSViv(idx)));
            av_store(return_val, loop++, sv_2mortal(newSVsv(tmp_hdr)));
        }
    }
    rpmdbFreeIterator(mi);
#endif

    return return_val;
}


#line 426 "Database.c"
XS(XS_RPM__Database_TIEHASH)
{
    dXSARGS;
    if (items < 1 || items > 2)
	Perl_croak(aTHX_ "Usage: RPM::Database::TIEHASH(class, opts=NULL)");
    {
	char*	class = (char *)SvPV(ST(0),PL_na);
	SV*	opts;
	RPM__Database	RETVAL;

	if (items < 2)
	    opts = NULL;
	else {
	    opts = ST(1);
	}
#line 425 "Database.xs"
    RETVAL = rpmdb_TIEHASH(aTHX_ class, opts);
#line 444 "Database.c"
	ST(0) = sv_newmortal();
        if (RETVAL)
        {
            ST(0) = sv_bless(sv_2mortal(newRV_noinc((SV*)RETVAL)),
                            gv_stashpv("RPM::Database",
                                       TRUE));
        }
        else
        {
            ST(0) = newSVsv(&PL_sv_undef);
        }

    }
    XSRETURN(1);
}

XS(XS_RPM__Database_FETCH)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: RPM::Database::FETCH(self, key)");
    {
	RPM__Database	self;
	SV*	key = ST(1);
	SV *	RETVAL;

        if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVHV))
            self = (HV*)SvRV(ST(0));
        else
        {
            rpm_error(aTHX_ RPMERR_BADARG,
                      "RPM::Database::rpmdb_FETCH: not a blessed HV reference");
            XSRETURN_UNDEF;
        };
#line 435 "Database.xs"
    RETVAL = rpmdb_FETCH(aTHX_ self, key);
#line 481 "Database.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}

XS(XS_RPM__Database_STORE)
{
    dXSARGS;
    if (items < 0 || items > 3)
	Perl_croak(aTHX_ "Usage: RPM::Database::STORE(self=NULL, key=NULL, value=NULL)");
    {
	SV*	self;
	SV*	key;
	SV*	value;
	int	RETVAL;
	dXSTARG;

	if (items < 1)
	    self = NULL;
	else {
	    self = ST(0);
	}

	if (items < 2)
	    key = NULL;
	else {
	    key = ST(1);
	}

	if (items < 3)
	    value = NULL;
	else {
	    value = ST(2);
	}
#line 446 "Database.xs"
    {
        rpm_error(aTHX_ RPMERR_NOCREATEDB, "STORE: operation not permitted");
        RETVAL = 0;
    }
#line 522 "Database.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_RPM__Database_DELETE)
{
    dXSARGS;
    if (items < 0 || items > 2)
	Perl_croak(aTHX_ "Usage: RPM::Database::DELETE(self=NULL, key=NULL)");
    {
	SV*	self;
	SV*	key;
	SV *	RETVAL;

	if (items < 1)
	    self = NULL;
	else {
	    self = ST(0);
	}

	if (items < 2)
	    key = NULL;
	else {
	    key = ST(1);
	}
#line 459 "Database.xs"
    {
        rpm_error(aTHX_ RPMERR_NOCREATEDB, "DELETE: operation not permitted");
        RETVAL = Nullsv;
    }
#line 554 "Database.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}

XS(XS_RPM__Database_CLEAR)
{
    dXSARGS;
    if (items < 0 || items > 1)
	Perl_croak(aTHX_ "Usage: RPM::Database::CLEAR(self=NULL)");
    {
	SV*	self;
	int	RETVAL;
	dXSTARG;

	if (items < 1)
	    self = NULL;
	else {
	    self = ST(0);
	}
#line 471 "Database.xs"
    {
        rpm_error(aTHX_ RPMERR_NOCREATEDB, "CLEAR: operation not permitted");
        RETVAL = 0;
    }
#line 581 "Database.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_RPM__Database_EXISTS)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: RPM::Database::EXISTS(self, key)");
    {
	RPM__Database	self;
	SV*	key = ST(1);
	bool	RETVAL;

        if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVHV))
            self = (HV*)SvRV(ST(0));
        else
        {
            rpm_error(aTHX_ RPMERR_BADARG,
                      "RPM::Database::rpmdb_EXISTS: not a blessed HV reference");
            XSRETURN_UNDEF;
        };
#line 484 "Database.xs"
    RETVAL = rpmdb_EXISTS(aTHX_ self, key);
#line 607 "Database.c"
	ST(0) = boolSV(RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}

XS(XS_RPM__Database_FIRSTKEY)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: RPM::Database::FIRSTKEY(self)");
    SP -= items;
    {
	RPM__Database	self;

        if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVHV))
            self = (HV*)SvRV(ST(0));
        else
        {
            rpm_error(aTHX_ RPMERR_BADARG,
                      "RPM::Database::rpmdb_FIRSTKEY: not a blessed HV reference");
            XSRETURN_UNDEF;
        };
#line 493 "Database.xs"
    {
        SV* key;
        SV* value;

        if (! rpmdb_FIRSTKEY(aTHX_ self, &key, &value))
        {
            key = newSVsv(&PL_sv_undef);
            value = newSVsv(&PL_sv_undef);
        }

        EXTEND(SP, 2);
        PUSHs(sv_2mortal(value));
        PUSHs(sv_2mortal(newSVsv(key)));
    }
#line 646 "Database.c"
	PUTBACK;
	return;
    }
}

XS(XS_RPM__Database_NEXTKEY)
{
    dXSARGS;
    if (items < 1 || items > 2)
	Perl_croak(aTHX_ "Usage: RPM::Database::NEXTKEY(self, key=NULL)");
    SP -= items;
    {
	RPM__Database	self;
	SV*	key;

        if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVHV))
            self = (HV*)SvRV(ST(0));
        else
        {
            rpm_error(aTHX_ RPMERR_BADARG,
                      "RPM::Database::rpmdb_NEXTKEY: not a blessed HV reference");
            XSRETURN_UNDEF;
        };

	if (items < 2)
	    key = NULL;
	else {
	    key = ST(1);
	}
#line 514 "Database.xs"
    {
        SV* nextkey;
        SV* nextvalue;

        if (! rpmdb_NEXTKEY(aTHX_ self, key, &nextkey, &nextvalue))
        {
            nextkey = newSVsv(&PL_sv_undef);
            nextvalue = newSVsv(&PL_sv_undef);
        }

        EXTEND(SP, 2);
        PUSHs(sv_2mortal(nextvalue));
        PUSHs(sv_2mortal(newSVsv(nextkey)));
    }
#line 691 "Database.c"
	PUTBACK;
	return;
    }
}

XS(XS_RPM__Database_DESTROY)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: RPM::Database::DESTROY(self)");
    {
	RPM__Database	self;

        if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVHV))
            self = (HV*)SvRV(ST(0));
        else
        {
            rpm_error(aTHX_ RPMERR_BADARG,
                      "RPM::Database::rpmdb_DESTROY: not a blessed HV reference");
            XSRETURN_UNDEF;
        };
#line 534 "Database.xs"
    rpmdb_DESTROY(aTHX_ self);
#line 715 "Database.c"
    }
    XSRETURN_EMPTY;
}

XS(XS_RPM__Database_init)
{
    dXSARGS;
    if (items < 1 || items > 3)
	Perl_croak(aTHX_ "Usage: RPM::Database::init(class, root=NULL, perms=O_RDWR)");
    {
	SV*	class = ST(0);
	const char*	root;
	int	perms;
	int	RETVAL;
	dXSTARG;

	if (items < 2)
	    root = NULL;
	else {
	    if (sv_derived_from(ST(1), "const charPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(1)));
		root = INT2PTR(const char *,tmp);
	    }
	    else
		croak("root is not of type const charPtr");
	}

	if (items < 3)
	    perms = O_RDWR;
	else {
	    perms = (int)SvIV(ST(2));
	}
#line 543 "Database.xs"
    if (! (SvPOK(class) && strcmp(SvPV(class, PL_na), "RPM::Database")))
    {
        rpm_error(aTHX_ RPMERR_BADARG,
                  "RPM::Database::init must be called as a static method");
        ST(0) = sv_2mortal(newSViv(0));
        XSRETURN(1);
    }
#line 756 "Database.c"

	RETVAL = rpmdb_init(class, root, perms);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_RPM__Database_rebuild)
{
    dXSARGS;
    if (items < 1 || items > 2)
	Perl_croak(aTHX_ "Usage: RPM::Database::rebuild(class, root=NULL)");
    {
	SV*	class = ST(0);
	const char*	root;
	int	RETVAL;
	dXSTARG;

	if (items < 2)
	    root = NULL;
	else {
	    if (sv_derived_from(ST(1), "const charPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(1)));
		root = INT2PTR(const char *,tmp);
	    }
	    else
		croak("root is not of type const charPtr");
	}
#line 557 "Database.xs"
    if (! (SvPOK(class) && strcmp(SvPV(class, PL_na), "RPM::Database")))
    {
        rpm_error(aTHX_ RPMERR_BADARG,
                  "RPM::Database::rebuild must be called as a static method");
        ST(0) = sv_2mortal(newSViv(0));
        XSRETURN(1);
    }
#line 793 "Database.c"

	RETVAL = rpmdb_rebuild(class, root);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_RPM__Database_find_by_file)
{
    dXSARGS;
    dXSI32;
    if (items != 2)
       Perl_croak(aTHX_ "Usage: %s(self, string)", GvNAME(CvGV(cv)));
    SP -= items;
    {
	RPM__Database	self;
	SV*	string = ST(1);

        if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVHV))
            self = (HV*)SvRV(ST(0));
        else
        {
            rpm_error(aTHX_ RPMERR_BADARG,
                      "RPM::Database::rpmdb_find_by_file: not a blessed HV reference");
            XSRETURN_UNDEF;
        };
#line 577 "Database.xs"
    {
        AV* matches;
        int len, size;

        if (ix == 0) ix = RPMTAG_BASENAMES;
        matches = rpmdb_find_by_whatever(aTHX_ self, string, ix);
        if ((len = av_len(matches)) != -1)
        {
            /* We have (len+1) elements in the array to put onto the stack */
            size = len + 1;
            EXTEND(SP, size);
            while (len >= 0)
            {
                /* This being a stack and all, we put them in backwards */
                PUSHs(sv_2mortal(newSVsv(*av_fetch(matches, len, FALSE))));
                len--;
            }
        }
        else
            size = 0;

        XSRETURN(size);
    }
#line 844 "Database.c"
	PUTBACK;
	return;
    }
}

#ifdef __cplusplus
extern "C"
#endif
XS(boot_RPM__Database)
{
    dXSARGS;
    char* file = __FILE__;

    {
        CV * cv ;

        newXSproto("RPM::Database::TIEHASH", XS_RPM__Database_TIEHASH, file, "$;$");
        newXSproto("RPM::Database::FETCH", XS_RPM__Database_FETCH, file, "$$");
        newXSproto("RPM::Database::STORE", XS_RPM__Database_STORE, file, "$$$");
        newXSproto("RPM::Database::DELETE", XS_RPM__Database_DELETE, file, "$$");
        newXSproto("RPM::Database::CLEAR", XS_RPM__Database_CLEAR, file, "$");
        newXSproto("RPM::Database::EXISTS", XS_RPM__Database_EXISTS, file, "$$");
        newXSproto("RPM::Database::FIRSTKEY", XS_RPM__Database_FIRSTKEY, file, "$");
        newXSproto("RPM::Database::NEXTKEY", XS_RPM__Database_NEXTKEY, file, "$;$");
        newXSproto("RPM::Database::DESTROY", XS_RPM__Database_DESTROY, file, "$");
        newXSproto("RPM::Database::init", XS_RPM__Database_init, file, "$;$$");
        newXSproto("RPM::Database::rebuild", XS_RPM__Database_rebuild, file, "$;$");
        cv = newXS("RPM::Database::find_by_package", XS_RPM__Database_find_by_file, file);
        XSANY.any_i32 = RPMTAG_NAME ;
        sv_setpv((SV*)cv, "$$") ;
        cv = newXS("RPM::Database::find_what_conflicts", XS_RPM__Database_find_by_file, file);
        XSANY.any_i32 = RPMTAG_CONFLICTNAME ;
        sv_setpv((SV*)cv, "$$") ;
        cv = newXS("RPM::Database::find_what_requires", XS_RPM__Database_find_by_file, file);
        XSANY.any_i32 = RPMTAG_REQUIRENAME ;
        sv_setpv((SV*)cv, "$$") ;
        cv = newXS("RPM::Database::find_by_group", XS_RPM__Database_find_by_file, file);
        XSANY.any_i32 = RPMTAG_GROUP ;
        sv_setpv((SV*)cv, "$$") ;
        cv = newXS("RPM::Database::find_what_provides", XS_RPM__Database_find_by_file, file);
        XSANY.any_i32 = RPMTAG_PROVIDENAME ;
        sv_setpv((SV*)cv, "$$") ;
        cv = newXS("RPM::Database::find_by_file", XS_RPM__Database_find_by_file, file);
        XSANY.any_i32 = 0 ;
        sv_setpv((SV*)cv, "$$") ;
    }
    XSRETURN_YES;
}

