/* protocol.c */
extern void find_frame(struct llcdrv *lld, struct rpl_packet *in);
extern int file_data_frame(struct llcdrv *lld, struct client *c);
extern void send_file_frame(struct llcdrv *lld, struct rpl_packet *in);
extern void rpl_packet_recvd_callback(struct llcdrv *lld, struct rpl_packet *p);
/* rpld.c */
extern int downloading;
extern int pacing;
extern int rpl_sap;
extern int main(int argc, char **argv);
/* util.c */
extern unsigned char ethtoaret[1024];
extern unsigned char *ethtoa(void *in);
extern void daemonize(void);
/* rpl.c */
extern int write_char(unsigned char *ptr, u8 v);
extern int write_short(unsigned char *ptr, u16 v);
extern int write_long(unsigned char *ptr, u32 v);
extern int put_char(unsigned char *ptr, u16 token, u8 value);
extern int put_short(unsigned char *ptr, u16 token, u16 value);
extern int put_long(unsigned char *ptr, u16 token, u32 value);
extern int put_mac(unsigned char *ptr, u16 token, unsigned char *mac);
extern void rpl_send_packet(struct llcdrv *lld, unsigned char *d, struct rpl_packet *p);
extern void rpl_packet_recvd(struct llcdrv *lld, unsigned char *pptr, int plen);
/* client.c */
extern struct client *clients;
extern void cache_locally(struct clfile *f);
extern struct client *find_client_by_mac(unsigned char *mac);
extern void client_calc_offsets(struct client *c);
extern void client_get_block(struct client *c, struct rpl_packet *p);
extern int client_last_block(struct client *c);
extern void client_flush_cache(struct client *c);
extern int clients_check_status(void);
extern int client_dispatch(struct llcdrv *lld);
/* config.c */
extern void do_linux_kernel(struct client *c, struct clfile *f);
extern void parse_config(char *filename);
