/*
 *  contact-data.h       -
 *
 *  Created: 20011223
 *
 *  Copyright (c) 2001 by Tomasz Trojanowski
 *  All rights reserved
 *
 *  $Id: contact-data.h,v 1.32 2002/02/01 23:16:23 tomek Exp $
 *
 */

#ifndef __CONTACT_DATA_H
#define __CONTACT_DATA_H

#include <gtk/gtk.h>

#define MAX_PREFIX_NAME      20
#define MAX_FIRST_NAME       40
#define MAX_MIDDLE_NAME      40
#define MAX_LAST_NAME        40
#define MAX_SUFIX_NAME       10
#define MAX_FIRM_NAME        40
#define MAX_POSITION_NAME    40
#define MAX_SAVE_AS         200
#define MAX_STREET          200
#define MAX_CITY             40
#define MAX_STATE            40
#define MAX_ZIP              10
#define MAX_COUNTRY          40
#define MAX_PHONE_COUNTRY    10
#define MAX_PHONE_REGION     10
#define MAX_PHONE_NUMBER     20
#define MAX_EMAIL            50
#define MAX_WWW              50

/* Typ wyliczeniowy sucy do okrelania rodzaju adresu. */
typedef enum
{
    ADDRESS_TYPE_HOME  = 0,
    ADDRESS_TYPE_WORK  = 1,
    ADDRESS_TYPE_OTHER = 2,
    /* Staa uywana w polu send_to struktury contact_data dla okrelenia,
       e nie zosta okrelony aden adres wysykowy. */
    ADDRESS_TYPE_NONE  = 3
} address_type_enum;

/* Typ wyliczeniowy sucy do okrelania rodzaju telefonu. */
typedef enum
{
    PHONE_TYPE_ASSISTENT =  0,
    PHONE_TYPE_HOME      =  1,
    PHONE_TYPE_HOME2     =  2,
    PHONE_TYPE_FAX_HOME  =  3,
    PHONE_TYPE_FAX_WORK  =  4,
    PHONE_TYPE_FIRM      =  5,
    PHONE_TYPE_OTHER     =  6,
    PHONE_TYPE_FAX_OTHER =  7,
    PHONE_TYPE_ISDN      =  8,
    PHONE_TYPE_PAGER     =  9,
    PHONE_TYPE_BASIC     = 10,
    PHONE_TYPE_WORK      = 11,
    PHONE_TYPE_WORK2     = 12,
    PHONE_TYPE_RADIO     = 13,
    PHONE_TYPE_CAR       = 14,
    PHONE_TYPE_MOBILE    = 15,
    PHONE_TYPE_TELEX     = 16,
    PHONE_TYPE_TTY_TDD   = 17,
    PHONE_TYPE_CALLBACK  = 18
} phone_type_enum;

/* Typ wyliczeniowy sucy do okrelenia
   numeru listy wyboru rodzaju telefonu. */
typedef enum
{
    PHONE_POS_1 = 0x0000,
    PHONE_POS_2 = 0x0100,
    PHONE_POS_3 = 0x0200,
    PHONE_POS_4 = 0x0300
} phone_pos_enum;

/* Typ wyliczeniowy sucy do okrelania rodzaju adresu e-mail. */
typedef enum
{
    EMAIL_TYPE_1 = 0,
    EMAIL_TYPE_2 = 1,
    EMAIL_TYPE_3 = 2
} email_type_enum;

/* Struktura suca do przechowywania adresw. */
typedef struct
{
    gboolean modified;

    int id;
    char street[MAX_STREET];
    char city[MAX_CITY];
    char state[MAX_STATE];
    char zip[MAX_ZIP];
    char country[MAX_COUNTRY];
} address_data;

/* Struktura suca do przechowywania numeru telefonu. */
typedef struct
{
    gboolean modified;
    
    int id;
    char country[MAX_PHONE_COUNTRY];
    char region[MAX_PHONE_REGION];
    char number[MAX_PHONE_NUMBER];
} phone_data;

/* Struktura suca do przechowywania adresw e-mail. */
typedef struct
{
    gboolean modified;
    
    int id;
    char value[MAX_EMAIL];
} email_data;

/* Struktura suca do przechowywania danych kontaktu. */
typedef struct
{
    GtkWidget *contact_window;
    GtkWidget *sub_dialog;
    
    /* Pole okrelajce czy zostay zmodyfikowane dane
       na pierwszym poziomie struktury danych kontaktu. */
    gboolean modified;
    /* Pole okrelajce czy zostay zmodyfikowane
       dane w caej strukturze danych kontaktu */
    gboolean global_modified;

    int id;    
    char prefix_name[MAX_PREFIX_NAME];
    char first_name[MAX_FIRST_NAME];
    char middle_name[MAX_MIDDLE_NAME];
    char last_name[MAX_LAST_NAME];
    char sufix_name[MAX_SUFIX_NAME];
    char firm_name[MAX_FIRM_NAME];
    char position[MAX_POSITION_NAME];
    char save_as[MAX_SAVE_AS];
    
    address_type_enum address_type;
    address_data address[3];
    address_type_enum send_to;
    
    phone_type_enum phone_type[4];
    /* Okrela rodzaj telefonu ktry jest aktualnie
       przypisany do okienka dialogowego */
    int phone_pos;
    phone_data phone[19];
    
    email_type_enum email_type;
    email_data email[3];
    char www[MAX_WWW];
} contact_data;

/* Funkcja zerujca struktur danych kontaktu. */
void clear_contact_data(contact_data *data);

/* Funkcja zwracajca wskanik do acucha zawierajacego pene imi i nazwisko utworzony na
   podstawie poszczeglnych jego elementw. */
gchar *get_full_name(contact_data *data);

/* Funkcja tworzca pene imi i nazwisko na podstawie poszczeglnych jego
   elementw, a nastepnie wstawiajca t warto do pola imienia i nazwiska
   okienka kontaktw. */
void create_full_name(contact_data *data);

/* Funkcja tworzca list elementw do listy wyboru "Zapisz jako" na podstawie
   poszcczeglnych elementw imienia i nazwiska, a nastepnie wstawiajca t
   warto do listy wyboru. */
void create_save_as_list(contact_data *data);

/* Funkcja tworzca peny adres na podstawie poszczeglnych jego elementw,
   a nastepnie wstawiajca t warto do pola tekstowego adresu okienka
   kontaktu. */
void create_full_address(contact_data *data);

/* Funkcja zwracajca wskanik do acucha zawierajacego peny numer telefonu na podstawie
   poszczeglnych jego elementw. */
gchar *get_full_phone(contact_data *data, phone_type_enum phone_type);

/* Funkcja tworzca peny numer telefonu na podstawie poszczeglnych jego
   elementw, a nastepnie wstawiajca t warto do pola tekstowego numeru
   telefonu okienka kontaktu. */
void create_full_phone(contact_data *data, guint phone_pos);

#endif    /*  __CONTACT_DATA  */
