/*
 *  appointment-list.c   -
 *
 *  Created: 20020225
 *
 *  Copyright (c) 2001, 2002 by Tomasz Trojanowski
 *  All rights reserved
 *
 *  $Id: appointment-list.c,v 1.17 2002/03/19 19:33:55 tomek Exp $
 *
 */

#ifdef __HAVE_CONFIG_H
# include <config.h>
#endif

#include <appointment-list.h>

#include <intl.h>

/* Struktura zawierajaca nazwy i domylne szerokoci pl listy terminw. */
fields_list_item_type appointment_list_items[] = 
{
    { N_("ID"),          30 },
    { N_("Summary"),    100 },
    { N_("Location"),   100 },
    { N_("Start time"), 100 },
    { N_("End time"),   100 }
};

/* Funkcja zwracajca wskanik do acucha zawierajacego tekst zadanego pola struktury
   danych terminu. */
gchar *get_appointment_field_value(appointment_data *item, gint field_id)
{
    gchar *result;
    
    switch (field_id)
    {
        case IDAF_ID:
	    result = g_strdup_printf("%6d", item->id);
	    break;
	case IDAF_SUMMARY:
	    result = g_strdup(item->summary);
	    break;
	case IDAF_LOCATION:
	    result = g_strdup(item->location);
	    break;
	case IDAF_START_DATE:
	    result = g_strdup_printf("%04d-%02d-%02d %02d:%02d",
	                             item->start_year, item->start_month, item->start_day,
				     item->start_hour, item->start_mins);
	    break;
	case IDAF_END_DATE:
	    result = g_strdup_printf("%04d-%02d-%02d %02d:%02d",
	                             item->end_year, item->end_month, item->end_day,
				     item->end_hour, item->end_mins);
	    break;
    }
    
    return result;
}
